---
UID: NE:vdshwprv._VDS_OBJECT_TYPE
title: VDS_OBJECT_TYPE (vdshwprv.h)
description: Defines the set of valid types of a VDS object.
old-location: base\vds_object_type.htm
tech.root: VDS
ms.assetid: 63997e08-b6d3-4011-8946-56ef9832c0e4
ms.date: 12/05/2018
ms.keywords: VDS_OBJECT_TYPE, VDS_OBJECT_TYPE enumeration [VDS], VDS_OT_ASYNC, VDS_OT_CONTROLLER, VDS_OT_DISK, VDS_OT_DRIVE, VDS_OT_ENUM, VDS_OT_HBAPORT, VDS_OT_INIT_ADAPTER, VDS_OT_INIT_PORTAL, VDS_OT_LUN, VDS_OT_LUN_PLEX, VDS_OT_OPEN_VDISK, VDS_OT_PACK, VDS_OT_PORT, VDS_OT_PORTAL, VDS_OT_PORTAL_GROUP, VDS_OT_PROVIDER, VDS_OT_STORAGE_POOL, VDS_OT_SUB_SYSTEM, VDS_OT_TARGET, VDS_OT_UNKNOWN, VDS_OT_VDISK, VDS_OT_VOLUME, VDS_OT_VOLUME_PLEX, base.vds_object_type, vds/VDS_OBJECT_TYPE, vds/VDS_OT_ASYNC, vds/VDS_OT_CONTROLLER, vds/VDS_OT_DISK, vds/VDS_OT_DRIVE, vds/VDS_OT_ENUM, vds/VDS_OT_HBAPORT, vds/VDS_OT_INIT_ADAPTER, vds/VDS_OT_INIT_PORTAL, vds/VDS_OT_LUN, vds/VDS_OT_LUN_PLEX, vds/VDS_OT_OPEN_VDISK, vds/VDS_OT_PACK, vds/VDS_OT_PORT, vds/VDS_OT_PORTAL, vds/VDS_OT_PORTAL_GROUP, vds/VDS_OT_PROVIDER, vds/VDS_OT_STORAGE_POOL, vds/VDS_OT_SUB_SYSTEM, vds/VDS_OT_TARGET, vds/VDS_OT_UNKNOWN, vds/VDS_OT_VDISK, vds/VDS_OT_VOLUME, vds/VDS_OT_VOLUME_PLEX, vdshwprv/VDS_OBJECT_TYPE, vdshwprv/VDS_OT_ASYNC, vdshwprv/VDS_OT_CONTROLLER, vdshwprv/VDS_OT_DISK, vdshwprv/VDS_OT_DRIVE, vdshwprv/VDS_OT_ENUM, vdshwprv/VDS_OT_HBAPORT, vdshwprv/VDS_OT_INIT_ADAPTER, vdshwprv/VDS_OT_INIT_PORTAL, vdshwprv/VDS_OT_LUN, vdshwprv/VDS_OT_LUN_PLEX, vdshwprv/VDS_OT_OPEN_VDISK, vdshwprv/VDS_OT_PACK, vdshwprv/VDS_OT_PORT, vdshwprv/VDS_OT_PORTAL, vdshwprv/VDS_OT_PORTAL_GROUP, vdshwprv/VDS_OT_PROVIDER, vdshwprv/VDS_OT_STORAGE_POOL, vdshwprv/VDS_OT_SUB_SYSTEM, vdshwprv/VDS_OT_TARGET, vdshwprv/VDS_OT_UNKNOWN, vdshwprv/VDS_OT_VDISK, vdshwprv/VDS_OT_VOLUME, vdshwprv/VDS_OT_VOLUME_PLEX
f1_keywords:
- vdshwprv/VDS_OBJECT_TYPE
dev_langs:
- c++
req.header: vdshwprv.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vds.h
- VdsHwPrv.h
api_name:
- VDS_OBJECT_TYPE
targetos: Windows
req.typenames: VDS_OBJECT_TYPE
req.redist: 
ms.custom: 19H1
---

# VDS_OBJECT_TYPE enumeration


## -description


<p class="CCE_Message">[Beginning with Windows 8 and Windows Server 2012, the <a href="https://docs.microsoft.com/windows/desktop/VDS/virtual-disk-service-portal">Virtual Disk Service</a> COM interface is superseded by the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/stormgmt/windows-storage-management-api-portal">Windows Storage Management API</a>.]

Defines the set of 
   valid types of a VDS object.


## -enum-fields




### -field VDS_OT_UNKNOWN

This value is reserved.


### -field VDS_OT_PROVIDER

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/provider-object">provider</a>.


### -field VDS_OT_PACK

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/pack-object">disk pack</a>.


### -field VDS_OT_VOLUME

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/volume-object">volume</a>.


### -field VDS_OT_VOLUME_PLEX

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/volume-plex-object">volume plex</a>.


### -field VDS_OT_DISK

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/disk-object">disk</a>.


### -field VDS_OT_SUB_SYSTEM

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/subsystem-object">subsystem</a>.


### -field VDS_OT_CONTROLLER

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/controller-object">controller</a>.


### -field VDS_OT_DRIVE

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/drive-object">drive</a>.


### -field VDS_OT_LUN

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/lun-object">LUN</a>.


### -field VDS_OT_LUN_PLEX

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/lun-plex-object">LUN plex</a>.


### -field VDS_OT_PORT

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/controller-port-object">controller port</a>.


### -field VDS_OT_PORTAL

The object is an <a href="https://docs.microsoft.com/windows/desktop/VDS/portal-object">iSCSI portal</a>.


### -field VDS_OT_TARGET

The object is an <a href="https://docs.microsoft.com/windows/desktop/VDS/target-object">iSCSI target</a>.


### -field VDS_OT_PORTAL_GROUP

The object is an <a href="https://docs.microsoft.com/windows/desktop/VDS/portal-group-object">iSCSI portal group</a>.


### -field VDS_OT_STORAGE_POOL

The object is a <a href="https://docs.microsoft.com/windows/desktop/VDS/storage-pool-object">storage pool</a>.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>Not supported.


### -field VDS_OT_HBAPORT

The object is an <a href="https://docs.microsoft.com/windows/desktop/VDS/startup-and-service-objects">HBA port</a>.


### -field VDS_OT_INIT_ADAPTER

The object is an <a href="https://docs.microsoft.com/windows/desktop/VDS/startup-and-service-objects">iSCSI initiator adapter</a>.


### -field VDS_OT_INIT_PORTAL

The object is an <a href="https://docs.microsoft.com/windows/desktop/VDS/startup-and-service-objects">iSCSI initiator portal</a>.


### -field VDS_OT_ASYNC

This value is reserved.


### -field VDS_OT_ENUM

This value is reserved.


### -field VDS_OT_VDISK

The object is a virtual disk.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>Not supported.


### -field VDS_OT_OPEN_VDISK

This value is reserved.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>Not supported.


## -remarks



The <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdsproviderprivate-getobject">IVdsProviderPrivate::GetObject</a> 
    and <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsservice-getobject">IVdsService::GetObject</a> methods pass a <b>VDS_OBJECT_TYPE</b> 
    value as an argument to indicate an object type.

<div class="alert"><b>Note</b>  Additional constants might be added to the <b>VDS_OBJECT_TYPE</b> enumeration in future Windows versions. For this reason, your application must be designed to gracefully handle an unrecognized <b>VDS_OBJECT_TYPE</b> enumeration constant.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdsproviderprivate-getobject">IVdsProviderPrivate::GetObject</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsservice-getobject">IVdsService::GetObject</a>



<a href="https://docs.microsoft.com/windows/desktop/VDS/vds-enumerations">VDS Enumerations</a>
 

 

