---
UID: NE:vdshwprv._VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG
title: VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG (vdshwprv.h)
description: Defines the set of RAID levels that can be supported by subsystems.
old-location: base\vds_sub_system_supported_raid_type_flag.htm
tech.root: VDS
ms.assetid: 0ee75959-f55c-43c9-b58c-a62b0544dcda
ms.date: 12/05/2018
ms.keywords: '*PVDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG, VDS_SF_SUPPORTS_RAID01_LUNS, VDS_SF_SUPPORTS_RAID03_LUNS, VDS_SF_SUPPORTS_RAID05_LUNS, VDS_SF_SUPPORTS_RAID10_LUNS, VDS_SF_SUPPORTS_RAID15_LUNS, VDS_SF_SUPPORTS_RAID2_LUNS, VDS_SF_SUPPORTS_RAID30_LUNS, VDS_SF_SUPPORTS_RAID3_LUNS, VDS_SF_SUPPORTS_RAID4_LUNS, VDS_SF_SUPPORTS_RAID50_LUNS, VDS_SF_SUPPORTS_RAID51_LUNS, VDS_SF_SUPPORTS_RAID53_LUNS, VDS_SF_SUPPORTS_RAID5_LUNS, VDS_SF_SUPPORTS_RAID60_LUNS, VDS_SF_SUPPORTS_RAID61_LUNS, VDS_SF_SUPPORTS_RAID6_LUNS, VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG, VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG enumeration, base.vds_sub_system_supported_raid_type_flag, vds/VDS_SF_SUPPORTS_RAID01_LUNS, vds/VDS_SF_SUPPORTS_RAID03_LUNS, vds/VDS_SF_SUPPORTS_RAID05_LUNS, vds/VDS_SF_SUPPORTS_RAID10_LUNS, vds/VDS_SF_SUPPORTS_RAID15_LUNS, vds/VDS_SF_SUPPORTS_RAID2_LUNS, vds/VDS_SF_SUPPORTS_RAID30_LUNS, vds/VDS_SF_SUPPORTS_RAID3_LUNS, vds/VDS_SF_SUPPORTS_RAID4_LUNS, vds/VDS_SF_SUPPORTS_RAID50_LUNS, vds/VDS_SF_SUPPORTS_RAID51_LUNS, vds/VDS_SF_SUPPORTS_RAID53_LUNS, vds/VDS_SF_SUPPORTS_RAID5_LUNS, vds/VDS_SF_SUPPORTS_RAID60_LUNS, vds/VDS_SF_SUPPORTS_RAID61_LUNS, vds/VDS_SF_SUPPORTS_RAID6_LUNS, vds/VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG, vdshwprv/VDS_SF_SUPPORTS_RAID01_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID03_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID05_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID10_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID15_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID2_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID30_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID3_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID4_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID50_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID51_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID53_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID5_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID60_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID61_LUNS, vdshwprv/VDS_SF_SUPPORTS_RAID6_LUNS, vdshwprv/VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG'
f1_keywords:
- vdshwprv/VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG
dev_langs:
- c++
req.header: vdshwprv.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vds.h
- VdsHwPrv.h
api_name:
- VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG
targetos: Windows
req.typenames: VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG, *PVDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG
req.redist: 
ms.custom: 19H1
---

# VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG enumeration


## -description


<p class="CCE_Message">[Beginning with Windows 8 and Windows Server 2012, the <a href="https://docs.microsoft.com/windows/desktop/VDS/virtual-disk-service-portal">Virtual Disk Service</a> COM interface is superseded by the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/stormgmt/windows-storage-management-api-portal">Windows Storage Management API</a>.]

Defines the set of RAID levels that can be supported by subsystems.


## -enum-fields




### -field VDS_SF_SUPPORTS_RAID2_LUNS

Supports RAID level 2.


### -field VDS_SF_SUPPORTS_RAID3_LUNS

Supports RAID level 3.


### -field VDS_SF_SUPPORTS_RAID4_LUNS

Supports RAID level 4.


### -field VDS_SF_SUPPORTS_RAID5_LUNS

Supports RAID level 5.


### -field VDS_SF_SUPPORTS_RAID6_LUNS

Supports RAID level 6.


### -field VDS_SF_SUPPORTS_RAID01_LUNS

Supports RAID level 0+1.


### -field VDS_SF_SUPPORTS_RAID03_LUNS

Supports RAID level 0+3.


### -field VDS_SF_SUPPORTS_RAID05_LUNS

Supports RAID level 0+5.


### -field VDS_SF_SUPPORTS_RAID10_LUNS

Supports RAID level 1+0.


### -field VDS_SF_SUPPORTS_RAID15_LUNS

Supports RAID level 1+5.


### -field VDS_SF_SUPPORTS_RAID30_LUNS

Supports RAID level 3+0.


### -field VDS_SF_SUPPORTS_RAID50_LUNS

Supports RAID level 5+0.


### -field VDS_SF_SUPPORTS_RAID51_LUNS

Supports RAID level 5+1.


### -field VDS_SF_SUPPORTS_RAID53_LUNS

Supports RAID level 5+3.


### -field VDS_SF_SUPPORTS_RAID60_LUNS

Supports RAID level 6+0.


### -field VDS_SF_SUPPORTS_RAID61_LUNS

Supports RAID level 6+1.


## -remarks



The values of this enumeration are used in the <b>ulSupportedRaidTypeFlags</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ns-vdshwprv-vds_sub_system_prop2">VDS_SUB_SYSTEM_PROP2</a> structure.

<div class="alert"><b>Note</b>  Additional constants might be added to the <b>VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG</b> enumeration in future Windows versions. For this reason, your application must be designed to gracefully handle an unrecognized <b>VDS_SUB_SYSTEM_SUPPORTED_RAID_TYPE_FLAG</b> enumeration constant.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nn-vdshwprv-ivdssubsystem2">IVdsSubSystem2</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdssubsystem2-getproperties2">IVdsSubSystem2::GetProperties2</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_raid_type">VDS_RAID_TYPE</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ns-vdshwprv-vds_sub_system_prop2">VDS_SUB_SYSTEM_PROP2</a>
 

 

