---
UID: NF:vfw.AVIStreamPrevKeyFrameTime
title: AVIStreamPrevKeyFrameTime macro (vfw.h)
description: The AVIStreamPrevKeyFrameTime macro returns the time of the previous key frame in the stream, starting at a given time.
old-location: multimedia\avistreamprevkeyframetime.htm
tech.root: Multimedia
ms.assetid: 0da49be2-b017-4d41-b9da-3c1310fa0289
ms.date: 12/05/2018
ms.keywords: AVIStreamPrevKeyFrameTime, AVIStreamPrevKeyFrameTime macro [Windows Multimedia], _win32_AVIStreamPrevKeyFrameTime, multimedia.avistreamprevkeyframetime, vfw/AVIStreamPrevKeyFrameTime
f1_keywords:
- vfw/AVIStreamPrevKeyFrameTime
dev_langs:
- c++
req.header: vfw.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vfw.h
api_name:
- AVIStreamPrevKeyFrameTime
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# AVIStreamPrevKeyFrameTime macro


## -description



The <b>AVIStreamPrevKeyFrameTime</b> macro returns the time of the previous key frame in the stream, starting at a given time.




## -parameters




### -param pavi

Handle to an open stream. 


### -param t

Position in the stream to begin searching. 


## -remarks



The search performed by this macro includes the frame that corresponds to the specified time.

The <b>AVIStreamPrevKeyFrameTime</b> macro is defined as follows:


```cpp

#define AVIStreamPrevKeyFrameTime(pavi, time) \ 
    AVIStreamSampleToTime(pavi, AVIStreamPrevKeyFrame(pavi, 
    AVIStreamTimeToSample(pavi, time))) 

```





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Multimedia/avifile-functions-and-macros">AVIFile Functions and Macros</a>



<a href="https://docs.microsoft.com/windows/desktop/Multimedia/avifile-macros">AVIFile Macros</a>
 

 

