---
UID: NF:vfw.capDriverDisconnect
title: capDriverDisconnect macro (vfw.h)
description: The capDriverDisconnect macro disconnects a capture driver from a capture window. You can use this macro or explicitly send the WM_CAP_DRIVER_DISCONNECT message.
old-location: multimedia\capdriverdisconnect.htm
tech.root: Multimedia
ms.assetid: c009adb4-bc73-4d0d-9ab1-801e92e8851f
ms.date: 12/05/2018
ms.keywords: _win32_capDriverDisconnect, capDriverDisconnect, capDriverDisconnect macro [Windows Multimedia], multimedia.capdriverdisconnect, vfw/capDriverDisconnect
f1_keywords:
- vfw/capDriverDisconnect
dev_langs:
- c++
req.header: vfw.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vfw.h
api_name:
- capDriverDisconnect
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# capDriverDisconnect macro


## -description



The <b>capDriverDisconnect</b> macro disconnects a capture driver from a capture window. You can use this macro or explicitly send the <a href="https://docs.microsoft.com/windows/desktop/Multimedia/wm-cap-driver-disconnect">WM_CAP_DRIVER_DISCONNECT</a> message.




## -parameters




### -param hwnd

Handle to a capture window. 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Multimedia/video-capture">Video Capture</a>



<a href="https://docs.microsoft.com/windows/desktop/Multimedia/video-capture-macros">Video Capture Macros</a>
 

 

