---
UID: NF:vfw.capEditCopy
title: capEditCopy macro (vfw.h)
description: The capEditCopy macro copies the contents of the video frame buffer and associated palette to the clipboard. You can use this macro or explicitly send the WM_CAP_EDIT_COPY message.
old-location: multimedia\capeditcopy.htm
tech.root: Multimedia
ms.assetid: 25b16107-b2ec-4e16-a596-10708dbc639d
ms.date: 12/05/2018
ms.keywords: _win32_capEditCopy, capEditCopy, capEditCopy macro [Windows Multimedia], multimedia.capeditcopy, vfw/capEditCopy
f1_keywords:
- vfw/capEditCopy
dev_langs:
- c++
req.header: vfw.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vfw.h
api_name:
- capEditCopy
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# capEditCopy macro


## -description



The <b>capEditCopy</b> macro copies the contents of the video frame buffer and associated palette to the clipboard. You can use this macro or explicitly send the <a href="https://docs.microsoft.com/windows/desktop/Multimedia/wm-cap-edit-copy">WM_CAP_EDIT_COPY</a> message.




## -parameters




### -param hwnd

Handle to a capture window. 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Multimedia/video-capture">Video Capture</a>



<a href="https://docs.microsoft.com/windows/desktop/Multimedia/video-capture-macros">Video Capture Macros</a>
 

 

