---
UID: NF:vfw.capGetUserData
title: capGetUserData macro (vfw.h)
description: The capGetUserData macro retrieves a LONG_PTR data value associated with a capture window. You can use this macro or explicitly call the WM_CAP_GET_USER_DATA message.
old-location: multimedia\capgetuserdata.htm
tech.root: Multimedia
ms.assetid: a71afead-9beb-48d0-9e7f-d948e0fe276f
ms.date: 12/05/2018
ms.keywords: _win32_capGetUserData, capGetUserData, capGetUserData macro [Windows Multimedia], multimedia.capgetuserdata, vfw/capGetUserData
f1_keywords:
- vfw/capGetUserData
dev_langs:
- c++
req.header: vfw.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vfw.h
api_name:
- capGetUserData
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# capGetUserData macro


## -description



The <b>capGetUserData</b> macro retrieves a <b>LONG_PTR</b> data value associated with a capture window. You can use this macro or explicitly call the <a href="https://docs.microsoft.com/windows/desktop/Multimedia/wm-cap-get-user-data">WM_CAP_GET_USER_DATA</a> message.




## -parameters




### -param hwnd

Handle to a capture window. 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Multimedia/video-capture">Video Capture</a>



<a href="https://docs.microsoft.com/windows/desktop/Multimedia/video-capture-macros">Video Capture Macros</a>
 

 

