---
UID: NF:vfw.MCIWndGetSpeed
title: MCIWndGetSpeed macro (vfw.h)
description: The MCIWndGetSpeed macro retrieves the playback speed of an MCI device. You can use this macro or explicitly send the MCIWNDM_GETSPEED message.
old-location: multimedia\mciwndgetspeed.htm
tech.root: Multimedia
ms.assetid: d327b649-8c1e-4219-a1ec-8f89e3a9a33e
ms.date: 12/05/2018
ms.keywords: MCIWndGetSpeed, MCIWndGetSpeed macro [Windows Multimedia], _win32_MCIWndGetSpeed, multimedia.mciwndgetspeed, vfw/MCIWndGetSpeed
f1_keywords:
- vfw/MCIWndGetSpeed
dev_langs:
- c++
req.header: vfw.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vfw.h
api_name:
- MCIWndGetSpeed
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# MCIWndGetSpeed macro


## -description



The <b>MCIWndGetSpeed</b> macro retrieves the playback speed of an MCI device. You can use this macro or explicitly send the <a href="https://docs.microsoft.com/windows/desktop/Multimedia/mciwndm-getspeed">MCIWNDM_GETSPEED</a> message.




## -parameters




### -param hwnd

Handle of the MCIWnd window. 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Multimedia/mciwndm-getspeed">MCIWNDM_GETSPEED</a>
 

 

