---
UID: NE:virtdisk._RESIZE_VIRTUAL_DISK_VERSION
title: RESIZE_VIRTUAL_DISK_VERSION (virtdisk.h)
description: Enumerates the possible versions for parameters for the ResizeVirtualDisk function.
old-location: vstor\resize_virtual_disk_version.htm
tech.root: VStor
ms.assetid: 779381fb-4433-46c5-8caf-b830cd015c95
ms.date: 12/05/2018
ms.keywords: RESIZE_VIRTUAL_DISK_VERSION, RESIZE_VIRTUAL_DISK_VERSION enumeration [Virtual Storage], RESIZE_VIRTUAL_DISK_VERSION_1, RESIZE_VIRTUAL_DISK_VERSION_UNSPECIFIED, virtdisk/RESIZE_VIRTUAL_DISK_VERSION, virtdisk/RESIZE_VIRTUAL_DISK_VERSION_1, virtdisk/RESIZE_VIRTUAL_DISK_VERSION_UNSPECIFIED, vstor.resize_virtual_disk_version
f1_keywords:
- virtdisk/RESIZE_VIRTUAL_DISK_VERSION
dev_langs:
- c++
req.header: virtdisk.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 8
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- VirtDisk.h
api_name:
- RESIZE_VIRTUAL_DISK_VERSION
targetos: Windows
req.typenames: RESIZE_VIRTUAL_DISK_VERSION
req.redist: 
ms.custom: 19H1
---

# RESIZE_VIRTUAL_DISK_VERSION enumeration


## -description


Enumerates the possible versions for parameters for the 
    <a href="https://docs.microsoft.com/windows/desktop/api/virtdisk/nf-virtdisk-resizevirtualdisk">ResizeVirtualDisk</a> function.


## -enum-fields




### -field RESIZE_VIRTUAL_DISK_VERSION_UNSPECIFIED

The version is not valid.


### -field RESIZE_VIRTUAL_DISK_VERSION_1

Version one of the parameters is used. This is the only supported value.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/virtdisk/ns-virtdisk-resize_virtual_disk_parameters">RESIZE_VIRTUAL_DISK_PARAMETERS</a>



<a href="https://docs.microsoft.com/windows/desktop/api/virtdisk/nf-virtdisk-resizevirtualdisk">ResizeVirtualDisk</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/dd323698(v=vs.85)">VHD Enumerations</a>
 

 

