---
UID: NE:virtdisk._STORAGE_DEPENDENCY_INFO_VERSION
title: STORAGE_DEPENDENCY_INFO_VERSION (virtdisk.h)
description: Contains the version of the virtual hard disk (VHD) STORAGE_DEPENDENCY_INFO structure to use in calls to VHD functions.
old-location: vhd\storage_dependency_info_version.htm
tech.root: VStor
ms.assetid: 80437477-3f5e-4dac-a773-9339c5b742e2
ms.date: 12/05/2018
ms.keywords: STORAGE_DEPENDENCY_INFO_VERSION, STORAGE_DEPENDENCY_INFO_VERSION enumeration [VHD], STORAGE_DEPENDENCY_INFO_VERSION_1, STORAGE_DEPENDENCY_INFO_VERSION_2, STORAGE_DEPENDENCY_INFO_VERSION_UNSPECIFIED, vdssys/STORAGE_DEPENDENCY_INFO_VERSION, vdssys/STORAGE_DEPENDENCY_INFO_VERSION_1, vdssys/STORAGE_DEPENDENCY_INFO_VERSION_2, vdssys/STORAGE_DEPENDENCY_INFO_VERSION_UNSPECIFIED, vhd.storage_dependency_info_version, virtdisk/STORAGE_DEPENDENCY_INFO_VERSION, virtdisk/STORAGE_DEPENDENCY_INFO_VERSION_1, virtdisk/STORAGE_DEPENDENCY_INFO_VERSION_2, virtdisk/STORAGE_DEPENDENCY_INFO_VERSION_UNSPECIFIED
f1_keywords:
- virtdisk/STORAGE_DEPENDENCY_INFO_VERSION
dev_langs:
- c++
req.header: virtdisk.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7
req.target-min-winversvr: Windows Server 2008 R2
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- VirtDisk.h
- vdssys.h
api_name:
- STORAGE_DEPENDENCY_INFO_VERSION
targetos: Windows
req.typenames: STORAGE_DEPENDENCY_INFO_VERSION
req.redist: 
ms.custom: 19H1
---

# STORAGE_DEPENDENCY_INFO_VERSION enumeration


## -description


Contains the version of the virtual hard disk (VHD) [STORAGE_DEPENDENCY_INFO](/windows/win32/api/virtdisk/ns-virtdisk-storage_dependency_info)a> structure to use in calls to VHD functions.


## -enum-fields




### -field STORAGE_DEPENDENCY_INFO_VERSION_UNSPECIFIED

The version is not specified.


### -field STORAGE_DEPENDENCY_INFO_VERSION_1

Specifies <a href="https://docs.microsoft.com/windows/win32/api/virtdisk/ns-virtdisk-storage_dependency_info_type_1">STORAGE_DEPENDENCY_INFO_TYPE_1</a>.


### -field STORAGE_DEPENDENCY_INFO_VERSION_2

Specifies <a href="https://docs.microsoft.com/windows/win32/api/virtdisk/ns-virtdisk-storage_dependency_info_type_2">STORAGE_DEPENDENCY_INFO_TYPE_2</a>.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/dd323654(v=vs.85)">About VHD</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/dd323700(v=vs.85)">VHD Reference</a>
 

 

