---
UID: NN:vsmgmt.IVssDifferentialSoftwareSnapshotMgmt
title: IVssDifferentialSoftwareSnapshotMgmt (vsmgmt.h)
description: Contains methods that allow applications to query and manage shadow copy storage areas generated by the system shadow copy provider.
old-location: base\ivssdifferentialsoftwaresnapshotmgmt.htm
tech.root: VSS
ms.assetid: d322981f-1916-4d38-9d05-bc3db2cd596d
ms.date: 12/05/2018
ms.keywords: IVssDifferentialSoftwareSnapshotMgmt, IVssDifferentialSoftwareSnapshotMgmt interface [Files], IVssDifferentialSoftwareSnapshotMgmt interface [Files],described, base.ivssdifferentialsoftwaresnapshotmgmt, vsmgmt/IVssDifferentialSoftwareSnapshotMgmt
f1_keywords:
- vsmgmt/IVssDifferentialSoftwareSnapshotMgmt
dev_langs:
- c++
req.header: vsmgmt.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- VsMgmt.h
api_name:
- IVssDifferentialSoftwareSnapshotMgmt
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IVssDifferentialSoftwareSnapshotMgmt interface


## -description


The 
    <b>IVssDifferentialSoftwareSnapshotMgmt</b> 
    interface contains methods that allow applications to query and manage shadow copy storage areas 
    generated by the system shadow copy provider.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IVssDifferentialSoftwareSnapshotMgmt</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IVssDifferentialSoftwareSnapshotMgmt</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IVssDifferentialSoftwareSnapshotMgmt</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="inherited;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/vsmgmt/nf-vsmgmt-ivssdifferentialsoftwaresnapshotmgmt-adddiffarea">AddDiffArea</a>
</td>
<td align="left" width="63%">
Adds a diff area association for a certain volume.</p> (Inherited from <b>IVssDifferentialSoftwareSnapshotMgmt</b>)</td>
</tr>
<tr data="inherited;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/vsmgmt/nf-vsmgmt-ivssdifferentialsoftwaresnapshotmgmt-changediffareamaximumsize">ChangeDiffAreaMaximumSize</a>
</td>
<td align="left" width="63%">
Updates the shadow copy storage area maximum size for a certain volume.</p> (Inherited from <b>IVssDifferentialSoftwareSnapshotMgmt</b>)</td>
</tr>
<tr data="inherited;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/vsmgmt/nf-vsmgmt-ivssdifferentialsoftwaresnapshotmgmt-querydiffareasforsnapshot">QueryDiffAreasForSnapshot</a>
</td>
<td align="left" width="63%">
Queries shadow copy storage  areas in use by the given shadow copy.</p> (Inherited from <b>IVssDifferentialSoftwareSnapshotMgmt</b>)</td>
</tr>
<tr data="inherited;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/vsmgmt/nf-vsmgmt-ivssdifferentialsoftwaresnapshotmgmt-querydiffareasforvolume">QueryDiffAreasForVolume</a>
</td>
<td align="left" width="63%">
Queries shadow copy storage areas that host shadow copies on the given volume.</p> (Inherited from <b>IVssDifferentialSoftwareSnapshotMgmt</b>)</td>
</tr>
<tr data="inherited;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/vsmgmt/nf-vsmgmt-ivssdifferentialsoftwaresnapshotmgmt-querydiffareasonvolume">QueryDiffAreasOnVolume</a>
</td>
<td align="left" width="63%">
Queries shadow copy storage areas that physically reside on the given volume.</p> (Inherited from <b>IVssDifferentialSoftwareSnapshotMgmt</b>)</td>
</tr>
<tr data="inherited;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/vsmgmt/nf-vsmgmt-ivssdifferentialsoftwaresnapshotmgmt-queryvolumessupportedfordiffareas">QueryVolumesSupportedForDiffAreas</a>
</td>
<td align="left" width="63%">
Queries volumes that support shadow copy storage  areas (including volumes with disabled differential areas).</p> (Inherited from <b>IVssDifferentialSoftwareSnapshotMgmt</b>)</td>
</tr>
</table> 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a>



<a href="https://docs.microsoft.com/windows/desktop/VSS/volume-shadow-copy-api-interfaces">Volume Shadow Copy API Interfaces</a>
 

 

