---
UID: NE:wbemcli.tag_CIMTYPE_ENUMERATION
title: CIMTYPE_ENUMERATION (wbemcli.h)
description: Defines values that specify different CIM data types.
old-location: wmi\cimtype_enumeration.htm
tech.root: WmiSdk
ms.assetid: ab67954c-ead2-4906-9680-503612d3f12d
ms.date: 12/05/2018
ms.keywords: CIMTYPE_ENUMERATION, CIMTYPE_ENUMERATION enumeration [Windows Management Instrumentation], CIM_BOOLEAN, CIM_CHAR16, CIM_DATETIME, CIM_EMPTY, CIM_FLAG_ARRAY, CIM_ILLEGAL, CIM_OBJECT, CIM_REAL32, CIM_REAL64, CIM_REFERENCE, CIM_SINT16, CIM_SINT32, CIM_SINT64, CIM_SINT8, CIM_STRING, CIM_UINT16, CIM_UINT32, CIM_UINT64, CIM_UINT8, wbemcli/CIMTYPE_ENUMERATION, wbemcli/CIM_BOOLEAN, wbemcli/CIM_CHAR16, wbemcli/CIM_DATETIME, wbemcli/CIM_EMPTY, wbemcli/CIM_FLAG_ARRAY, wbemcli/CIM_ILLEGAL, wbemcli/CIM_OBJECT, wbemcli/CIM_REAL32, wbemcli/CIM_REAL64, wbemcli/CIM_REFERENCE, wbemcli/CIM_SINT16, wbemcli/CIM_SINT32, wbemcli/CIM_SINT64, wbemcli/CIM_SINT8, wbemcli/CIM_STRING, wbemcli/CIM_UINT16, wbemcli/CIM_UINT32, wbemcli/CIM_UINT64, wbemcli/CIM_UINT8, wmi.cimtype_enumeration
f1_keywords:
- wbemcli/CIMTYPE_ENUMERATION
dev_langs:
- c++
req.header: wbemcli.h
req.include-header: Wbemidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wbemcli.h
api_name:
- CIMTYPE_ENUMERATION
targetos: Windows
req.typenames: CIMTYPE_ENUMERATION
req.redist: 
ms.custom: 19H1
---

# CIMTYPE_ENUMERATION enumeration


## -description


The <b>CIMTYPE_ENUMERATION</b> enumeration defines values that specify different CIM data types. All the values in the enumeration are types defined by the Distributed Management Task Force (DMTF). For more information about the DMTF and the CIM data types, see <a href="Http://go.microsoft.com/fwlink/p/?linkid=84403">http://www.dmtf.org/standards/cim/cim_spec_v22</a>.


## -enum-fields




### -field CIM_ILLEGAL

An illegal value.


### -field CIM_EMPTY

An empty (null) value.


### -field CIM_SINT8

An 8-bit signed integer.


### -field CIM_UINT8

An 8-bit unsigned integer.


### -field CIM_SINT16

A 16-bit signed integer.


### -field CIM_UINT16

A 16-bit unsigned integer.


### -field CIM_SINT32

A 32-bit signed integer.


### -field CIM_UINT32

A 32-bit unsigned integer.


### -field CIM_SINT64

A 64-bit signed integer.


### -field CIM_UINT64

A 64-bit unsigned integer.


### -field CIM_REAL32

A 32-bit real number.


### -field CIM_REAL64

A 64-bit real number.


### -field CIM_BOOLEAN

A Boolean value.


### -field CIM_STRING

A string value.


### -field CIM_DATETIME

A DateTime value.


### -field CIM_REFERENCE

Reference (__Path) of another Object.


### -field CIM_CHAR16

A 16-bit character value.


### -field CIM_OBJECT

An Object value.


### -field CIM_FLAG_ARRAY

An array value.

