---
UID: NE:wbemcli.tag_WBEM_COMPILER_OPTIONS
title: WBEM_COMPILER_OPTIONS (wbemcli.h)
description: Contains option flags for IMofCompiler methods.
old-location: wmi\wbem_compiler_options.htm
tech.root: WmiSdk
ms.assetid: 49F1518B-A487-458F-BFDD-BCF75A0E4306
ms.date: 12/05/2018
ms.keywords: WBEM_COMPILER_OPTIONS, WBEM_COMPILER_OPTIONS enumeration [Windows Management Instrumentation], WBEM_FLAG_AUTORECOVER, WBEM_FLAG_CHECK_ONLY, WBEM_FLAG_CONSOLE_PRINT, WBEM_FLAG_DONT_ADD_TO_LIST, WBEM_FLAG_SPLIT_FILES, WBEM_FLAG_STORE_FILE, WBEM_FLAG_WMI_CHECK, wbemcli/WBEM_COMPILER_OPTIONS, wbemcli/WBEM_FLAG_AUTORECOVER, wbemcli/WBEM_FLAG_CHECK_ONLY, wbemcli/WBEM_FLAG_CONSOLE_PRINT, wbemcli/WBEM_FLAG_DONT_ADD_TO_LIST, wbemcli/WBEM_FLAG_SPLIT_FILES, wbemcli/WBEM_FLAG_STORE_FILE, wbemcli/WBEM_FLAG_WMI_CHECK, wmi.wbem_compiler_options
f1_keywords:
- wbemcli/WBEM_COMPILER_OPTIONS
dev_langs:
- c++
req.header: wbemcli.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wbemcli.h
api_name:
- WBEM_COMPILER_OPTIONS
targetos: Windows
req.typenames: WBEM_COMPILER_OPTIONS
req.redist: 
ms.custom: 19H1
---

# WBEM_COMPILER_OPTIONS enumeration


## -description


Contains option flags for <a href="https://docs.microsoft.com/windows/desktop/api/wbemcli/nn-wbemcli-imofcompiler">IMofCompiler</a> methods. 


## -enum-fields




### -field WBEM_FLAG_CHECK_ONLY


### -field WBEM_FLAG_AUTORECOVER


### -field WBEM_FLAG_WMI_CHECK


### -field WBEM_FLAG_CONSOLE_PRINT


### -field WBEM_FLAG_DONT_ADD_TO_LIST


### -field WBEM_FLAG_SPLIT_FILES


### -field WBEM_FLAG_STORE_FILE


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wbemcli/nf-wbemcli-imofcompiler-compilebuffer">CompileBuffer</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wbemcli/nf-wbemcli-imofcompiler-compilefile">CompileFile</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wbemcli/nf-wbemcli-imofcompiler-createbmof">CreateBMOF</a>
 

 

