---
UID: NE:wbemcli.tag_WMI_OBJ_TEXT
title: WMI_OBJ_TEXT (wbemcli.h)
description: Defines the valid object text formats to be used by SWbemObjectEx.GetText_.
old-location: wmi\wmi_obj_text.htm
tech.root: WmiSdk
ms.assetid: 18970FA8-F42E-4F3D-9D79-37B841814AF8
ms.date: 12/05/2018
ms.keywords: WMI_OBJ_TEXT, WMI_OBJ_TEXT enumeration [Windows Management Instrumentation], WMI_OBJ_TEXT_CIM_DTD_2_0, WMI_OBJ_TEXT_LAST, WMI_OBJ_TEXT_WMI_DTD_2_0, WMI_OBJ_TEXT_WMI_EXT1, WMI_OBJ_TEXT_WMI_EXT10, WMI_OBJ_TEXT_WMI_EXT2, WMI_OBJ_TEXT_WMI_EXT3, WMI_OBJ_TEXT_WMI_EXT4, WMI_OBJ_TEXT_WMI_EXT5, WMI_OBJ_TEXT_WMI_EXT6, WMI_OBJ_TEXT_WMI_EXT7, WMI_OBJ_TEXT_WMI_EXT8, WMI_OBJ_TEXT_WMI_EXT9, wbemcli/WMI_OBJ_TEXT, wbemcli/WMI_OBJ_TEXT_CIM_DTD_2_0, wbemcli/WMI_OBJ_TEXT_LAST, wbemcli/WMI_OBJ_TEXT_WMI_DTD_2_0, wbemcli/WMI_OBJ_TEXT_WMI_EXT1, wbemcli/WMI_OBJ_TEXT_WMI_EXT10, wbemcli/WMI_OBJ_TEXT_WMI_EXT2, wbemcli/WMI_OBJ_TEXT_WMI_EXT3, wbemcli/WMI_OBJ_TEXT_WMI_EXT4, wbemcli/WMI_OBJ_TEXT_WMI_EXT5, wbemcli/WMI_OBJ_TEXT_WMI_EXT6, wbemcli/WMI_OBJ_TEXT_WMI_EXT7, wbemcli/WMI_OBJ_TEXT_WMI_EXT8, wbemcli/WMI_OBJ_TEXT_WMI_EXT9, wmi.wmi_obj_text
f1_keywords:
- wbemcli/WMI_OBJ_TEXT
dev_langs:
- c++
req.header: wbemcli.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wbemcli.h
api_name:
- WMI_OBJ_TEXT
targetos: Windows
req.typenames: WMI_OBJ_TEXT
req.redist: 
ms.custom: 19H1
---

# WMI_OBJ_TEXT enumeration


## -description


Defines the valid object text formats to be used by 
<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/swbemobjectex-gettext-">SWbemObjectEx.GetText_</a>.


## -enum-fields




### -field WMI_OBJ_TEXT_CIM_DTD_2_0

XML format conforming to the DMTF (Distributed Management Task Force) CIM document type definition (DTD) version 2.0.


### -field WMI_OBJ_TEXT_WMI_DTD_2_0

XML format as defined by the extended WMI version of DMTF CIM DTD version 2.0. Using this value enables WMI-specific extensions, such as embedded objects or scope.


### -field WMI_OBJ_TEXT_WMI_EXT1

Deprecated. Do not use.


### -field WMI_OBJ_TEXT_WMI_EXT2

Deprecated. Do not use.


### -field WMI_OBJ_TEXT_WMI_EXT3

Deprecated. Do not use.


### -field WMI_OBJ_TEXT_WMI_EXT4

Deprecated. Do not use.


### -field WMI_OBJ_TEXT_WMI_EXT5

Deprecated. Do not use.


### -field WMI_OBJ_TEXT_WMI_EXT6

Deprecated. Do not use.


### -field WMI_OBJ_TEXT_WMI_EXT7

Deprecated. Do not use.


### -field WMI_OBJ_TEXT_WMI_EXT8

Deprecated. Do not use.


### -field WMI_OBJ_TEXT_WMI_EXT9

Deprecated. Do not use.


### -field WMI_OBJ_TEXT_WMI_EXT10

Deprecated. Do not use.


### -field WMI_OBJ_TEXT_LAST

Deprecated. Do not use.

