---
UID: NN:wbemcli.IWbemObjectTextSrc
title: IWbemObjectTextSrc (wbemcli.h)
description: The IWbemObjectTextSrc interface is used to translate IWbemClassObject instances to and from differing text formats.
old-location: wmi\iwbemobjecttextsrc.htm
tech.root: WmiSdk
ms.assetid: b86fd54e-15a8-4a08-ba29-5bc086ababf8
ms.date: 12/05/2018
ms.keywords: IWbemObjectTextSrc, IWbemObjectTextSrc interface [Windows Management Instrumentation], IWbemObjectTextSrc interface [Windows Management Instrumentation],described, WbemObjectTextSrc, _hmm_iwbemobjecttextsrc, wbemcli/IWbemObjectTextSrc, wmi.iwbemobjecttextsrc
f1_keywords:
- wbemcli/IWbemObjectTextSrc
dev_langs:
- c++
req.header: wbemcli.h
req.include-header: Wbemidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Wbemuuid.lib
req.dll: Fastprox.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Fastprox.dll
api_name:
- IWbemObjectTextSrc
- IWbemObjectTextSrc.CreateFromText
- WbemObjectTextSrc
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWbemObjectTextSrc interface


## -description


The 
<b>IWbemObjectTextSrc</b> interface is used to translate 
<a href="https://docs.microsoft.com/windows/desktop/api/wbemcli/nn-wbemcli-iwbemclassobject">IWbemClassObject</a> instances to and from differing text formats.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IWbemObjectTextSrc</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IWbemObjectTextSrc</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IWbemObjectTextSrc</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%"><b>CreateFromText</b></td>
<td align="left" width="63%">
Reserved for future use.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/wbemcli/nf-wbemcli-iwbemobjecttextsrc-gettext">GetText</a>
</td>
<td align="left" width="63%">
Creates a textual representation of a class or object instance.

</td>
</tr>
</table> 


## -see-also




<b></b>



<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/representing-objects-in-xml">Representing Objects in XML</a>
 

 

