---
UID: NE:wbemdisp.WbemErrorEnum
title: WbemErrorEnum (wbemdisp.h)
description: Define the errors that may be returned by Scripting API for WMI calls.
old-location: wmi\wbemerrorenum.htm
tech.root: WmiSdk
ms.assetid: 6accd7c9-cb12-4eba-aff0-0aa38324b4ff
ms.date: 12/05/2018
ms.keywords: WbemErrorEnum, WbemErrorEnum enumeration [Windows Management Instrumentation], _hmm_wbemerrorenum, wbemErrAccessDenied, wbemErrAggregatingByObject, wbemErrAlreadyExists, wbemErrAmbiguousOperation, wbemErrAmendedObject, wbemErrBackupRestoreWinmgmtRunning, wbemErrBufferTooSmall, wbemErrCallCancelled, wbemErrCannotBeAbstract, wbemErrCannotBeKey, wbemErrCannotBeSingleton, wbemErrCannotChangeIndexInheritance, wbemErrCannotChangeKeyInheritance, wbemErrCircularReference, wbemErrClassHasChildren, wbemErrClassHasInstances, wbemErrClassNameTooWide, wbemErrClientTooSlow, wbemErrConnectionFailed, wbemErrCriticalError, wbemErrDatabaseVerMismatch, wbemErrEncryptedConnectionRequired, wbemErrFailed, wbemErrFatalTransportError, wbemErrForcedRollback, wbemErrHandleOutOfDate, wbemErrIllegalNull, wbemErrIllegalOperation, wbemErrIncompleteClass, wbemErrInitializationFailure, wbemErrInvalidAssociation, wbemErrInvalidCimType, wbemErrInvalidClass, wbemErrInvalidContext, wbemErrInvalidDuplicateParameter, wbemErrInvalidFlavor, wbemErrInvalidHandleRequest, wbemErrInvalidLocale, wbemErrInvalidMethod, wbemErrInvalidMethodParameters, wbemErrInvalidNamespace, wbemErrInvalidObject, wbemErrInvalidObjectPath, wbemErrInvalidOperation, wbemErrInvalidOperator, wbemErrInvalidParameter, wbemErrInvalidParameterId, wbemErrInvalidProperty, wbemErrInvalidPropertyType, wbemErrInvalidProviderRegistration, wbemErrInvalidQualifier, wbemErrInvalidQualifierType, wbemErrInvalidQuery, wbemErrInvalidQueryType, wbemErrInvalidStream, wbemErrInvalidSuperclass, wbemErrInvalidSyntax, wbemErrLocalCredentials, wbemErrMarshalInvalidSignature, wbemErrMarshalVersionMismatch, wbemErrMethodDisabled, wbemErrMethodNameTooWide, wbemErrMethodNotImplemented, wbemErrMissingAggregationList, wbemErrMissingGroupWithin, wbemErrMissingParameter, wbemErrNoSchema, wbemErrNonConsecutiveParameterIds, wbemErrNondecoratedObject, wbemErrNotAvailable, wbemErrNotEventClass, wbemErrNotFound, wbemErrNotSupported, wbemErrNullSecurityDescriptor, wbemErrOutOfDiskSpace, wbemErrOutOfMemory, wbemErrOverrideNotAllowed, wbemErrParameterIdOnRetval, wbemErrPrivilegeNotHeld, wbemErrPropagatedMethod, wbemErrPropagatedProperty, wbemErrPropagatedQualifier, wbemErrPropertyNameTooWide, wbemErrPropertyNotAnObject, wbemErrProviderAlreadyRegistered, wbemErrProviderFailure, wbemErrProviderLoadFailure, wbemErrProviderNotCapable, wbemErrProviderNotFound, wbemErrProviderNotRegistered, wbemErrProviderSuspended, wbemErrQualifierNameTooWide, wbemErrQueryNotImplemented, wbemErrQueueOverflow, wbemErrQuotaViolation, wbemErrReadOnly, wbemErrRefresherBusy, wbemErrRegistrationTooBroad, wbemErrRegistrationTooPrecise, wbemErrRerunCommand, wbemErrResetToDefault, wbemErrServerTooBusy, wbemErrShuttingDown, wbemErrSynchronizationRequired, wbemErrSystemProperty, wbemErrTimedout, wbemErrTimeout, wbemErrTooManyProperties, wbemErrTooMuchData, wbemErrTransactionConflict, wbemErrTransportFailure, wbemErrTypeMismatch, wbemErrUnexpected, wbemErrUninterpretableProviderQuery, wbemErrUnknownObjectType, wbemErrUnknownPacketType, wbemErrUnparsableQuery, wbemErrUnsupportedClassUpdate, wbemErrUnsupportedLocale, wbemErrUnsupportedParameter, wbemErrUnsupportedPutExtension, wbemErrUpdateOverrideNotAllowed, wbemErrUpdatePropagatedMethod, wbemErrUpdateTypeMismatch, wbemErrValueOutOfRange, wbemErrVetoDelete, wbemErrVetoPut, wbemNoErr, wbemdisp/, wbemdisp/WbemErrorEnum, wbemdisp/wbemErrAccessDenied, wbemdisp/wbemErrAggregatingByObject, wbemdisp/wbemErrAlreadyExists, wbemdisp/wbemErrAmbiguousOperation, wbemdisp/wbemErrAmendedObject, wbemdisp/wbemErrBackupRestoreWinmgmtRunning, wbemdisp/wbemErrBufferTooSmall, wbemdisp/wbemErrCallCancelled, wbemdisp/wbemErrCannotBeAbstract, wbemdisp/wbemErrCannotBeKey, wbemdisp/wbemErrCannotBeSingleton, wbemdisp/wbemErrCannotChangeIndexInheritance, wbemdisp/wbemErrCannotChangeKeyInheritance, wbemdisp/wbemErrCircularReference, wbemdisp/wbemErrClassHasChildren, wbemdisp/wbemErrClassHasInstances, wbemdisp/wbemErrClassNameTooWide, wbemdisp/wbemErrClientTooSlow, wbemdisp/wbemErrConnectionFailed, wbemdisp/wbemErrCriticalError, wbemdisp/wbemErrDatabaseVerMismatch, wbemdisp/wbemErrEncryptedConnectionRequired, wbemdisp/wbemErrFailed, wbemdisp/wbemErrFatalTransportError, wbemdisp/wbemErrForcedRollback, wbemdisp/wbemErrHandleOutOfDate, wbemdisp/wbemErrIllegalNull, wbemdisp/wbemErrIllegalOperation, wbemdisp/wbemErrIncompleteClass, wbemdisp/wbemErrInitializationFailure, wbemdisp/wbemErrInvalidAssociation, wbemdisp/wbemErrInvalidCimType, wbemdisp/wbemErrInvalidClass, wbemdisp/wbemErrInvalidContext, wbemdisp/wbemErrInvalidDuplicateParameter, wbemdisp/wbemErrInvalidFlavor, wbemdisp/wbemErrInvalidHandleRequest, wbemdisp/wbemErrInvalidLocale, wbemdisp/wbemErrInvalidMethod, wbemdisp/wbemErrInvalidMethodParameters, wbemdisp/wbemErrInvalidNamespace, wbemdisp/wbemErrInvalidObject, wbemdisp/wbemErrInvalidObjectPath, wbemdisp/wbemErrInvalidOperation, wbemdisp/wbemErrInvalidOperator, wbemdisp/wbemErrInvalidParameter, wbemdisp/wbemErrInvalidParameterId, wbemdisp/wbemErrInvalidProperty, wbemdisp/wbemErrInvalidPropertyType, wbemdisp/wbemErrInvalidProviderRegistration, wbemdisp/wbemErrInvalidQualifier, wbemdisp/wbemErrInvalidQualifierType, wbemdisp/wbemErrInvalidQuery, wbemdisp/wbemErrInvalidQueryType, wbemdisp/wbemErrInvalidStream, wbemdisp/wbemErrInvalidSuperclass, wbemdisp/wbemErrInvalidSyntax, wbemdisp/wbemErrLocalCredentials, wbemdisp/wbemErrMarshalInvalidSignature, wbemdisp/wbemErrMarshalVersionMismatch, wbemdisp/wbemErrMethodDisabled, wbemdisp/wbemErrMethodNameTooWide, wbemdisp/wbemErrMethodNotImplemented, wbemdisp/wbemErrMissingAggregationList, wbemdisp/wbemErrMissingGroupWithin, wbemdisp/wbemErrMissingParameter, wbemdisp/wbemErrNoSchema, wbemdisp/wbemErrNonConsecutiveParameterIds, wbemdisp/wbemErrNondecoratedObject, wbemdisp/wbemErrNotAvailable, wbemdisp/wbemErrNotEventClass, wbemdisp/wbemErrNotFound, wbemdisp/wbemErrNotSupported, wbemdisp/wbemErrNullSecurityDescriptor, wbemdisp/wbemErrOutOfDiskSpace, wbemdisp/wbemErrOutOfMemory, wbemdisp/wbemErrOverrideNotAllowed, wbemdisp/wbemErrParameterIdOnRetval, wbemdisp/wbemErrPrivilegeNotHeld, wbemdisp/wbemErrPropagatedMethod, wbemdisp/wbemErrPropagatedProperty, wbemdisp/wbemErrPropagatedQualifier, wbemdisp/wbemErrPropertyNameTooWide, wbemdisp/wbemErrPropertyNotAnObject, wbemdisp/wbemErrProviderAlreadyRegistered, wbemdisp/wbemErrProviderFailure, wbemdisp/wbemErrProviderLoadFailure, wbemdisp/wbemErrProviderNotCapable, wbemdisp/wbemErrProviderNotFound, wbemdisp/wbemErrProviderNotRegistered, wbemdisp/wbemErrProviderSuspended, wbemdisp/wbemErrQualifierNameTooWide, wbemdisp/wbemErrQueryNotImplemented, wbemdisp/wbemErrQueueOverflow, wbemdisp/wbemErrQuotaViolation, wbemdisp/wbemErrReadOnly, wbemdisp/wbemErrRefresherBusy, wbemdisp/wbemErrRegistrationTooBroad, wbemdisp/wbemErrRegistrationTooPrecise, wbemdisp/wbemErrRerunCommand, wbemdisp/wbemErrResetToDefault, wbemdisp/wbemErrServerTooBusy, wbemdisp/wbemErrShuttingDown, wbemdisp/wbemErrSynchronizationRequired, wbemdisp/wbemErrSystemProperty, wbemdisp/wbemErrTimedout, wbemdisp/wbemErrTimeout, wbemdisp/wbemErrTooManyProperties, wbemdisp/wbemErrTooMuchData, wbemdisp/wbemErrTransactionConflict, wbemdisp/wbemErrTransportFailure, wbemdisp/wbemErrTypeMismatch, wbemdisp/wbemErrUnexpected, wbemdisp/wbemErrUninterpretableProviderQuery, wbemdisp/wbemErrUnknownObjectType, wbemdisp/wbemErrUnknownPacketType, wbemdisp/wbemErrUnparsableQuery, wbemdisp/wbemErrUnsupportedClassUpdate, wbemdisp/wbemErrUnsupportedLocale, wbemdisp/wbemErrUnsupportedParameter, wbemdisp/wbemErrUnsupportedPutExtension, wbemdisp/wbemErrUpdateOverrideNotAllowed, wbemdisp/wbemErrUpdatePropagatedMethod, wbemdisp/wbemErrUpdateTypeMismatch, wbemdisp/wbemErrValueOutOfRange, wbemdisp/wbemErrVetoDelete, wbemdisp/wbemErrVetoPut, wbemdisp/wbemNoErr, wmi.wbemerrorenum
f1_keywords:
- wbemdisp/WbemErrorEnum
dev_langs:
- c++
req.header: wbemdisp.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Wbemdisp.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wbemdisp.h
api_name:
- WbemErrorEnum
targetos: Windows
req.typenames: WbemErrorEnum
req.redist: 
ms.custom: 19H1
---

# WbemErrorEnum enumeration


## -description


The WbemErrorEnum constants define the errors that 
    may be returned by <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/scripting-api-for-wmi">Scripting API for WMI</a> 
    calls.

The WMI scripting type library Wbemdisp.tlb defines these constants. Visual Basic applications can 
    access this library; script languages must use the value of the constant directly, unless they use the Windows 
    Script Host (WSH) XML file format. For more information, see 
    <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/using-the-wmi-scripting-type-library">Using the WMI Scripting Type Library</a>.

Other languages may have different names for these values, see <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/wmi-error-constants">WMI Error Constants</a> and <a href="https://docs.microsoft.com/windows/win32/api/wbemcli/ne-wbemcli-wbemstatus">WBEMSTATUS</a>.


## -enum-fields




### -field wbemNoErr

The call was successful.


### -field wbemErrFailed

The call failed.


### -field wbemErrNotFound

The object could not be found.


### -field wbemErrAccessDenied

The current user does not have permission to perform the action.


### -field wbemErrProviderFailure

The provider has failed at some time other than during initialization.


### -field wbemErrTypeMismatch

A type mismatch occurred.


### -field wbemErrOutOfMemory

There was not enough memory for the operation.


### -field wbemErrInvalidContext

The 
<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/swbemnamedvalue">SWbemNamedValue</a> object is not valid.


### -field wbemErrInvalidParameter

One of the parameters to the call is not correct.


### -field wbemErrNotAvailable

The resource, typically a remote server, is not currently available.


### -field wbemErrCriticalError

An internal, critical, and unexpected error occurred. Report this error to Microsoft Technical 
     Support.


### -field wbemErrInvalidStream

One or more network packets were corrupted during a remote session.


### -field wbemErrNotSupported

The feature or operation is not supported.


### -field wbemErrInvalidSuperclass

The parent class specified is not valid.


### -field wbemErrInvalidNamespace

The namespace specified could not be found.


### -field wbemErrInvalidObject

The specified instance is not valid.


### -field wbemErrInvalidClass

The specified class is not valid.


### -field wbemErrProviderNotFound

A provider referenced in the schema does not have a corresponding registration.


### -field wbemErrInvalidProviderRegistration

A provider referenced in the schema has an incorrect or incomplete registration. This error may be caused by 
     a missing <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/pragma-namespace">pragma namespace</a> command in the MOF file used to 
     register the provider, resulting in the provider being registered in the wrong WMI namespace. This error may also 
     be caused by a corrupt repository, which may be fixed by deleting it and recompiling the MOF files.


### -field wbemErrProviderLoadFailure

COM cannot locate a provider referenced in the schema. This error may be caused by any of the following:

The provider is using a WMI DLL that does not match the .lib fileused when the provider was built.

The provider's DLL or any of the DLLs on which it depends is corrupt.

The provider failed to export 
      <a href="https://docs.microsoft.com/windows/desktop/api/olectl/nf-olectl-dllregisterserver">DllRegisterServer</a>.

An in-process provider was not registered using /regsvr32.

An out-of-process provider was not registered 
      using /regserver.


### -field wbemErrInitializationFailure

A component, such as a provider, failed to initialize for internal reasons.


### -field wbemErrTransportFailure

A networking error occurred, preventing normal operation.


### -field wbemErrInvalidOperation

The requested operation is not valid. This error usually applies to invalid attempts to delete classes or 
     properties.


### -field wbemErrInvalidQuery

The requested operation is not valid. This error usually applies to invalid attempts to delete classes or 
     properties.


### -field wbemErrInvalidQueryType

The requested query language is not supported.


### -field wbemErrAlreadyExists

In a put operation, the <b>wbemChangeFlagCreateOnly</b> flag was specified, but the 
     instance already exists.


### -field wbemErrOverrideNotAllowed

It is not possible to perform the add operation on this qualifier because the owning object does not permit 
     overrides.


### -field wbemErrPropagatedQualifier

The user attempted to delete a qualifier that was not owned. The qualifier was inherited from a parent 
     class.


### -field wbemErrPropagatedProperty

The user attempted to delete a property that was not owned. The property was inherited from a parent 
     class.


### -field wbemErrUnexpected

The client made an unexpected and illegal sequence of calls, such as calling 
     <b>EndEnumeration</b> before calling 
     <b>BeginEnumeration</b>.


### -field wbemErrIllegalOperation

The user requested an illegal operation, such as spawning a class from an instance.


### -field wbemErrCannotBeKey

There was an illegal attempt to specify a key qualifier on a property that cannot be a key. The keys are 
     specified in the class definition for an object, and cannot be altered on a per-instance basis.


### -field wbemErrIncompleteClass

The current object is not a valid class definition. Either it is incomplete, or it has not been registered 
     with WMI using <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/swbemobject-put-">SWbemObject.Put_</a>.


### -field wbemErrInvalidSyntax

The syntax of an input parameter is incorrect for the applicable data structure. For example, when a CIM 
     datetime structure does not have the correct format when passed to 
     <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/swbemdatetime-setfiletime">SWbemDateTime.SetFileTime</a>.


### -field wbemErrNondecoratedObject

Reserved for future use.


### -field wbemErrReadOnly

The property that you are attempting to modify is read-only.


### -field wbemErrProviderNotCapable

The provider cannot perform the requested operation. This would include a query that is too complex, 
     retrieving an instance, creating or updating a class, deleting a class, or enumerating a class.


### -field wbemErrClassHasChildren

An attempt was made to make a change that would invalidate a subclass.


### -field wbemErrClassHasInstances

An attempt has been made to delete or modify a class that has instances.


### -field wbemErrQueryNotImplemented

Reserved for future use.


### -field wbemErrIllegalNull

A value of Nothing was specified for a property that may not be Nothing, such as one that is marked by a 
     <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/key-qualifier">Key</a>, <b>Indexed</b>, 
     or <b>Not_Null</b> qualifier.


### -field wbemErrInvalidQualifierType

The CIM type specified for a property is not valid.


### -field wbemErrInvalidPropertyType

The CIM type specified for a property is not valid.


### -field wbemErrValueOutOfRange

The request was made with an out-of-range value, or is incompatible with the type.


### -field wbemErrCannotBeSingleton

An illegal attempt was made to make a class singleton, such as when the class is derived from a 
     non-singleton class.


### -field wbemErrInvalidCimType

The CIM type specified is not valid.


### -field wbemErrInvalidMethod

The requested method is not available.


### -field wbemErrInvalidMethodParameters

The parameters provided for the method are not valid.


### -field wbemErrSystemProperty

There was an attempt to get qualifiers on a system property.


### -field wbemErrInvalidProperty

The property type is not recognized.


### -field wbemErrCallCancelled

An asynchronous process has been canceled internally or by the user. Note that due to the timing and nature 
     of the asynchronous operation the operation may not have been truly canceled.


### -field wbemErrShuttingDown

The user has requested an operation while WMI is in the process of shutting down.


### -field wbemErrPropagatedMethod

An attempt was made to reuse an existing method name from a parent class, and the signatures did not 
     match.


### -field wbemErrUnsupportedParameter

One or more parameter values, such as a query text, is too complex or unsupported. WMI is therefore 
     requested to retry the operation with simpler parameters.


### -field wbemErrMissingParameter

A parameter was missing from the method call.


### -field wbemErrInvalidParameterId

A method parameter has an <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/standard-wmi-qualifiers">ID</a> 
     qualifier that is not valid.


### -field wbemErrNonConsecutiveParameterIds

One or more of the method parameters have 
     <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/standard-wmi-qualifiers">ID</a> qualifiers that are out of 
     sequence.


### -field wbemErrParameterIdOnRetval

The return value for a method has an 
     <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/standard-wmi-qualifiers">ID</a> qualifier.


### -field wbemErrInvalidObjectPath

The specified object path was not valid.


### -field wbemErrOutOfDiskSpace

Disk is out of space or the 4 GB limit on WMI repository (CIM repository) size is reached.


### -field wbemErrBufferTooSmall

The supplied buffer was too small to hold all the objects in the enumerator or to read a string 
     property.


### -field wbemErrUnsupportedPutExtension

The provider does not support the requested put operation.


### -field wbemErrUnknownObjectType

An object with an incorrect type or version was encountered during marshaling.


### -field wbemErrUnknownPacketType

A packet with an incorrect type or version was encountered during marshaling.


### -field wbemErrMarshalVersionMismatch

The packet has an unsupported version.


### -field wbemErrMarshalInvalidSignature

The packet appears to be corrupted.


### -field wbemErrInvalidQualifier

An attempt has been made to mismatch qualifiers, such as putting [key] on an object instead of a 
     property.


### -field wbemErrInvalidDuplicateParameter

A duplicate parameter has been declared in a CIM method.


### -field wbemErrTooMuchData

Reserved for future use.


### -field wbemErrServerTooBusy

A call to <a href="https://docs.microsoft.com/windows/desktop/api/wbemcli/nf-wbemcli-iwbemobjectsink-indicate">IWbemObjectSink::Indicate</a> has 
     failed. The provider may choose to refire the event.


### -field wbemErrInvalidFlavor

The specified flavor was not valid.


### -field wbemErrCircularReference

An attempt has been made to create a reference that is circular (for example, deriving a class from 
     itself).


### -field wbemErrUnsupportedClassUpdate

The specified class is not supported.


### -field wbemErrCannotChangeKeyInheritance

An attempt was made to change a key when instances or subclasses are already using the key.


### -field wbemErrCannotChangeIndexInheritance

An attempt was made to change an index when instances or subclasses are already using the index.


### -field wbemErrTooManyProperties

An attempt was made to create more properties than the current version of the class supports.


### -field wbemErrUpdateTypeMismatch

A property was redefined with a conflicting type in a derived class.


### -field wbemErrUpdateOverrideNotAllowed

An attempt was made in a derived class to override a non-overrideable qualifier.


### -field wbemErrUpdatePropagatedMethod

A method was redeclared with a conflicting signature in a derived class.


### -field wbemErrMethodNotImplemented

An attempt was made to execute a method not marked with [implemented] in any relevant class.


### -field wbemErrMethodDisabled

An attempt was made to execute a method marked with [disabled].


### -field wbemErrRefresherBusy

The refresher is busy with another operation.


### -field wbemErrUnparsableQuery

The filtering query is syntactically not valid.


### -field wbemErrNotEventClass

The FROM clause of a filtering query references a class that is not an event class (not derived from 
     __Event).


### -field wbemErrMissingGroupWithin

A GROUP BY clause was used without the corresponding GROUP WITHIN clause.


### -field wbemErrMissingAggregationList

A GROUP BY clause was used. Aggregation on all properties is not supported.


### -field wbemErrPropertyNotAnObject

Dot notation was used on a property that is not an embedded object.


### -field wbemErrAggregatingByObject

A GROUP BY clause references a property that is an embedded object without using dot notation.


### -field wbemErrUninterpretableProviderQuery

An event provider registration query 
     (<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/--eventproviderregistration">__EventProviderRegistration</a>) did not 
     specify the classes for which events were provided.


### -field wbemErrBackupRestoreWinmgmtRunning

An request was made to back up or restore the repository while WMI was using it.


### -field wbemErrQueueOverflow

The asynchronous delivery queue overflowed due to the event consumer being too slow.


### -field wbemErrPrivilegeNotHeld

The operation failed because the client did not have the necessary security privilege.


### -field wbemErrInvalidOperator

The operator is not valid for this property type.


### -field wbemErrLocalCredentials

The user specified a username, password or authority for a local connection. The user must use a blank 
     username/password and rely on default security.


### -field wbemErrCannotBeAbstract

The class was made abstract when its parent class is not abstract.


### -field wbemErrAmendedObject

An amended object was put without the <b>wbemFlagUseAmendedQualifiers</b> flag being 
     specified.


### -field wbemErrClientTooSlow

The client was not retrieving objects quickly enough from an enumeration. This constant is returned when a 
       client creates an enumeration object but does not retrieve objects from the enumerator in a timely fashion, 
       causing the enumerator's object caches to get backed up.


### -field wbemErrNullSecurityDescriptor

A null security descriptor was used.


### -field wbemErrTimeout

The operation timed out.


### -field wbemErrInvalidAssociation

The association being used is not valid.


### -field wbemErrAmbiguousOperation

The operation was ambiguous.


### -field wbemErrQuotaViolation

WMI is taking up too much memory. This could be caused either by low memory availability or excessive 
       memory consumption by WMI.


### -field wbemErrTransactionConflict

The operation resulted in a transaction conflict.


### -field wbemErrForcedRollback

The transaction forced a rollback.


### -field wbemErrUnsupportedLocale

The locale used in the call is not supported.


### -field wbemErrHandleOutOfDate

The object handle is out of date.


### -field wbemErrConnectionFailed

Indicates that the connection to the SQL database failed.


### -field wbemErrInvalidHandleRequest

The handle request was not valid.


### -field wbemErrPropertyNameTooWide

The property name contains more than 255 characters.


### -field wbemErrClassNameTooWide

The class name contains more than 255 characters.


### -field wbemErrMethodNameTooWide

The method name contains more than 255 characters.


### -field wbemErrQualifierNameTooWide

The qualifier name contains more than 255 characters.


### -field wbemErrRerunCommand

Indicates that an SQL command should be rerun because there is a deadlock in SQL. This can be returned 
       only when data is being stored in an SQL database.


### -field wbemErrDatabaseVerMismatch

The database version does not match the version that the repository driver processes.


### -field wbemErrVetoPut

WMI cannot do the put operation because the provider does not allow it.


### -field wbemErrVetoDelete

WMI cannot do the delete operation because the provider does not allow it.


### -field wbemErrInvalidLocale

The specified locale identifier was not valid for the operation.


### -field wbemErrProviderSuspended

The provider is suspended.


### -field wbemErrSynchronizationRequired

The object must be committed and retrieved again before the requested operation can succeed. This constant 
       is returned when an object must be committed and re-retrieved to see the property value.


### -field wbemErrNoSchema

The operation cannot be completed because no schema is available.


### -field wbemErrProviderAlreadyRegistered

The provider registration cannot be done because the provider is already registered.


### -field wbemErrProviderNotRegistered

The provider for the requested data is not registered.


### -field wbemErrFatalTransportError

A fatal transport error occurred and other transport will not be attempted.


### -field wbemErrEncryptedConnectionRequired

The client connection to WINMGMT must be encrypted for this operation. The 
       <a href="https://docs.microsoft.com/windows/desktop/api/wbemcli/nn-wbemcli-iwbemservices">IWbemServices</a> proxy security settings should be adjusted 
       and the operation retried.


### -field wbemErrRegistrationTooBroad

The provider registration overlaps with the system event domain.


### -field wbemErrRegistrationTooPrecise

A WITHIN clause was not used in this query.


### -field wbemErrTimedout

Automation-specific error.


### -field wbemErrResetToDefault

The user deleted an override default value for the current class. The default value for this property in 
       the parent class has been reactivated. An automation-specific error.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/scripting-api-constants">Scripting API Constants</a>



<a href="https://docs.microsoft.com/windows/win32/api/wbemcli/ne-wbemcli-wbemstatus">WBEMSTATUS</a>



<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/wmi-error-constants">WMI Error Constants</a>
 

 

