---
UID: NE:wbemdisp.WbemTextFlagEnum
title: WbemTextFlagEnum (wbemdisp.h)
description: Defines the content of generated object text and is used by SWbemObject.GetObjectText_.
old-location: wmi\wbemtextflagenum.htm
tech.root: WmiSdk
ms.assetid: 81384e65-5ea0-420a-b92f-e93d5e545252
ms.date: 12/05/2018
ms.keywords: WbemTextFlagEnum, WbemTextFlagEnum enumeration [Windows Management Instrumentation], _hmm_wbemtextflagenum, wbemTextFlagNoFlavors, wbemdisp/WbemTextFlagEnum, wbemdisp/wbemTextFlagNoFlavors, wmi.wbemtextflagenum
f1_keywords:
- wbemdisp/WbemTextFlagEnum
dev_langs:
- c++
req.header: wbemdisp.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Wbemdisp.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wbemdisp.h
api_name:
- WbemTextFlagEnum
targetos: Windows
req.typenames: WbemTextFlagEnum
req.redist: 
ms.custom: 19H1
---

# WbemTextFlagEnum enumeration


## -description


The 
WbemTextFlagEnum constant defines the content of generated object text and is used by 
<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/swbemobject-getobjecttext-">SWbemObject.GetObjectText_</a>.

The WMI scripting type library, wbemdisp.tlb, defines these constants. Visual Basic applications can access this library;. script languages must use the value of the constant directly, unless they use Windows Script Host (WSH) XML file format. For more information, see 
<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/using-the-wmi-scripting-type-library">Using the WMI Scripting Type Library</a>.


## -enum-fields




### -field wbemTextFlagNoFlavors

Excludes qualifier flavors from the object text.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/scripting-api-constants">Scripting API Constants</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wbemdisp/ne-wbemdisp-wbemobjecttextformatenum">WbemObjectTextFormatEnum</a>
 

 

