---
UID: NN:wbemprov.IWbemEventProvider
title: IWbemEventProvider (wbemprov.h)
description: Use the IWbemEventProvider interface to initiate communication with an event provider. Windows Management calls the provider's implementation of this interface when a consumer has indicated interest in receiving events generated by the provider.
old-location: wmi\iwbemeventprovider.htm
tech.root: WmiSdk
ms.assetid: 4b92923a-659d-4340-8843-eb42aea69d47
ms.date: 12/05/2018
ms.keywords: IWbemEventProvider, IWbemEventProvider interface [Windows Management Instrumentation], IWbemEventProvider interface [Windows Management Instrumentation],described, _hmm_iwbemeventprovider, wbemprov/IWbemEventProvider, wmi.iwbemeventprovider
f1_keywords:
- wbemprov/IWbemEventProvider
dev_langs:
- c++
req.header: wbemprov.h
req.include-header: Wbemidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Wbemuuid.lib
req.dll: Wbemsvc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Wbemsvc.dll
api_name:
- IWbemEventProvider
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWbemEventProvider interface


## -description


Use the 
<b>IWbemEventProvider</b> interface to initiate communication with an event provider. Windows Management calls the provider's implementation of this interface when a consumer has indicated interest in receiving events generated by the provider.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IWbemEventProvider</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IWbemEventProvider</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IWbemEventProvider</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/wbemprov/nf-wbemprov-iwbemeventprovider-provideevents">ProvideEvents</a>
</td>
<td align="left" width="63%">
Called by WMI to command the provider to start delivering its events to WMI.

</td>
</tr>
</table> 

