---
UID: NE:wcntypes.tagWCN_VALUE_TYPE_VERSION
title: WCN_VALUE_TYPE_VERSION (wcntypes.h)
description: Defines the supported version of Wi-Fi Protected Setup (WPS).
old-location: wcn\wcn_value_type_version.htm
tech.root: wcn
ms.assetid: 7EE57CB6-EC32-4C90-AC48-56B10FEBE929
ms.date: 12/05/2018
ms.keywords: WCN_VALUE_TYPE_VERSION, WCN_VALUE_TYPE_VERSION enumeration [Windows Connect Now], WCN_VALUE_VERSION_1_0, WCN_VALUE_VERSION_2_0, wcn.wcn_value_type_version, wcntypes/WCN_VALUE_TYPE_VERSION, wcntypes/WCN_VALUE_VERSION_1_0, wcntypes/WCN_VALUE_VERSION_2_0
f1_keywords:
- wcntypes/WCN_VALUE_TYPE_VERSION
dev_langs:
- c++
req.header: wcntypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- wcntypes.h
api_name:
- WCN_VALUE_TYPE_VERSION
targetos: Windows
req.typenames: WCN_VALUE_TYPE_VERSION
req.redist: 
ms.custom: 19H1
---

# WCN_VALUE_TYPE_VERSION enumeration


## -description


The <b>WCN_VALUE_TYPE_VERSION</b> enumeration defines the supported version of Wi-Fi Protected Setup (WPS).


## -enum-fields




### -field WCN_VALUE_VERSION_1_0

Specifies WPS 1.0. Indicates compliance with Wi-Fi Alliance protocol specification for Wi-Fi Protected Setup (WPS) 1.0h.


### -field WCN_VALUE_VERSION_2_0

Specifies WPS 2.0.  Indicates compliance with Wi-Fi Alliance protocol specification for Wi-Fi Simple Configuration (WSC) 2.0.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wcntypes/ne-wcntypes-wcn_attribute_type">WCN_ATTRIBUTE_TYPE</a>
 

 

