---
UID: NF:wdsclientapi.WdsCliObtainDriverPackagesEx
title: WdsCliObtainDriverPackagesEx function (wdsclientapi.h)
description: This function obtains the driver packages (INF files) that are applicable to the specified WDS driver query XML.
old-location: wds\wdscliobtaindriverpackagesex.htm
tech.root: wds
ms.assetid: C9AA3036-8E34-4F57-829C-F5D8CDA2EAA7
ms.date: 12/05/2018
ms.keywords: WdsCliObtainDriverPackagesEx, WdsCliObtainDriverPackagesEx function [Windows Deployment Services], wds.wdscliobtaindriverpackagesex, wdsclientapi/WdsCliObtainDriverPackagesEx
f1_keywords:
- wdsclientapi/WdsCliObtainDriverPackagesEx
dev_langs:
- c++
req.header: wdsclientapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: WdsClientAPI.lib
req.dll: WdsClientAPI.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- WdsClientAPI.dll
api_name:
- WdsCliObtainDriverPackagesEx
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# WdsCliObtainDriverPackagesEx function


## -description


This function obtains the driver packages (INF files) that are applicable to the specified WDS driver query XML.  The <a href="https://docs.microsoft.com/windows/desktop/api/wdsclientapi/nf-wdsclientapi-wdsclifreestringarray">WdsCliFreeStringArray</a> function can be used to free the array of string values allocated by this function. The <a href="https://docs.microsoft.com/windows/desktop/api/wdsclientapi/nf-wdsclientapi-wdscligetdriverqueryxml">WdsCliGetDriverQueryXml</a> function can be used to generate the required driver query XML string.


## -parameters




### -param hSession [in]

A handle to a session with the WDS server. This handle is returned by the <a href="https://docs.microsoft.com/windows/desktop/api/wdsclientapi/nf-wdsclientapi-wdsclicreatesession">WdsCliCreateSession</a> function.


### -param pwszMachineInfo [out]

A pointer to a string containing WDS driver query XML which can be generated by calling the <a href="https://docs.microsoft.com/windows/desktop/api/wdsclientapi/nf-wdsclientapi-wdscligetdriverqueryxml">WdsCliGetDriverQueryXml</a> function.


### -param ppwszServerName [out]

A pointer to a pointer to a string value that receives the IP address of the server hosting the driver packages.




### -param pppwszDriverPackages [out]

An array of string values that are the full paths for the driver packages (INF files.) The Internet Protocol (IP) address, rather than a computer name, is returned as part of the path.  For example, a string value <b>\\172.31.224.245\REMINST\Stores\Drivers\driver.inf</b> in the array gives the full path to driver.inf.


### -param pulCount [out]

The number of driver packages returned by pppwszDriverPackages.




## -returns



If the function succeeds, the return is <b>S_OK</b>.



