---
UID: NF:wdspxe.PxeDhcpIsValid
title: PxeDhcpIsValid function (wdspxe.h)
description: Validates that a packet is a DHCP packet.
old-location: wds\pxedhcpisvalid.htm
tech.root: wds
ms.assetid: b5f43afb-ab71-4edf-a48a-7315d19af913
ms.date: 12/05/2018
ms.keywords: FALSE, PxeDhcpIsValid, PxeDhcpIsValid function [Windows Deployment Services], TRUE, wds.pxedhcpisvalid, wdspxe/PxeDhcpIsValid
f1_keywords:
- wdspxe/PxeDhcpIsValid
dev_langs:
- c++
req.header: wdspxe.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008, Windows Server 2003 with SP2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: WdsPxe.lib
req.dll: WdsPxe.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- WdsPxe.dll
api_name:
- PxeDhcpIsValid
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# PxeDhcpIsValid function


## -description


Validates that a packet is a DHCP packet.


## -parameters




### -param pPacket [in]

Pointer to a reply packet allocated with 
      the <a href="https://docs.microsoft.com/windows/desktop/api/wdspxe/nf-wdspxe-pxepacketallocate">PxePacketAllocate</a> function.


### -param uPacketLen [in]

Length of the packet pointed to by the <i>pPacket</i> parameter.


### -param bRequestPacket [in]

Indicates whether the packet is a request packet. The following table lists the possible values.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="TRUE"></a><a id="true"></a><dl>
<dt><b>TRUE</b></dt>
<dt>1</dt>
</dl>
</td>
<td width="60%">
Packet to be validated is a request packet from the client.

</td>
</tr>
<tr>
<td width="40%"><a id="FALSE"></a><a id="false"></a><dl>
<dt><b>FALSE</b></dt>
<dt>0</dt>
</dl>
</td>
<td width="60%">
Packet to be validated is a packet generated by the server.

</td>
</tr>
</table>
 


### -param pbPxeOptionPresent [out]

Address of a <b>BOOL</b> that is set to <b>TRUE</b> if the packet 
      is a valid DHCP packet that contains the Vendor Class Identifier option (60) with the value set to 
      "PXEClient".


## -returns



If the function succeeds, the return value is <b>ERROR_SUCCESS</b>.




## -remarks



Providers use this function when the filter set with 
    the  <a href="https://docs.microsoft.com/windows/desktop/api/wdspxe/nf-wdspxe-pxeprovidersetattribute">PxeProviderSetAttribute</a> function is set to receive all 
    packets to determine if a specified packet is a valid DHCP packet. Providers can also use this function to validate 
    reply packets; typically this is done only for debug or test builds of the provider.

The validation tests include the following tests.

<table>
<tr>
<th>DHCP field</th>
<th>Initialized value</th>
</tr>
<tr>
<td>Operation (op)</td>
<td>If the <i>bClientRequest</i> parameter is <b>TRUE</b>, this field must 
       be 1 (BOOTP Request), otherwise this field must be 2 (BOOTP Reply).</td>
</tr>
<tr>
<td>Hardware Address Length (hlen)</td>
<td>Must be less than or equal to 16.</td>
</tr>
<tr>
<td>Host Name (sname)</td>
<td>Must be <b>NULL</b> terminated.</td>
</tr>
<tr>
<td>Boot file name (file)</td>
<td>Must be <b>NULL</b> terminated.</td>
</tr>
<tr>
<td>Magic Cookie (first 4 octets of vend)</td>
<td>Must contain valid DHCP Magic Cookie (99 130 83 99).</td>
</tr>
<tr>
<td>Option Length</td>
<td>All options must have a valid length and do not overrun the packet.</td>
</tr>
<tr>
<td>DHCP Message Type (53)</td>
<td>Must be present.</td>
</tr>
<tr>
<td>End Option (255)</td>
<td>Packet must end with DHCP End Option. Due to minimum packet lengths, the packet may be larger but no 
       options may follow the End Option.</td>
</tr>
</table>
 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wdspxe/nf-wdspxe-pxepacketallocate">PxePacketAllocate</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wdspxe/nf-wdspxe-pxeprovidersetattribute">PxeProviderSetAttribute</a>



<a href="https://docs.microsoft.com/windows/desktop/Wds/windows-deployment-services-server-functions">Windows Deployment Services Server Functions</a>
 

 

