---
UID: NF:wdspxe.PxeDhcpv6IsValid
title: PxeDhcpv6IsValid function (wdspxe.h)
description: Validates that a packet is a valid DHCPv6 packet.
old-location: wds\pxedhcpv6isvalid.htm
tech.root: wds
ms.assetid: E20A9E7A-8CFA-4A2B-8A40-7937937332A5
ms.date: 12/05/2018
ms.keywords: FALSE, PxeDhcpv6IsValid, PxeDhcpv6IsValid function [Windows Deployment Services], TRUE, wds.pxedhcpv6isvalid, wdspxe/PxeDhcpv6IsValid
f1_keywords:
- wdspxe/PxeDhcpv6IsValid
dev_langs:
- c++
req.header: wdspxe.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: WdsPxe.lib
req.dll: WdsPxe.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- WdsPxe.dll
api_name:
- PxeDhcpv6IsValid
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# PxeDhcpv6IsValid function


## -description


Validates that a packet is a valid DHCPv6 packet.

For more information about valid DHCPv6 packets, developers should refer to the Dynamic Host Configuration Protocol for IPv6 (<a href="Http://go.microsoft.com/fwlink/p/?linkid=132626">RFC 3315</a>) maintained by The Internet Engineering Task Force (IETF).


## -parameters




### -param pPacket [in]

Pointer to a reply packet allocated with 
      the <a href="https://docs.microsoft.com/windows/desktop/api/wdspxe/nf-wdspxe-pxepacketallocate">PxePacketAllocate</a> function.


### -param uPacketLen [in]

Length of the packet pointed to by the <i>pPacket</i> parameter.


### -param bRequestPacket [in]

Indicates whether the packet is a request packet. The following table lists the possible values.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="TRUE"></a><a id="true"></a><dl>
<dt><b>TRUE</b></dt>
<dt>1</dt>
</dl>
</td>
<td width="60%">
Packet to be validated is a request packet from the client.

</td>
</tr>
<tr>
<td width="40%"><a id="FALSE"></a><a id="false"></a><dl>
<dt><b>FALSE</b></dt>
<dt>0</dt>
</dl>
</td>
<td width="60%">
Packet to be validated is a packet generated by the server.

</td>
</tr>
</table>
 


### -param pbPxeOptionPresent [out]

Address of a <b>BOOL</b> that is set to <b>TRUE</b> if the packet 
      is a valid DHCPv6 packet.


## -returns



If the function succeeds, the return value is <b>ERROR_SUCCESS</b>.




## -remarks



Providers use this function when the filter set with 
    the  <a href="https://docs.microsoft.com/windows/desktop/api/wdspxe/nf-wdspxe-pxeprovidersetattribute">PxeProviderSetAttribute</a> function is set to receive all 
    packets to determine if a specified packet is a valid DHCPv6 packet. Providers can also use this function to validate 
    reply packets; typically this is done only for debug or test builds of the provider.



