---
UID: NN:weakreference.IWeakReferenceSource
title: IWeakReferenceSource (weakreference.h)
description: Represents a source object to which a weak reference can be retrieved.
old-location: winrt\iweakreferencesource.htm
tech.root: WinRT
ms.assetid: f4b85374-192b-4024-80c2-a46bfebb16c1
ms.date: 12/05/2018
ms.keywords: IWeakReferenceSource, IWeakReferenceSource interface [Windows Runtime], IWeakReferenceSource interface [Windows Runtime],described, weakreference/IWeakReferenceSource, winrt.iweakreferencesource
f1_keywords:
- weakreference/IWeakReferenceSource
dev_langs:
- c++
req.header: weakreference.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: WeakReference.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- WeakReference.h
api_name:
- IWeakReferenceSource
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWeakReferenceSource interface


## -description


Represents a source object to which a weak reference can be retrieved.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IWeakReferenceSource</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IWeakReferenceSource</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IWeakReferenceSource</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/weakreference/nf-weakreference-iweakreferencesource-getweakreference">GetWeakReference</a>
</td>
<td align="left" width="63%">
Retrieves a weak reference from an <b>IWeakReferenceSource</b>.

</td>
</tr>
</table> 

