---
UID: NC:webservices.WS_SERVICE_STUB_CALLBACK
title: WS_SERVICE_STUB_CALLBACK (webservices.h)
description: Invoked by service model to delegate to the service operation call.
old-location: wsw\ws_service_stub_callback.htm
tech.root: wsw
ms.assetid: 3f561dfa-e83f-44f0-91b9-626b5b6036bd
ms.date: 12/05/2018
ms.keywords: WS_SERVICE_STUB_CALLBACK, WS_SERVICE_STUB_CALLBACK callback, WS_SERVICE_STUB_CALLBACK callback function [Web Services for Windows], webservices/WS_SERVICE_STUB_CALLBACK, wsw.ws_service_stub_callback
f1_keywords:
- webservices/WS_SERVICE_STUB_CALLBACK
dev_langs:
- c++
req.header: webservices.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- UserDefined
api_location:
- WebServices.h
api_name:
- WS_SERVICE_STUB_CALLBACK
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# WS_SERVICE_STUB_CALLBACK callback function


## -description


Invoked by service model to delegate to the service 
                operation call. This callback is generated by <a href="https://docs.microsoft.com/windows/desktop/wsw/web-service-compiler-tool">wsutil.exe</a> 
                for every service operation. It is defined on the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_operation_description">WS_OPERATION_DESCRIPTION</a> for each 
                service operation. 
            


## -parameters




### -param *context [in]

The <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-operation-context">context</a> within which this callback is being invoked. 
                


### -param *frame [in]

Pointer to the method frame. 
                


### -param *callback [in]

Pointer to the callback function to which the stub function corresponds to.  
                


### -param *asyncContext [in, optional]

Specifies whether the callback can run asynchronously. 
                


### -param *error [in, optional]

Specifies where additional error information should be stored if the function fails.
                


## -returns



This callback function does not return a value.




## -remarks



A generated callback, it is recommended that the application do not implement this callback on their own. 
            



