---
UID: NE:webservices.__unnamed_enum_22
title: WS_CHANNEL_PROPERTY_ID (webservices.h)
description: Each channel property is identified by an ID and has an associated value. If a property is not specified when the channel is created, then its default value is used.
old-location: wsw\ws_channel_property_id.htm
tech.root: wsw
ms.assetid: 3207c7f0-7f12-4f6b-8ddd-bac9c06ccfbf
ms.date: 12/05/2018
ms.keywords: WS_CHANNEL_PROPERTY_ADDRESSING_VERSION, WS_CHANNEL_PROPERTY_ALLOW_UNSECURED_FAULTS, WS_CHANNEL_PROPERTY_ASYNC_CALLBACK_MODEL, WS_CHANNEL_PROPERTY_CHANNEL_TYPE, WS_CHANNEL_PROPERTY_CLOSE_TIMEOUT, WS_CHANNEL_PROPERTY_CONNECT_TIMEOUT, WS_CHANNEL_PROPERTY_COOKIE_MODE, WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_CALLBACKS, WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_INSTANCE, WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_PARAMETERS, WS_CHANNEL_PROPERTY_CUSTOM_HTTP_PROXY, WS_CHANNEL_PROPERTY_DECODER, WS_CHANNEL_PROPERTY_ENABLE_HTTP_REDIRECT, WS_CHANNEL_PROPERTY_ENABLE_TIMEOUTS, WS_CHANNEL_PROPERTY_ENCODER, WS_CHANNEL_PROPERTY_ENCODING, WS_CHANNEL_PROPERTY_ENVELOPE_VERSION, WS_CHANNEL_PROPERTY_FAULTS_AS_ERRORS, WS_CHANNEL_PROPERTY_HTTP_CONNECTION_ID, WS_CHANNEL_PROPERTY_HTTP_MESSAGE_MAPPING, WS_CHANNEL_PROPERTY_HTTP_PROXY_SETTING_MODE, WS_CHANNEL_PROPERTY_HTTP_PROXY_SPN, WS_CHANNEL_PROPERTY_HTTP_REDIRECT_CALLBACK_CONTEXT, WS_CHANNEL_PROPERTY_HTTP_SERVER_SPN, WS_CHANNEL_PROPERTY_ID, WS_CHANNEL_PROPERTY_ID enumeration [Web Services for Windows], WS_CHANNEL_PROPERTY_IP_VERSION, WS_CHANNEL_PROPERTY_IS_SESSION_SHUT_DOWN, WS_CHANNEL_PROPERTY_KEEP_ALIVE_INTERVAL, WS_CHANNEL_PROPERTY_KEEP_ALIVE_TIME, WS_CHANNEL_PROPERTY_MAX_BUFFERED_MESSAGE_SIZE, WS_CHANNEL_PROPERTY_MAX_HTTP_REQUEST_HEADERS_BUFFER_SIZE, WS_CHANNEL_PROPERTY_MAX_HTTP_SERVER_CONNECTIONS, WS_CHANNEL_PROPERTY_MAX_SESSION_DICTIONARY_SIZE, WS_CHANNEL_PROPERTY_MAX_STREAMED_FLUSH_SIZE, WS_CHANNEL_PROPERTY_MAX_STREAMED_MESSAGE_SIZE, WS_CHANNEL_PROPERTY_MAX_STREAMED_START_SIZE, WS_CHANNEL_PROPERTY_MULTICAST_HOPS, WS_CHANNEL_PROPERTY_MULTICAST_INTERFACE, WS_CHANNEL_PROPERTY_NO_DELAY, WS_CHANNEL_PROPERTY_PROTECTION_LEVEL, WS_CHANNEL_PROPERTY_RECEIVE_RESPONSE_TIMEOUT, WS_CHANNEL_PROPERTY_RECEIVE_TIMEOUT, WS_CHANNEL_PROPERTY_REMOTE_ADDRESS, WS_CHANNEL_PROPERTY_REMOTE_IP_ADDRESS, WS_CHANNEL_PROPERTY_RESOLVE_TIMEOUT, WS_CHANNEL_PROPERTY_SEND_KEEP_ALIVES, WS_CHANNEL_PROPERTY_SEND_TIMEOUT, WS_CHANNEL_PROPERTY_STATE, WS_CHANNEL_PROPERTY_TRANSFER_MODE, WS_CHANNEL_PROPERTY_TRANSPORT_URL, WS_CHANNEL_PROPERTY_TRIM_BUFFERED_MESSAGE_SIZE, webservices/WS_CHANNEL_PROPERTY_ADDRESSING_VERSION, webservices/WS_CHANNEL_PROPERTY_ALLOW_UNSECURED_FAULTS, webservices/WS_CHANNEL_PROPERTY_ASYNC_CALLBACK_MODEL, webservices/WS_CHANNEL_PROPERTY_CHANNEL_TYPE, webservices/WS_CHANNEL_PROPERTY_CLOSE_TIMEOUT, webservices/WS_CHANNEL_PROPERTY_CONNECT_TIMEOUT, webservices/WS_CHANNEL_PROPERTY_COOKIE_MODE, webservices/WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_CALLBACKS, webservices/WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_INSTANCE, webservices/WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_PARAMETERS, webservices/WS_CHANNEL_PROPERTY_CUSTOM_HTTP_PROXY, webservices/WS_CHANNEL_PROPERTY_DECODER, webservices/WS_CHANNEL_PROPERTY_ENABLE_HTTP_REDIRECT, webservices/WS_CHANNEL_PROPERTY_ENABLE_TIMEOUTS, webservices/WS_CHANNEL_PROPERTY_ENCODER, webservices/WS_CHANNEL_PROPERTY_ENCODING, webservices/WS_CHANNEL_PROPERTY_ENVELOPE_VERSION, webservices/WS_CHANNEL_PROPERTY_FAULTS_AS_ERRORS, webservices/WS_CHANNEL_PROPERTY_HTTP_CONNECTION_ID, webservices/WS_CHANNEL_PROPERTY_HTTP_MESSAGE_MAPPING, webservices/WS_CHANNEL_PROPERTY_HTTP_PROXY_SETTING_MODE, webservices/WS_CHANNEL_PROPERTY_HTTP_PROXY_SPN, webservices/WS_CHANNEL_PROPERTY_HTTP_REDIRECT_CALLBACK_CONTEXT, webservices/WS_CHANNEL_PROPERTY_HTTP_SERVER_SPN, webservices/WS_CHANNEL_PROPERTY_ID, webservices/WS_CHANNEL_PROPERTY_IP_VERSION, webservices/WS_CHANNEL_PROPERTY_IS_SESSION_SHUT_DOWN, webservices/WS_CHANNEL_PROPERTY_KEEP_ALIVE_INTERVAL, webservices/WS_CHANNEL_PROPERTY_KEEP_ALIVE_TIME, webservices/WS_CHANNEL_PROPERTY_MAX_BUFFERED_MESSAGE_SIZE, webservices/WS_CHANNEL_PROPERTY_MAX_HTTP_REQUEST_HEADERS_BUFFER_SIZE, webservices/WS_CHANNEL_PROPERTY_MAX_HTTP_SERVER_CONNECTIONS, webservices/WS_CHANNEL_PROPERTY_MAX_SESSION_DICTIONARY_SIZE, webservices/WS_CHANNEL_PROPERTY_MAX_STREAMED_FLUSH_SIZE, webservices/WS_CHANNEL_PROPERTY_MAX_STREAMED_MESSAGE_SIZE, webservices/WS_CHANNEL_PROPERTY_MAX_STREAMED_START_SIZE, webservices/WS_CHANNEL_PROPERTY_MULTICAST_HOPS, webservices/WS_CHANNEL_PROPERTY_MULTICAST_INTERFACE, webservices/WS_CHANNEL_PROPERTY_NO_DELAY, webservices/WS_CHANNEL_PROPERTY_PROTECTION_LEVEL, webservices/WS_CHANNEL_PROPERTY_RECEIVE_RESPONSE_TIMEOUT, webservices/WS_CHANNEL_PROPERTY_RECEIVE_TIMEOUT, webservices/WS_CHANNEL_PROPERTY_REMOTE_ADDRESS, webservices/WS_CHANNEL_PROPERTY_REMOTE_IP_ADDRESS, webservices/WS_CHANNEL_PROPERTY_RESOLVE_TIMEOUT, webservices/WS_CHANNEL_PROPERTY_SEND_KEEP_ALIVES, webservices/WS_CHANNEL_PROPERTY_SEND_TIMEOUT, webservices/WS_CHANNEL_PROPERTY_STATE, webservices/WS_CHANNEL_PROPERTY_TRANSFER_MODE, webservices/WS_CHANNEL_PROPERTY_TRANSPORT_URL, webservices/WS_CHANNEL_PROPERTY_TRIM_BUFFERED_MESSAGE_SIZE, wsw.ws_channel_property_id
f1_keywords:
- webservices/WS_CHANNEL_PROPERTY_ID
dev_langs:
- c++
req.header: webservices.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WebServices.h
api_name:
- WS_CHANNEL_PROPERTY_ID
targetos: Windows
req.typenames: WS_CHANNEL_PROPERTY_ID
req.redist: 
ms.custom: 19H1
---

# WS_CHANNEL_PROPERTY_ID enumeration


## -description


Each channel property is identified by an ID and has an associated
                value.  If a property is not specified when the channel is created,
                then its default value is used.
            


## -enum-fields




### -field WS_CHANNEL_PROPERTY_MAX_BUFFERED_MESSAGE_SIZE

A <b>ULONG</b> 
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> or 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a>, 
                    <b>WS_HTTP_CHANNEL_BINDING</b>, or <b>WS_NAMEDPIPE_CHANNEL_BINDING</b>.  This value is a limit as to how big of a 
                    message may be received or sent by the channel.  The limit specifies the maximum size 
                    of the envelope in bytes as it appears in its encoded wire form.  
                    The minimum value is 1.
                

This property limits the amount of memory
                    that the channel will allocate in order to receive or send a buffered message.
                    When receiving with buffered input, the entire message is read into a
                    buffer before the application has access to it.  When sending with buffered output,
                    the entire message is accumulated in a buffer before being sent.
                

This property may only be specified when buffered input or output has been
                    specified (either <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_transfer_mode">WS_STREAMED_INPUT_TRANSFER_MODE</a> or 
                    <b>WS_STREAMED_OUTPUT_TRANSFER_MODE</b> have not been set). 
                

The default value is 65536.
                

The <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a> always uses the value 65536.
                


### -field WS_CHANNEL_PROPERTY_MAX_STREAMED_MESSAGE_SIZE

An <b>unsigned __int64</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> or
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>.  This 
                    value is a limit as to how big of a streamed message may be received or sent
                    for the channel.  
                    The limit specifies the maximum size of the envelope in bytes as it appears 
                    in its encoded wire form.  The minimum value is 1.
                

This property may only be specified when streamed input or output has been selected
                    (<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_transfer_mode">WS_STREAMED_INPUT_TRANSFER_MODE</a> or <b>WS_STREAMED_OUTPUT_TRANSFER_MODE</b>has been set).
                

The default value is 4194304.
                


### -field WS_CHANNEL_PROPERTY_MAX_STREAMED_START_SIZE

A <b>ULONG</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> or
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>.  
                    This value is a limit as to how big the start of a message may be.
                    The start of a message consists of the envelope tag, the headers, and the body tag.
                    The limit specifies the maximum size of the data in bytes as it appears in 
                    its encoded wire form.  The minimum value is 1.
                

This property may only be specified when streamed input has been selected
                    (<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_transfer_mode">WS_STREAMED_INPUT_TRANSFER_MODE</a>).
                

This property limits the amount of memory that the channel will allocate
                    in order to read the start of the message.  For streaming input, the
                    entire start of the message will be read into a buffer before the application
                    is notified that the start of the message has been read.
                

The default value is 16384.
                


### -field WS_CHANNEL_PROPERTY_MAX_STREAMED_FLUSH_SIZE

A <b>ULONG</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> or
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>.
                    This value is a limit as to how many bytes will be accumulated
                    before <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsflushbody">WsFlushBody</a> is called.
                

This property may only be specified when streamed output has been selected
                    (<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_transfer_mode">WS_STREAMED_OUTPUT_TRANSFER_MODE</a>).
                

This property limits the amount of memory that the channel will allocate
                    in order to accumulated buffered data.  For streaming output, the
                    channel will accumulate data in a buffer until <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsflushbody">WsFlushBody</a> is called.
                

The default value is 65536.
                


### -field WS_CHANNEL_PROPERTY_ENCODING

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_encoding">WS_ENCODING</a> value
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> or <b>WS_HTTP_CHANNEL_BINDING</b>.
                    This value specifies what encoding to use for the channel.  
                

The default value depends on the binding:
                    <ul>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a> uses <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_encoding">WS_ENCODING_XML_UTF8</a>.
                        </li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> uses <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_encoding">WS_ENCODING_XML_BINARY_SESSION_1</a>.
                    </li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_NAMEDPIPE_CHANNEL_BINDING</a> uses <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_encoding">WS_ENCODING_XML_BINARY_SESSION_1</a>.
                    </li>
</ul>


The <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a> always uses the value <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_encoding">WS_ENCODING_XML_UTF8</a>.
                


### -field WS_CHANNEL_PROPERTY_ENVELOPE_VERSION

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_envelope_version">WS_ENVELOPE_VERSION</a> value
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>.
                    This value specifies what envelope version to use for the channel.  The
                    envelope version of the channel must match that of the message used with
                    the channel.  
                

This property is not supported with the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_NAMEDPIPE_CHANNEL_BINDING</a>. Named Pipe channels always use <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_envelope_version">WS_ENVELOPE_VERSION_SOAP_1_2</a>.

The default value depends on the binding:
                    <ul>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a> uses <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_envelope_version">WS_ENVELOPE_VERSION_NONE</a> when
                        the <b>WS_CHANNEL_PROPERTY_ENCODING</b> is <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_encoding">WS_ENCODING_RAW</a>, and
                        <b>WS_ENVELOPE_VERSION_SOAP_1_2</b> for other encodings.
                        </li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a> uses <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_envelope_version">WS_ENVELOPE_VERSION_SOAP_1_2</a>.
                        </li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> uses <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_envelope_version">WS_ENVELOPE_VERSION_SOAP_1_2</a>.
                    </li>
</ul>



### -field WS_CHANNEL_PROPERTY_ADDRESSING_VERSION

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_addressing_version">WS_ADDRESSING_VERSION</a> value
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>.
                    This value specifies what addressing version to use for the channel.  The
                    addressing version of the channel must match that of the message used with
                    the channel.
                

The default value depends on the binding:
                    <ul>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a> uses <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_addressing_version">WS_ADDRESSING_VERSION_TRANSPORT</a> when
                        the <b>WS_CHANNEL_PROPERTY_ENCODING</b> is <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_encoding">WS_ENCODING_RAW</a>, and 
                        <b>WS_ADDRESSING_VERSION_1_0</b> for other encodings.
                        </li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a> uses <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_addressing_version">WS_ADDRESSING_VERSION_1_0</a>.
                        </li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> uses <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_addressing_version">WS_ADDRESSING_VERSION_1_0</a>.
                    </li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_NAMEDPIPE_CHANNEL_BINDING</a> uses <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_addressing_version">WS_ADDRESSING_VERSION_1_0</a>.</li>
</ul>


The <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_addressing_version">WS_ADDRESSING_VERSION_TRANSPORT</a> is only supported for
                   <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>.
                


### -field WS_CHANNEL_PROPERTY_MAX_SESSION_DICTIONARY_SIZE

A <b>ULONG</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>.
                    This property is only valid for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> or <b>WS_NAMEDPIPE_CHANNEL_BINDING</b>.
                    This value specifies the quota for number of bytes of session dictionary
                    strings that will be transmitted or received when using a session-based encoding.
                

The only session-based encoding supported currently is 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_encoding">WS_ENCODING_XML_BINARY_SESSION_1</a>, which is the default encoding
                    for the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a>.
                

If the quota is reached on the receiving side, then the channel
                    will fault.
                

If the quota is reached on the sending side, then the channel will simply
                    transmit the string without using the session dictionary.
                

This value is ignored if not using a session-based encoding.
                

The default value is 2048.
                


### -field WS_CHANNEL_PROPERTY_STATE

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_state">WS_CHANNEL_STATE</a> value
                    returned by <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>.
                

The returned value is a snapshot of the current state, so it is
                   possible that the state may have changed before the caller has
                   had a chance to examine the value.
                


### -field WS_CHANNEL_PROPERTY_ASYNC_CALLBACK_MODEL

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_callback_model">WS_CALLBACK_MODEL</a> value used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>.
                    This value indicates the preferred async callback model when issuing
                    async operations for the channel.
                

If using <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> see
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_listener_property_id">WS_LISTENER_PROPERTY_ASYNC_CALLBACK_MODEL</a>.
                

The default is <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_callback_model">WS_LONG_CALLBACK</a>.
                

Both the <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-host">WS_SERVICE_HOST</a> and <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-proxy">WS_SERVICE_PROXY</a> only support <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_callback_model">WS_LONG_CALLBACK</a> 
                    as an acceptable value for this property.
                


### -field WS_CHANNEL_PROPERTY_IP_VERSION

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_ip_version">WS_IP_VERSION</a> value
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> or <b>WS_UDP_CHANNEL_BINDING</b>.  
                    This property specifies which IP version that the channel should use to 
                    communicate with the remote endpoint. 
                

To specify the IP version to use for channels that are accepted, use the 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_listener_property_id">WS_LISTENER_PROPERTY_IP_VERSION</a> listener property when
                    creating the listener object.
                

The default value is <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_ip_version">WS_IP_VERSION_AUTO</a>.
                


### -field WS_CHANNEL_PROPERTY_RESOLVE_TIMEOUT

A <b>ULONG</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>,
                    or <b>WsSetChannelProperty</b> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>.
                    This timeout limits the amount of time that will be spent resolving
                    the DNS name.  The timeout value is in milliseconds,
                    where the value INFINITE indicates no timeout.
                

This property can be set in any channel state.
                

The default value is INFINITE.
                


### -field WS_CHANNEL_PROPERTY_CONNECT_TIMEOUT

A <b>ULONG</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>, or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> 
                    for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> or <b>WS_NAMEDPIPE_CHANNEL_BINDING</b> on the client side.
                    This timeout limits the amount of time that will be spent to connect to the remote machine and complete the net.tcp or net.pipe handshake.  The timeout value
                    is in milliseconds, where the value INFINITE indicates no timeout.  To set 
                    or get the corresponding timeout on the server side, use 
                    (<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_listener_property_id">WS_LISTENER_PROPERTY_CONNECT_TIMEOUT</a>).
                

Used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>,
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>, or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a> and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>.
                    This timeout limits the amount of time that will be spent to connect
                    to the HTTP server.  The timeout value is in milliseconds,
                    where the value INFINITE indicates no timeout.
                

This property can be set in any channel state.
                

The default value is 30000 (30 seconds).
                

The <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-proxy">WS_SERVICE_PROXY</a> sets this timeout to INFINITE by default.
                


### -field WS_CHANNEL_PROPERTY_SEND_TIMEOUT

A <b>ULONG</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>,
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>, or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> 
                    for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> or <b>WS_NAMEDPIPE_CHANNEL_BINDING</b>.  This timeout limits the
                    amount of time that will be spent sending the bytes of the message.
                    The timeout value is in milliseconds, where the value INFINITE indicates
                    no timeout. 
                

Used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>,
                    or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a> 
                    and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>.
                    This timeout limits the amount of time that will be spent sending the
                    HTTP headers and the bytes of the message.  The timeout value is in milliseconds, where the 
                    value INFINITE indicates no timeout.  
                

This property can be set in any channel state.
                

The default value is 30000 (30 seconds).
                

Both <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-host">WS_SERVICE_HOST</a> and <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-proxy">WS_SERVICE_PROXY</a> set this 
                    timeout to INFINITE by default.
                


### -field WS_CHANNEL_PROPERTY_RECEIVE_RESPONSE_TIMEOUT

A <b>ULONG</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>,
                    or <b>WsSetChannelProperty</b> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>.
                    This timeout limits the amount of time that will be spent waiting for
                    all the response headers to be received from the server.
                    The timeout value is in milliseconds, where the value INFINITE indicates no timeout.
                

This property can be set in any channel state.
                

The default value is 30000 (30 seconds).
                

The <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-proxy">WS_SERVICE_PROXY</a> sets this timeout to INFINITE.
                


### -field WS_CHANNEL_PROPERTY_RECEIVE_TIMEOUT

A <b>ULONG</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>,
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>, or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>, 
                    for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> or <b>WS_NAMEDPIPE_CHANNEL_BINDING</b>.
                    This timeout limits the amount of time that will be spent receiving the
                    the bytes of the message.
                    The timeout value is in milliseconds, where the value INFINITE indicates
                    no timeout.
                

Used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>,
                    or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>.
                    This timeout limits the amount of time that will be spent receiving the
                    bytes of the message.  The timeout value is in milliseconds, 
                    where the value INFINITE indicates no timeout.
                This timeout can be triggered by <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wswritemessageend">WsWriteMessageEnd</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsreadmessagestart">WsReadMessageStart</a>, and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsreadmessageend">WsReadMessageEnd</a>.

This property can be set in any channel state.
                

The default value is 30000 (30 seconds).
                

Both <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-host">WS_SERVICE_HOST</a> and <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-proxy">WS_SERVICE_PROXY</a> set this
                    timeout to INFINITE by default.
                


### -field WS_CHANNEL_PROPERTY_CLOSE_TIMEOUT

A <b>ULONG</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>, or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> 
                    for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> or <b>WS_NAMEDPIPE_CHANNEL_BINDING</b>.  
                    This timeout limits the amount of time that will be spent completing the
                    the close net.tcp or net.pipe handshake.  The timeout value is in milliseconds, where the 
                    value INFINITE indicates no timeout.  
                

This property can be set in any channel state.
                

The default value is 30000 (30 seconds).
                

The <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-proxy">WS_SERVICE_PROXY</a> sets this timeout to INFINITE by default.
                


### -field WS_CHANNEL_PROPERTY_ENABLE_TIMEOUTS

A <b>BOOL</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>, <b>WS_TCP_CHANNEL_BINDING</b>, <b>WS_NAMEDPIPE_CHANNEL_BINDING</b>, 
                    and <b>WS_UDP_CHANNEL_BINDING</b>. 
              Used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <b>WS_CUSTOM_CHANNEL_BINDING</b>. 
                

When this property is set to <b>TRUE</b> or not supplied when calling <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, 
                    more specific channel timeout properties (e.g. <b>WS_CHANNEL_PROPERTY_SEND_TIMEOUT</b>) 
                    takes precedence and behaves as documented. When this property is set to <b>FALSE</b>, 
                    all specific channel timeout properties are set to INFINITE unless they are explicitly specified.
                

This property can be queried from a custom channel using <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>, 
                    see <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nc-webservices-ws_get_channel_property_callback">WS_GET_CHANNEL_PROPERTY_CALLBACK</a> for more details.
                

The default value is <b>TRUE</b>.
                

In order to implement their own timeout logic, <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-proxy">WS_SERVICE_PROXY</a> and 
                    <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-host">WS_SERVICE_HOST</a> sets this property to <b>FALSE</b> for the 
                    standard channels bindings and require custom channels to support it by querying and 
                    verifying that it is set to <b>FALSE</b>.
                    More specific timeout properties can still be provided as described above.
                


### -field WS_CHANNEL_PROPERTY_TRANSFER_MODE

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_transfer_mode">WS_TRANSFER_MODE</a> value
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> 
                    for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a> to control whether messages
                    sent and received on the channel are buffered or streamed.  The client
                    and server may use different transfer modes and still be able to communicate.
                

All channels support <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for this
                    property.
                

For channel bindings other than <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>the value is always <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_transfer_mode">WS_BUFFERED_TRANSFER_MODE</a>.
                

The default property value is <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_transfer_mode">WS_BUFFERED_TRANSFER_MODE</a>. Note, 
                    only <b>WS_BUFFERED_TRANSFER_MODE</b> is used by Service Model for both
                     <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-proxy">WS_SERVICE_PROXY</a> and <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-host">WS_SERVICE_HOST</a>. The only exception 
                    is around using message contracts on WS_SERVICE_HOST, where 
                    <b>WS_STREAMED_OUTPUT_TRANSFER_MODE</b> is allowed.
                


<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_transfer_mode">WS_STREAMED_OUTPUT_TRANSFER_MODE</a> with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a> requires Windows Vista and above, and supports only <b>WS_HTTP_HEADER_AUTH_SCHEME_BASIC</b> when used with security.



### -field WS_CHANNEL_PROPERTY_MULTICAST_INTERFACE

A <b>ULONG</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>,
                    or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a> 
                    with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_DUPLEX</a> to indicate which adapter 
                    should be used when sending to a multicast address.
                

The value is the interface index of the adapter.
                

If this property is not set, or is 0, then the default adapter for the
                    machine is used.  This may not be appropriate for machines with multiple adapters.
                

This property can be set in any channel state.
                

The default property value is 0.
                


### -field WS_CHANNEL_PROPERTY_MULTICAST_HOPS

A <b>ULONG</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> 
                    for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a> with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_DUPLEX</a> 
                    to specify the max number of hops that a UDP message can travel.
                

The default property value is 1.
                


### -field WS_CHANNEL_PROPERTY_REMOTE_ADDRESS

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_endpoint_address">WS_ENDPOINT_ADDRESS</a> structure
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> 
                    for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a> with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_DUPLEX</a> 
                    to retrieve the endpoint address of the remote party for the channel.
                

The fields of the returned 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_endpoint_address">WS_ENDPOINT_ADDRESS</a> structure are valid and constant until the channel 
                    is reset or freed.  The caller should not modify the values the returned
                    fields of the <b>WS_ENDPOINT_ADDRESS</b> point to.
                

This property cannot be retrieved until the channel has reached the open state.
                

This property is based on the source IP address that is received from
                    the network, which may be spoofed or tampered with even if using a
                    secure channel (depending on the network environment).
                


### -field WS_CHANNEL_PROPERTY_REMOTE_IP_ADDRESS

A <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/ms740504(v=vs.85)">SOCKADDR_STORAGE</a>structure
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> 
                    for the following types of channels to retrieve the IP address
                    of the remote party:
                    <ul>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_DUPLEX_SESSION</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_DUPLEX</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REPLY</a>
</li>
</ul>


This property cannot be retrieved until the channel has begun reading a message.
                

This property is based on the source IP address that is received from
                    the network, which may be spoofed or tampered with even if using a
                    secure channel (depending on the network environment).
                


### -field WS_CHANNEL_PROPERTY_HTTP_CONNECTION_ID

A pointer to a <b>ULONGLONG</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> 
                    for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a> with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REPLY</a> 
                    to retrieve an identifier that uniquely identifies the client connection.
                

This property cannot be retrieved until the channel has begun reading a message. 
                

The connection ID uniquely identifies a connection while the
                    listener object that the channel was accepted from remains open.
                

A given reply channel instance is in no way correlated with a connection. 
                    Each time the channel is accepted, there may be a different connection ID 
                    (even if the total set of connections has not changed since the last accept). 
                

The connection ID can be used by an application to correlate state with 
                    a HTTP connection.
                


### -field WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_CALLBACKS

A <a href="https://docs.microsoft.com/windows/win32/api/webservices/ns-webservices-ws_custom_channel_callbacks">WS_CUSTOM_CHANNEL_CALLBACKS</a> structure used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_CUSTOM_CHANNEL_BINDING</a>.
                

This property is used to specify callbacks that
                    define the implementation of a custom channel.
                

This property must be specified when <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_CUSTOM_CHANNEL_BINDING</a> is used.
                


### -field WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_PARAMETERS

A pointer to an arbitrary sized data type used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_CUSTOM_CHANNEL_BINDING</a>.
                

This property is used to specify parameters used to create the custom
                    channel implementation.
                

The size of the property is the size of the data type.
                

The value of this property will be passed to the
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nc-webservices-ws_create_channel_callback">WS_CREATE_CHANNEL_CALLBACK</a>.
                

If this property is not specified, it's value is <b>NULL</b> and size is zero.
                


### -field WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_INSTANCE

A <b>void *</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_CUSTOM_CHANNEL_BINDING</a>.
                

The size of the property is <b>sizeof(void*)</b>.
                    The value corresponds to the channel instance value returned by
                    the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nc-webservices-ws_create_channel_callback">WS_CREATE_CHANNEL_CALLBACK</a>.
                

This property can be used to obtain the underlying channel
                    instance for a custom channel.  This allows a caller to directly
                    interact with the instance for cases when the existing
                    set of channel properties or channel functions is insufficient.
                


### -field WS_CHANNEL_PROPERTY_TRANSPORT_URL

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_string">WS_STRING</a> structure
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> 
                    for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a> or <b>WS_TCP_CHANNEL_BINDING</b>for channels created with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>.
                

This property is used on the server to obtain the URL that was passed
                    to <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsopenchannel">WsOpenChannel</a> on the client.  
                    This URL may be different than the value in the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_header_type">WS_TO_HEADER</a> 
                    if <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsaddressmessage">WsAddressMessage</a> was used.  The mapping of the
                    transport URL to the underlying transport varies by the
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_CHANNEL_BINDING</a>, as follows:
                

<ul>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>.  The transport URL is
                    the request URL.
                    </li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a>.  The transport URL is
                    the URL that is present at the .NET framing layer.
                </li>
</ul>
This property is only available once the channel has
                    been accepted using <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsacceptchannel">WsAcceptChannel</a>.
                

The caller should pass the address of a <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_string">WS_STRING</a> when
                    retrieving this property.  The returned string is a fully qualified
                    URL in encoded form.   The returned string is good until the channel 
                    is freed or reset.
                


### -field WS_CHANNEL_PROPERTY_NO_DELAY

A <b>BOOL</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a>.
                

This property controls the TCP_NODELAY socket option value of the underlying socket.
                

When this value is <b>FALSE</b>, the Nagle algorithm is used which can
                    improve throughput by coalescing small messages.
                

Setting this value to <b>TRUE</b> may decrease latency at the cost of throughput
                    for small messages.
                

The default value is <b>FALSE</b>.
                


### -field WS_CHANNEL_PROPERTY_SEND_KEEP_ALIVES

A <b>BOOL</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a>.
                

This property controls the SO_KEEPALIVE socket option value of the underlying socket.
                

Setting this value to <b>TRUE</b> will cause keep-alive packets to be sent
                    on the underlying socket, which may help detect when
                    a remote party is no longer available.
                

The default value is <b>FALSE</b>.
                


### -field WS_CHANNEL_PROPERTY_KEEP_ALIVE_TIME

A <b>ULONG</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a>.
                

This property is measured in milliseconds.
                

This property may only be specified when the <b>WS_CHANNEL_PROPERTY_SEND_KEEP_ALIVES</b>property has the value of <b>TRUE</b>.
                

The value represents the amount of time before sending keep alive packets if the
                    socket is not in use.
                

The default value is 2 hours.
                


### -field WS_CHANNEL_PROPERTY_KEEP_ALIVE_INTERVAL

A <b>ULONG</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a>.
                

This property is measured in milliseconds.
                

This property may only be specified when the <b>WS_CHANNEL_PROPERTY_SEND_KEEP_ALIVES</b>property has the value of <b>TRUE</b>.
                

After the time specified in <b>WS_CHANNEL_PROPERTY_KEEP_ALIVE_TIME</b> has expired,
                    the system will begin to send keep alive packets in an attempt to contact
                    the remote party.  This setting controls how often the system will send
                    another packet (as a retry attempt).
                

The default value is 1 second.
                


### -field WS_CHANNEL_PROPERTY_MAX_HTTP_SERVER_CONNECTIONS

A <b>ULONG</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>.
                

This property specifies the maximum number of connections that a client application 
                    may have against a HTTP server. 
                    Connections may be cached and re-used by other components within the same process accessing the same HTTP server.                    
                

The default value is INFINITE (no limit).
                


### -field WS_CHANNEL_PROPERTY_IS_SESSION_SHUT_DOWN

A <b>BOOL</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a> 
                    or <b>WS_NAMEDPIPE_CHANNEL_BINDING</b> with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_DUPLEX_SESSION</a>.
                

This property indicates
                    whether <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsshutdownsessionchannel">WsShutdownSessionChannel</a> has been
                    used to shut down the channel.
                

The channel must be in <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_state">WS_CHANNEL_STATE_OPEN</a> or 
                    <b>WS_CHANNEL_STATE_FAULTED</b> state.
                


### -field WS_CHANNEL_PROPERTY_CHANNEL_TYPE

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE</a> value
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for all channel types
                    to query the type of the channel.
                

The channel can be in any <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_state">WS_CHANNEL_STATE</a>.
                


### -field WS_CHANNEL_PROPERTY_TRIM_BUFFERED_MESSAGE_SIZE

A <b>ULONG</b>used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> or 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a>, 
                    <b>WS_HTTP_CHANNEL_BINDING</b>, or <b>WS_NAMEDPIPE_CHANNEL_BINDING</b> to control the memory allocation
                    characteristics for the messages on the channel.
                

This property specifies the maximum amount of memory the channel will keep 
                    around after a message is <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsresetmessage">reset</a>.  If all the
                    messages a channel sees are all smaller than this size, then allocations 
                    for purposes of buffering the messages will be minimized.
                

This property may only be specified when buffered input or output has been
                    specified (either <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_transfer_mode">WS_STREAMED_INPUT_TRANSFER_MODE</a> or 
                    <b>WS_STREAMED_OUTPUT_TRANSFER_MODE</b> have not been set). 
                

The default value is 65536.
                

The <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a> always uses the value 65536.
                


### -field WS_CHANNEL_PROPERTY_ENCODER

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_channel_encoder">WS_CHANNEL_ENCODER</a> structure used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a>, 
                    <b>WS_HTTP_CHANNEL_BINDING</b>, or <b>WS_NAMEDPIPE_CHANNEL_BINDING</b> to provide a custom encoding of messages.  

This property cannot be used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a>.
                


### -field WS_CHANNEL_PROPERTY_DECODER

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_channel_decoder">WS_CHANNEL_DECODER</a> structure used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_TCP_CHANNEL_BINDING</a>, 
                    <b>WS_HTTP_CHANNEL_BINDING</b>, or <b>WS_NAMEDPIPE_CHANNEL_BINDING</b> to provide a custom dencoding of messages.  

This property cannot be used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a>.
                


### -field WS_CHANNEL_PROPERTY_PROTECTION_LEVEL

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_protection_level">WS_PROTECTION_LEVEL</a> value used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for any channel type.
                

This property  indicates
                    the security assurances provided by the channel.
                

The value of this property depends on the security requirements
                    requested for the channel.
                


### -field WS_CHANNEL_PROPERTY_COOKIE_MODE

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_cookie_mode">WS_COOKIE_MODE</a> value used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>to control how HTTP cookies are handled.
                

The default value is <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_cookie_mode">WS_AUTO_COOKIE_MODE</a>.
                


### -field WS_CHANNEL_PROPERTY_HTTP_PROXY_SETTING_MODE

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_http_proxy_setting_mode">WS_HTTP_PROXY_SETTING_MODE</a> value used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>to control the HTTP proxy settings for the channel.
                

The default value is <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_http_proxy_setting_mode">WS_HTTP_PROXY_SETTING_MODE_AUTO</a>.
                


### -field WS_CHANNEL_PROPERTY_CUSTOM_HTTP_PROXY

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_custom_http_proxy">WS_CUSTOM_HTTP_PROXY</a> structure used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>to specify the custom custom setting for the HTTP channel. This property must
                    be specified when <b>WS_CHANNEL_PROPERTY_HTTP_PROXY_SETTING_MODE</b> is set to
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_http_proxy_setting_mode">WS_HTTP_PROXY_SETTING_MODE_CUSTOM</a>.
                

The default value is <b>NULL</b>.
                


### -field WS_CHANNEL_PROPERTY_HTTP_MESSAGE_MAPPING

A <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_http_message_mapping">WS_HTTP_MESSAGE_MAPPING</a> structure used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a>for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>.
                

This property value controls how an HTTP request or response is mapped into
                    a message object.  See <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_http_message_mapping">WS_HTTP_MESSAGE_MAPPING</a> for more information.
                

The default value for this property is a <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_http_message_mapping">WS_HTTP_MESSAGE_MAPPING</a>structure is as follows:
                

<ul>
<li>requestMappingOptions: 0
                    </li>
<li>requestHeaderMappings: none
                    </li>
<li>responseMappingOptions: 0
                    </li>
<li>responseHeaderMappings: none
                </li>
</ul>

<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_http_message_mapping">WS_HTTP_MESSAGE_MAPPING</a> fields requestMappingOptions and responseMappingOptions must be 0 
                    unless encoding is set to <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_encoding">WS_ENCODING_RAW</a> using channel property <b>WS_CHANNEL_PROPERTY_ENCODING</b>.
                


### -field WS_CHANNEL_PROPERTY_ENABLE_HTTP_REDIRECT

A <b>BOOL</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>.
                

This property value controls whether  HTTP auto redirection is enabled.
                

Setting this value to <b>TRUE</b> enables HTTP auto redirection.
                

The default value is <b>FALSE</b>. 
                    If the <b>WS_CHANNEL_PROPERTY_HTTP_REDIRECT_CALLBACK_CONTEXT</b> property is specified, 
                    this property is ignored.
                


### -field WS_CHANNEL_PROPERTY_HTTP_REDIRECT_CALLBACK_CONTEXT

A <a href="https://docs.microsoft.com/windows/win32/api/webservices/ns-webservices-ws_http_redirect_callback_context">WS_HTTP_REDIRECT_CALLBACK_CONTEXT</a> structure
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>.
                

This property value may be specified when more granular control of automatic HTTP redirection is needed.
                

When this property is set, the specified callback routine will be called with the original endpoint URL 
                    and the new URL that the message is to be forwarded to. Callback return value is used to indicate whether 
                    the redirection should be allowed.
                


### -field WS_CHANNEL_PROPERTY_FAULTS_AS_ERRORS

A <b>BOOL</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>,
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreateserviceproxy">WsCreateServiceProxy</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>, or <b>WS_TCP_CHANNEL_BINDING</b>, <b>WS_NAMEDPIPE_CHANNEL_BINDING</b>, and  <b>WS_UDP_CHANNEL_BINDING</b> on the client.           
                

When set to <b>TRUE</b>, Channel and Service Model functions return an error code when a fault is received. 
                    If the fault is recognized by this runtime, the corresponding error code is returned, 
                    otherwise <b>WS_E_ENDPOINT_FAULT_RECEIVED</b>  is returned. (See <a href="https://docs.microsoft.com/windows/desktop/wsw/windows-web-services-return-values">Windows Web Services Return Values</a>.) When set to <b>FALSE</b>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsreceivemessage">WsReceiveMessage</a> 
                    and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsrequestreply">WsRequestReply</a> return <b>WS_E_ENDPOINT_FAULT_RECEIVED</b> when a fault is received. 
                    The other channel functions return faults as regular messages and'<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_property_id">WS_MESSAGE_PROPERTY_IS_FAULT</a> 
                    can be used to distinguish faults from other messages. 
                

When this property is set to <b>TRUE</b> and used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>,
                    it overrides the following behavior of <b>WS_CHANNEL_PROPERTY_ALLOW_UNSECURED_FAULTS</b>: if the fault is recognized by the
                    runtime, an unsecured fault will not cause security verification of the fault message to fail even if
                    <b>WS_CHANNEL_PROPERTY_ALLOW_UNSECURED_FAULTS</b> is set to <b>FALSE</b>. The status of the security verification
                    can be determined by inspecting <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_property_id">WS_MESSAGE_PROPERTY_PROTECTION_LEVEL</a>.
                    This does not apply to <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_UDP_CHANNEL_BINDING</a> as it does not support security.
                

When this property is set to <b>FALSE</b> or used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreateserviceproxy">WsCreateServiceProxy</a> or the fault is not recognized 
                    by the runtime, the behavior described in <b>WS_CHANNEL_PROPERTY_ALLOW_UNSECURED_FAULTS</b> applies without
                    exception.
                

Regardless of this property value, if an error code is returned as a result of receiving a fault, 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetfaulterrorproperty">WsGetFaultErrorProperty</a> may be used to query the details of the fault from the error object.
                

This property can be set in any channel state.
                

The default value is <b>TRUE</b>. If used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreateserviceproxy">WsCreateServiceProxy</a>, this property must be set to <b>TRUE</b>.
                

          
            
                Setting this property to <b>TRUE</b> can cause message security verification to be disabled for certain faults.
                Unverified faults may not be trustworthy.
            


### -field WS_CHANNEL_PROPERTY_ALLOW_UNSECURED_FAULTS

A <b>BOOL</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannel">WsCreateChannel</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetchannelproperty">WsSetChannelProperty</a>,
                    or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>, or <b>WS_TCP_CHANNEL_BINDING</b> and <b>WS_NAMEDPIPE_CHANNEL_BINDING</b> on the client.
                

When set to <b>TRUE</b>, unsecured faults received on a secure channel do not cause message security verification to fail. Instead the
                    fault will be treated as if message security verification succeeded and handled as described in <b>WS_CHANNEL_PROPERTY_FAULTS_AS_ERRORS</b>.
                    The status of the security verification can be determined by inspecting <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_property_id">WS_MESSAGE_PROPERTY_PROTECTION_LEVEL</a>.
                

When set to <b>FALSE</b>, message security verification of fault messages is handled like the verification of any other message.
                

<b>WS_CHANNEL_PROPERTY_FAULTS_AS_ERRORS</b> may override this property for faults recognized by this runtime.
                

This property only applies to message-level security verification and has no impact on transport security.
                

This property can be set in any channel state.
                

The default value is <b>FALSE</b>.
                

Setting this property to <b>TRUE</b> causes message security verification for faults to be disabled. Unsecured faults may not be trustworthy.
            


### -field WS_CHANNEL_PROPERTY_HTTP_SERVER_SPN

A <b>WCHAR</b> pointer
                    used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>.

                

Returns the Server Principal Name of the remote endpoint used for the last failed request. There is no guarantee that this property is 
                    available. The following are the neccessary (but not always sufficient) conditions for this property to be present:
                    <ul>
<li>The channel sent a request.
                        </li>
<li>The request failed due to mismatched HTTP header authentication schemes. See <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_http_header_auth_security_binding">WS_HTTP_HEADER_AUTH_SECURITY_BINDING</a>.
                        </li>
<li>The remote endpoint supports the "Nego2" authentication scheme.
                    </li>
</ul>


This property is only available on Windows 7 and above.
            


### -field WS_CHANNEL_PROPERTY_HTTP_PROXY_SPN

A <b>WCHAR</b> pointer used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a>and <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REQUEST</a>.

                

Returns the Server Principal Name of the HTTP proxy server used for the last failed request. There is no guarantee that this property is
                    available. The following are the necessary (but not always sufficient) conditions for this property to be present:
                    <ul>
<li>The channel sent a request.
                        </li>
<li>The request failed due to mismatched HTTP header authentication schemes. See <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_http_header_auth_security_binding">WS_HTTP_HEADER_AUTH_SECURITY_BINDING</a>.
                        </li>
<li>The HTTP proxy server supports the "Nego2" authentication scheme.
                    </li>
</ul>


This property is only available on Windows 7 and above.
            


### -field WS_CHANNEL_PROPERTY_MAX_HTTP_REQUEST_HEADERS_BUFFER_SIZE

A <b>ULONG</b> used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatechannelforlistener">WsCreateChannelForListener</a> or
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetchannelproperty">WsGetChannelProperty</a> for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a> 
                    with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REPLY</a>. This value is a limit as to how big the headers 
                    of an HTTP request being received can be. The limit specifies the maximum size 
                    of the HTTP request headers in bytes.  
                

This property limits the amount of memory
                    that the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_binding">WS_HTTP_CHANNEL_BINDING</a> with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_type">WS_CHANNEL_TYPE_REPLY</a> 
                    will allocate in order to receive HTTP request headers. When receiving, the entire HTTP request 
                    headers are read into a buffer before processing.
                

The default value is 65536.
                

