---
UID: NE:webservices.__unnamed_enum_46
title: WS_MESSAGE_PROPERTY_ID (webservices.h)
description: Each message property is of type WS_MESSAGE_PROPERTY, is identified by an ID, and has an associated value.
old-location: wsw\ws_message_property_id.htm
tech.root: wsw
ms.assetid: 7398225c-afbd-45c6-9a32-8b8892f0ff8a
ms.date: 12/05/2018
ms.keywords: WS_MESSAGE_PROPERTY_ADDRESSING_VERSION, WS_MESSAGE_PROPERTY_BODY_READER, WS_MESSAGE_PROPERTY_BODY_WRITER, WS_MESSAGE_PROPERTY_ENCODED_CERT, WS_MESSAGE_PROPERTY_ENVELOPE_VERSION, WS_MESSAGE_PROPERTY_HEADER_BUFFER, WS_MESSAGE_PROPERTY_HEADER_POSITION, WS_MESSAGE_PROPERTY_HEAP, WS_MESSAGE_PROPERTY_HEAP_PROPERTIES, WS_MESSAGE_PROPERTY_HTTP_HEADER_AUTH_WINDOWS_TOKEN, WS_MESSAGE_PROPERTY_ID, WS_MESSAGE_PROPERTY_ID enumeration [Web Services for Windows], WS_MESSAGE_PROPERTY_IS_ADDRESSED, WS_MESSAGE_PROPERTY_IS_FAULT, WS_MESSAGE_PROPERTY_MAX_PROCESSED_HEADERS, WS_MESSAGE_PROPERTY_MESSAGE_SECURITY_WINDOWS_TOKEN, WS_MESSAGE_PROPERTY_PROTECTION_LEVEL, WS_MESSAGE_PROPERTY_SAML_ASSERTION, WS_MESSAGE_PROPERTY_SECURITY_CONTEXT, WS_MESSAGE_PROPERTY_STATE, WS_MESSAGE_PROPERTY_TRANSPORT_SECURITY_WINDOWS_TOKEN, WS_MESSAGE_PROPERTY_USERNAME, WS_MESSAGE_PROPERTY_XML_READER_PROPERTIES, WS_MESSAGE_PROPERTY_XML_WRITER_PROPERTIES, webservices/WS_MESSAGE_PROPERTY_ADDRESSING_VERSION, webservices/WS_MESSAGE_PROPERTY_BODY_READER, webservices/WS_MESSAGE_PROPERTY_BODY_WRITER, webservices/WS_MESSAGE_PROPERTY_ENCODED_CERT, webservices/WS_MESSAGE_PROPERTY_ENVELOPE_VERSION, webservices/WS_MESSAGE_PROPERTY_HEADER_BUFFER, webservices/WS_MESSAGE_PROPERTY_HEADER_POSITION, webservices/WS_MESSAGE_PROPERTY_HEAP, webservices/WS_MESSAGE_PROPERTY_HEAP_PROPERTIES, webservices/WS_MESSAGE_PROPERTY_HTTP_HEADER_AUTH_WINDOWS_TOKEN, webservices/WS_MESSAGE_PROPERTY_ID, webservices/WS_MESSAGE_PROPERTY_IS_ADDRESSED, webservices/WS_MESSAGE_PROPERTY_IS_FAULT, webservices/WS_MESSAGE_PROPERTY_MAX_PROCESSED_HEADERS, webservices/WS_MESSAGE_PROPERTY_MESSAGE_SECURITY_WINDOWS_TOKEN, webservices/WS_MESSAGE_PROPERTY_PROTECTION_LEVEL, webservices/WS_MESSAGE_PROPERTY_SAML_ASSERTION, webservices/WS_MESSAGE_PROPERTY_SECURITY_CONTEXT, webservices/WS_MESSAGE_PROPERTY_STATE, webservices/WS_MESSAGE_PROPERTY_TRANSPORT_SECURITY_WINDOWS_TOKEN, webservices/WS_MESSAGE_PROPERTY_USERNAME, webservices/WS_MESSAGE_PROPERTY_XML_READER_PROPERTIES, webservices/WS_MESSAGE_PROPERTY_XML_WRITER_PROPERTIES, wsw.ws_message_property_id
f1_keywords:
- webservices/WS_MESSAGE_PROPERTY_ID
dev_langs:
- c++
req.header: webservices.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WebServices.h
api_name:
- WS_MESSAGE_PROPERTY_ID
targetos: Windows
req.typenames: WS_MESSAGE_PROPERTY_ID
req.redist: 
ms.custom: 19H1
---

# WS_MESSAGE_PROPERTY_ID enumeration


## -description


Each message property is of type <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a>, is identified by an ID, and has an associated
                value.
            


## -enum-fields




### -field WS_MESSAGE_PROPERTY_STATE

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a>.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is the current <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE</a> of the message.

This property is available in all message states.
                


### -field WS_MESSAGE_PROPERTY_HEAP

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a>.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is the <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-heap">WS_HEAP</a> of the message.  The heap is
                    owned by the message.  A user of a message is free to make additional
                    allocations within this heap.  Allocations within the heap are free'd
                    when a message is reset/freed.
                

The user of the returned heap should not call <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsresetheap">WsResetHeap</a>on the heap.  This will result in undefined behavior.
                

The message object will not use the heap object unless one of
                    the message APIs is invoked.
                

This property is available in all message states except <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>. 
                    Using the heap of an empty message will result in undefined behavior.
                


### -field WS_MESSAGE_PROPERTY_ENVELOPE_VERSION

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a>.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure  is the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_envelope_version">WS_ENVELOPE_VERSION</a> of the message.
                

When creating a message using <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatemessage">WsCreateMessage</a>, the
                    envelope version is specified as an explicit parameter (instead
                    of as a property).
                

This property may be specified when message properties are specified using
                    the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_properties">WS_MESSAGE_PROPERTIES</a> structure.
                

This property is available in all message states except <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                


### -field WS_MESSAGE_PROPERTY_ADDRESSING_VERSION

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a>.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure  is the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_addressing_version">WS_ADDRESSING_VERSION</a> of the message.
                

When creating a message using <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatemessage">WsCreateMessage</a>, the
                    addressing version is specified as an explicit parameter (instead
                    of as a property).
                

This property may be specified when message properties are specified using 
                    the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_properties">WS_MESSAGE_PROPERTIES</a> structure.
                

This property is available in all message states except <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                


### -field WS_MESSAGE_PROPERTY_HEADER_BUFFER

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a>.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure  is a <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-xml-buffer">WS_XML_BUFFER</a> that holds the headers
                    of the message (as well as the envelope and body elements).
                

This buffer is valid until the message is reset/freed.
                

This property is available in all message states except <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                


### -field WS_MESSAGE_PROPERTY_HEADER_POSITION

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a>.

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure  is the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_xml_node_position">WS_XML_NODE_POSITION</a>of the header element within the header buffer (the element that contains all
                    the message headers as children).  The header buffer itself can be
                    obtained using <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_property_id">WS_MESSAGE_PROPERTY_HEADER_BUFFER</a>.
                

An application can use the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_xml_node_position">WS_XML_NODE_POSITION</a> returned as a starting 
                    point when reading or writing headers manually (when not using <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetheader">WsSetHeader</a>, 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetheader">WsGetHeader</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetcustomheader">WsGetCustomHeader</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsaddcustomheader">WsAddCustomHeader</a>).  
                    For example, the position can be passed to <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetwriterposition">WsSetWriterPosition</a> or 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetreaderposition">WsSetReaderPosition</a> to position an <a href="https://docs.microsoft.com/windows/desktop/wsw/xml-reader">XML Reader</a> or <a href="https://docs.microsoft.com/windows/desktop/wsw/xml-writer">XML Writer</a>within the <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-xml-buffer">WS_XML_BUFFER</a> containining the headers.  Additionally, 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsmovereader">WsMoveReader</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsmovewriter">WsMoveWriter</a> can be used to move relative 
                    to the position that was set.
                

When the headers of a message are read (via <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsreadmessagestart">WsReadMessageStart</a> or
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsreadenvelopestart">WsReadEnvelopeStart</a>, a header element is automatically added to the 
                    header buffer if one is not present in the message being read.  When a message is initialized
                    (via <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsinitializemessage">WsInitializeMessage</a>), a header element is added automatically
                    to the message.
                

This property is available in all message states except <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                

The header position is valid until the message is reset or freed.
                


### -field WS_MESSAGE_PROPERTY_BODY_READER

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a>.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure  is a <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-xml-reader">WS_XML_READER</a> that can be used to read
                    the body of the message.
                

The reader is owned by the message object, and is valid only 
                    until either <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsfreemessage">WsFreeMessage</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsresetmessage">WsResetMessage</a> are called.
                

This property is only available when the message is 
                    in <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_READING</a> state.
                


### -field WS_MESSAGE_PROPERTY_BODY_WRITER

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a>.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure  is a <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-xml-writer">WS_XML_WRITER</a> that can be used to write
                    the body of the message.
                

This property is only available when the message is in 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_WRITING</a> state.
                

The writer is owned by the message object, and is valid only
                    until either <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsfreemessage">WsFreeMessage</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsresetmessage">WsResetMessage</a> are called.
                


### -field WS_MESSAGE_PROPERTY_IS_ADDRESSED

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a>.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure  is a <b>BOOL</b> indicating whether the message has
                    been addressed.
                

When a message is created or reset, this property is
                    set to <b>FALSE</b>.
                

When a message is read (<a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsreadmessagestart">WsReadMessageStart</a> or
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsreadenvelopestart">WsReadEnvelopeStart</a>, then this property is
                    set to <b>TRUE</b>.
                

This property is available in all message states except <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                

See <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsaddressmessage">WsAddressMessage</a> for more information.
                


### -field WS_MESSAGE_PROPERTY_HEAP_PROPERTIES

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatemessage">WsCreateMessage</a> to specify the properties
                    of the <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-heap">WS_HEAP</a> associated with the message.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is of type <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_heap_properties">WS_HEAP_PROPERTIES</a>.
                

The heap is used to buffer the headers of the message.
                

The following heap properties may be specified:
                

<ul>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_heap_property_id">WS_HEAP_PROPERTY_MAX_SIZE</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_heap_property_id">WS_HEAP_PROPERTY_TRIM_SIZE</a>
</li>
</ul>

### -field WS_MESSAGE_PROPERTY_XML_READER_PROPERTIES

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatemessage">WsCreateMessage</a> to specify properties 
                    that apply to <a href="https://docs.microsoft.com/windows/desktop/wsw/xml-reader">XML Readers</a> that are used with the message.
                

These XML Reader properties are used by the message object when reading headers.
                    In addition, channels use these properties for the readers that they create to read
                    messages.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is of type <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_xml_reader_properties">WS_XML_READER_PROPERTIES</a>.
                

The following properties may be specified:
                

<ul>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_reader_property_id">WS_XML_READER_PROPERTY_MAX_DEPTH</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_reader_property_id">WS_XML_READER_PROPERTY_MAX_ATTRIBUTES</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_reader_property_id">WS_XML_READER_PROPERTY_READ_DECLARATION</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_reader_property_id">WS_XML_READER_PROPERTY_UTF8_TRIM_SIZE</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_reader_property_id">WS_XML_READER_PROPERTY_STREAM_BUFFER_SIZE</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_reader_property_id">WS_XML_READER_PROPERTY_STREAM_MAX_ROOT_MIME_PART_SIZE</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_reader_property_id">WS_XML_READER_PROPERTY_STREAM_MAX_MIME_HEADERS_SIZE</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_reader_property_id">WS_XML_READER_PROPERTY_MAX_MIME_PARTS</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_reader_property_id">WS_XML_READER_PROPERTY_ALLOW_INVALID_CHARACTER_REFERENCES</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_reader_property_id">WS_XML_READER_PROPERTY_MAX_NAMESPACES</a>
</li>
</ul>

### -field WS_MESSAGE_PROPERTY_XML_WRITER_PROPERTIES

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatemessage">WsCreateMessage</a> to specify the properties
                    of the <a href="https://docs.microsoft.com/windows/desktop/wsw/xml-writer">XML Writers</a> that are used with the message.
                

These XML Writer properties are used by the message object when writing headers.
                    In addition, channels use these properties for the wrtiers that they create to write
                    messages.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is of type <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_xml_writer_properties">WS_XML_WRITER_PROPERTIES</a>.
                

The following properties may be specified:
                

<ul>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_writer_property_id">WS_XML_WRITER_PROPERTY_MAX_DEPTH</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_writer_property_id">WS_XML_WRITER_PROPERTY_MAX_ATTRIBUTES</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_writer_property_id">WS_XML_WRITER_PROPERTY_WRITE_DECLARATION</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_writer_property_id">WS_XML_WRITER_PROPERTY_BUFFER_TRIM_SIZE</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_writer_property_id">WS_XML_WRITER_PROPERTY_MAX_MIME_PARTS_BUFFER_SIZE</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_writer_property_id">WS_XML_WRITER_PROPERTY_ALLOW_INVALID_CHARACTER_REFERENCES</a>
</li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_xml_writer_property_id">WS_XML_WRITER_PROPERTY_MAX_NAMESPACES</a>
</li>
</ul>

### -field WS_MESSAGE_PROPERTY_IS_FAULT

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetmessageproperty">WsSetMessageProperty</a>to indicate whether a message contains a fault.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is a <b>BOOL</b>.

When a message is read (<a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsreadmessagestart">WsReadMessageStart</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsreadenvelopestart">WsReadEnvelopeStart</a>),
                    this property is set according to whether the first element of the body is a fault
                    element.  An application can test this property as a way of deciding whether
                    to read the body as a fault.  To read the body as a fault, use <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsreadbody">WsReadBody</a> 
                    with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_type">WS_FAULT_TYPE</a> to obtain a <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_fault">WS_FAULT</a>.
                

When a message is written (<a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wswritemessagestart">WsWriteMessageStart</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wswriteenvelopestart">WsWriteEnvelopeStart</a>)
                    this property can be used to indicate whether or not the application will write a fault
                    in the body.  Some channels will use this information in order to determine how to 
                    send the message.  For example, HTTP will send a 500 status code for faults instead of 200.
                

When a message is initialized using <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsinitializemessage">WsInitializeMessage</a> with
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_initialization">WS_FAULT_MESSAGE</a>, the property is set to <b>TRUE</b>.  
                    For other <b>WS_MESSAGE_INITIALIZATION</b> values, the property is set to <b>FALSE</b>.
                

This property is available in all message states except <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                


### -field WS_MESSAGE_PROPERTY_MAX_PROCESSED_HEADERS

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wscreatemessage">WsCreateMessage</a> to specify the maximum number of headers
                    that will be allowed when processing the message headers.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is a <b>ULONG</b>.

The purpose of this limit is to put an upper bound on the number of iterations 
                    spent scanning for a header.
                

Since an application can directly modify the contents of the header buffer,
                    this limit is not enforced in all cases.  It is only enforced when one of 
                    the header access APIs are used (<a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetheader">WsSetHeader</a>, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetheader">WsGetHeader</a>, 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetcustomheader">WsGetCustomHeader</a>, or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmappedheader">WsGetMappedHeader</a>).
                

The default value is 64.
                


### -field WS_MESSAGE_PROPERTY_USERNAME

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a> to retrieve the sender's
                    username from a received message, if username/password based security
                    is on, or if a custom channel has set the value.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is a <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_string">WS_STRING</a> structure.

The returned value is good until the message is freed or reset.
                

A custom channel can use <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetmessageproperty">WsSetMessageProperty</a> to set
                    the sender's username from the message if it supports username/password
                    based security.  The function will make a copy of the value specified.
                

This property is available in all message states except 
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                


### -field WS_MESSAGE_PROPERTY_ENCODED_CERT

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a> to retrieve the sender's
                    certificate from a received message as encoded bytes, if
                    a certificate-based security mode (such as SSL) is on, 
                    or if a custom channel has set the value.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is a <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_bytes">WS_BYTES</a> structure.

The returned value is good until the message is freed or reset.
                

A custom channel can use <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetmessageproperty">WsSetMessageProperty</a> to set
                    the sender's certificate from a received message if it supports
                    a certificate-based security mode.  The function will make a copy of the value specified.
                

This property is available in all message states except
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                


### -field WS_MESSAGE_PROPERTY_TRANSPORT_SECURITY_WINDOWS_TOKEN

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a> to retrieve the Windows
                    token representing the sender from a received message.  This property is 
                    available in the following cases:
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is a <b>HANDLE</b>.

<ul>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_tcp_sspi_transport_security_binding">WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING</a> is being used.
                    </li>
<li>
<a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_ssl_transport_security_binding">WS_SSL_TRANSPORT_SECURITY_BINDING</a> is being used 
                    and the translation from client certificate to Windows token
                    has been enabled at the http.sys config level.
                    </li>
<li>A custom channel implementation has set the value.
                </li>
</ul>
The returned value is good until the message is freed or reset.
                

A custom channel can use <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetmessageproperty">WsSetMessageProperty</a> to set
                    the sender's certificate from a received message if it supports
                    a certificate-based security mode.  The function will duplicate the handle specified.
                

This property is available in all message states except
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                


### -field WS_MESSAGE_PROPERTY_HTTP_HEADER_AUTH_WINDOWS_TOKEN

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a> to retrieve the Windows
                    token representing the sender from a received message, if the
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_http_header_auth_security_binding">WS_HTTP_HEADER_AUTH_SECURITY_BINDING</a> is used,
                    or if a custom channel has set the value.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is a <b>HANDLE</b>.

The returned value is good until the message is freed or reset.
                

A custom channel can use <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetmessageproperty">WsSetMessageProperty</a>to set
                    the windows token representing the sender from a received message.
                    The function will duplicate the handle specified.
                

This property is available in all message states except
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                


### -field WS_MESSAGE_PROPERTY_MESSAGE_SECURITY_WINDOWS_TOKEN

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a> to retrieve the Windows
                    token representing the sender from a received message, if a message security
                    binding such as <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_kerberos_apreq_message_security_binding">WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING</a> is used,
                    or if a custom channel has set the value.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is a <b>HANDLE</b>.

The returned value is good until the message is freed or reset.
                

A custom channel can use <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetmessageproperty">WsSetMessageProperty</a> to set
                    the token representing the sender from a received message.
                    The function will duplicate the handle specified.
                

This property is available in all message states except
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                


### -field WS_MESSAGE_PROPERTY_SAML_ASSERTION

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a> to retrieve the SAML assertion
                    representing the sender from a received message, if the
                    <a href="https://docs.microsoft.com/windows/win32/api/webservices/ns-webservices-ws_saml_message_security_binding">WS_SAML_MESSAGE_SECURITY_BINDING</a> is used on the server side,
                    or if a custom channel has set the value.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is a <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-xml-buffer">WS_XML_BUFFER</a>.

The returned value is good until the message is freed or reset.
                

A custom channel can use <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetmessageproperty">WsSetMessageProperty</a> to set
                    the SAML assertion representing the sender from a received message.
                    The function will duplicate the buffer specified.
                

This property is available in all message states except
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
                


### -field WS_MESSAGE_PROPERTY_SECURITY_CONTEXT

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a> to retrieve the secure conversation handle if the
                    <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_security_context_message_security_binding">WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING</a> is used on the server side.
                

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is a <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-security-context">WS_SECURITY_CONTEXT</a>.

The returned value is good until the message is freed or reset.
                


### -field WS_MESSAGE_PROPERTY_PROTECTION_LEVEL

This property is used with <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsgetmessageproperty">WsGetMessageProperty</a> to retrieve the message's security protection level.

The accompanying <b>value</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_message_property">WS_MESSAGE_PROPERTY</a> structure is a <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_protection_level">WS_PROTECTION_LEVEL</a> value.

If the channel does not use security, or if security verification failed, the protection level is set to 
                <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_protection_level">WS_PROTECTION_LEVEL_NONE</a>. Otherwise it is set to the level requested by the application.            
            

This property may be used to dermine the status of the security verification when <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_channel_property_id">WS_CHANNEL_PROPERTY_ALLOW_UNSECURED_FAULTS</a> 
                is set to <b>FALSE</b>.
            

A custom channel can use <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetmessageproperty">WsSetMessageProperty</a> to set
                the protection level of a received message.
            

This property is available in all message states except
                <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_message_state">WS_MESSAGE_STATE_EMPTY</a>.
            

