---
UID: NE:webservices.__unnamed_enum_8
title: WS_VALUE_TYPE (webservices.h)
description: The types of fixed-size primitives.
old-location: wsw\ws_value_type.htm
tech.root: wsw
ms.assetid: 6075ed1c-ceb5-421a-8a76-3a64b9e6dbe3
ms.date: 12/05/2018
ms.keywords: WS_BOOL_VALUE_TYPE, WS_DATETIME_VALUE_TYPE, WS_DECIMAL_VALUE_TYPE, WS_DOUBLE_VALUE_TYPE, WS_DURATION_VALUE_TYPE, WS_FLOAT_VALUE_TYPE, WS_GUID_VALUE_TYPE, WS_INT16_VALUE_TYPE, WS_INT32_VALUE_TYPE, WS_INT64_VALUE_TYPE, WS_INT8_VALUE_TYPE, WS_TIMESPAN_VALUE_TYPE, WS_UINT16_VALUE_TYPE, WS_UINT32_VALUE_TYPE, WS_UINT64_VALUE_TYPE, WS_UINT8_VALUE_TYPE, WS_VALUE_TYPE, WS_VALUE_TYPE enumeration [Web Services for Windows], webservices/WS_BOOL_VALUE_TYPE, webservices/WS_DATETIME_VALUE_TYPE, webservices/WS_DECIMAL_VALUE_TYPE, webservices/WS_DOUBLE_VALUE_TYPE, webservices/WS_DURATION_VALUE_TYPE, webservices/WS_FLOAT_VALUE_TYPE, webservices/WS_GUID_VALUE_TYPE, webservices/WS_INT16_VALUE_TYPE, webservices/WS_INT32_VALUE_TYPE, webservices/WS_INT64_VALUE_TYPE, webservices/WS_INT8_VALUE_TYPE, webservices/WS_TIMESPAN_VALUE_TYPE, webservices/WS_UINT16_VALUE_TYPE, webservices/WS_UINT32_VALUE_TYPE, webservices/WS_UINT64_VALUE_TYPE, webservices/WS_UINT8_VALUE_TYPE, webservices/WS_VALUE_TYPE, wsw.ws_value_type
f1_keywords:
- webservices/WS_VALUE_TYPE
dev_langs:
- c++
req.header: webservices.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WebServices.h
api_name:
- WS_VALUE_TYPE
targetos: Windows
req.typenames: WS_VALUE_TYPE
req.redist: 
ms.custom: 19H1
---

# WS_VALUE_TYPE enumeration


## -description


The types of fixed-size primitives.
      


## -enum-fields




### -field WS_BOOL_VALUE_TYPE

Used to indicate a BOOL value.
        


### -field WS_INT8_VALUE_TYPE

Used to indicate a signed 8-bit integer.
        


### -field WS_INT16_VALUE_TYPE

Used to indicate a signed 16-bit integer.
        


### -field WS_INT32_VALUE_TYPE

Used to indicate a signed 32-bit integer.
        


### -field WS_INT64_VALUE_TYPE

Used to indicate a signed 64-bit integer.
        


### -field WS_UINT8_VALUE_TYPE

Used to indicate an unsigned 8-bit integer.
        


### -field WS_UINT16_VALUE_TYPE

Used to indicate an unsigned 16-bit integer.
        


### -field WS_UINT32_VALUE_TYPE

Used to indicate an unsigned 32-bit integer.
        


### -field WS_UINT64_VALUE_TYPE

Used to indicate an unsigned 64-bit integer.
        


### -field WS_FLOAT_VALUE_TYPE

Used to indicate a 32-bit floating point value.
        


### -field WS_DOUBLE_VALUE_TYPE

Used to indicate a 64-bit floating point value.
        


### -field WS_DECIMAL_VALUE_TYPE

Used to indicate a 96-bit fixed point value.
        


### -field WS_DATETIME_VALUE_TYPE

Used to indicate a date and time.
        


### -field WS_TIMESPAN_VALUE_TYPE

Used to indicate a signed 64-bit time period in 100 nanosecond units.
        


### -field WS_GUID_VALUE_TYPE

Used to indicate a GUID.
        


### -field WS_DURATION_VALUE_TYPE

Used to indicate a <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_duration">WS_DURATION</a>.
        

