---
UID: NF:webservices.WsWriteXmlBufferToBytes
title: WsWriteXmlBufferToBytes function (webservices.h)
description: Uses a writer to convert a WS_XML_BUFFER to an encoded set of bytes.
old-location: wsw\wswritexmlbuffertobytes.htm
tech.root: wsw
ms.assetid: dea4bfa5-7cd0-440f-89fe-e46af116462e
ms.date: 12/05/2018
ms.keywords: WsWriteXmlBufferToBytes, WsWriteXmlBufferToBytes function [Web Services for Windows], webservices/WsWriteXmlBufferToBytes, wsw.wswritexmlbuffertobytes
f1_keywords:
- webservices/WsWriteXmlBufferToBytes
dev_langs:
- c++
req.header: webservices.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: WebServices.lib
req.dll: WebServices.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- WebServices.dll
api_name:
- WsWriteXmlBufferToBytes
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# WsWriteXmlBufferToBytes function


## -description


Uses a writer to convert a <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-xml-buffer">WS_XML_BUFFER</a> to an encoded set of bytes.
      


## -parameters




### -param writer [in]

The writer to use to generate the encoded bytes.
        


### -param xmlBuffer [in]

The XML buffer to write.
        


### -param encoding [in, optional]

The encoding to use when generating the bytes.  If <b>NULL</b>, the bytes will be encoded in utf8.
        


### -param properties

An array of optional properties of the writer.  See <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ns-webservices-ws_xml_writer_property">WS_XML_WRITER_PROPERTY</a>.
        


### -param propertyCount [in]

The number of properties.


### -param heap [in]

The heap from which to allocate the bytes.
        


### -param bytes

The generated bytes are returned here.
        


### -param byteCount [out]

The number of generated bytes are returned here.
        


### -param error [in, optional]

Specifies where additional error information should be stored if the function fails.
        


## -returns



This function can return one of these values.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
One or more arguments are invalid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>WS_E_INVALID_OPERATION</b></dt>
</dl>
</td>
<td width="60%">
The operation is not allowed due to the current state of the object.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>WS_E_QUOTA_EXCEEDED</b></dt>
</dl>
</td>
<td width="60%">
A quota was exceeded.

</td>
</tr>
</table>
 




## -remarks



The function will generate the entire contents of the <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-xml-buffer">WS_XML_BUFFER</a> as a linear set of bytes 
        allocated from the specified heap in the encoding specified.
      

The writer will be left in an undefined state after calling this function.  However, <b>WsWriteXmlBufferToBytes</b> 
        may be used again with such a writer.  Otherwise, <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetoutput">WsSetOutput</a> or <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wssetoutputtobuffer">WsSetOutputToBuffer</a> should be
        used to bring the writer back to a known state, or the writer should be freed using <a href="https://docs.microsoft.com/windows/desktop/api/webservices/nf-webservices-wsfreewriter">WsFreeWriter</a>.
      



