---
UID: NS:webservices._WS_SERVICE_ENDPOINT_METADATA
title: WS_SERVICE_ENDPOINT_METADATA (webservices.h)
description: Represents the port element for the endpoint. The port element is generated for the service element as specified by serviceName and serviceNs for WS_SERVICE_PROPERTY_METADATA property on the WS_SERVICE_HOST.
old-location: wsw\ws_service_endpoint_metadata.htm
tech.root: wsw
ms.assetid: e02ea746-ed56-48a7-8cd4-9e51d100ef2a
ms.date: 12/05/2018
ms.keywords: WS_SERVICE_ENDPOINT_METADATA, WS_SERVICE_ENDPOINT_METADATA structure [Web Services for Windows], webservices/WS_SERVICE_ENDPOINT_METADATA, wsw.ws_service_endpoint_metadata
f1_keywords:
- webservices/WS_SERVICE_ENDPOINT_METADATA
dev_langs:
- c++
req.header: webservices.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WebServices.h
api_name:
- WS_SERVICE_ENDPOINT_METADATA
targetos: Windows
req.typenames: WS_SERVICE_ENDPOINT_METADATA
req.redist: 
ms.custom: 19H1
---

# WS_SERVICE_ENDPOINT_METADATA structure


## -description


Represents the port element for the endpoint. The port element is 
                generated for the service element as specified by serviceName and 
                serviceNs for <a href="https://docs.microsoft.com/windows/desktop/api/webservices/ne-webservices-ws_service_property_id">WS_SERVICE_PROPERTY_METADATA</a> property 
                on the <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-host">WS_SERVICE_HOST</a>.
            

Note, the port type will only be generated into the WSDL document if the service 
element is generated by the runtime. 
            


## -struct-fields




### -field portName

The name of the port. The service model expects this to be valid for the lifetime 
                    of the <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-host">WS_SERVICE_HOST</a>.
                


### -field bindingName

Name of the binding associated with the port. The service model expects this to be valid for the lifetime 
                    of the <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-host">WS_SERVICE_HOST</a>.
                


### -field bindingNs

The namespace of the binding associated with the port. The service model expects this to be valid for the lifetime 
                    of the <a href="https://docs.microsoft.com/windows/desktop/wsw/ws-service-host">WS_SERVICE_HOST</a>.
                

