---
UID: NS:werapi._WER_REPORT_METADATA_V2
title: WER_REPORT_METADATA_V2 (werapi.h)
description: Contains information about an error report generated by Windows Error Reporting.
old-location: wer\wer_report_metadata_v2.htm
tech.root: wer
ms.assetid: 037170B1-B2DF-402F-A9E6-48C7693C9A93
ms.date: 12/05/2018
ms.keywords: '*PWER_REPORT_METADATA_V2, PWER_REPORT_METADATA_V2, PWER_REPORT_METADATA_V2 structure pointer [Windows Error Reporting], WER_REPORT_METADATA_V2, WER_REPORT_METADATA_V2 structure [Windows Error Reporting], wer.wer_report_metadata_v2, werapi/PWER_REPORT_METADATA_V2, werapi/WER_REPORT_METADATA_V2'
f1_keywords:
- werapi/WER_REPORT_METADATA_V2
dev_langs:
- c++
req.header: werapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10, version 1703 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Werapi.h
api_name:
- WER_REPORT_METADATA_V2
targetos: Windows
req.typenames: WER_REPORT_METADATA_V2, *PWER_REPORT_METADATA_V2
req.redist: 
ms.custom: 19H1
---

# WER_REPORT_METADATA_V2 structure


## -description


Contains information about an error report generated by Windows Error Reporting.


## -struct-fields




### -field Signature

A structure containing the signature of the report. The signature consists of the event name and event parameters present.


### -field BucketId

A hash of the signature. Can be used to cross reference with other crash reports with the same signature (currently not implemented).



### -field ReportId

A locally unique identifier for the report.



### -field CreationTime

A UTC time stamp of when the report was created.



### -field SizeInBytes

The size (on disk) of the individual report and its constituent files. This value only counts files directly contained in a report.


### -field CabId

 


### -field ReportStatus

The detailed status of the report. Use the ReportStatus decoder to track this bit-field.


### -field ReportIntegratorId

The integrator ID of the report.


### -field NumberOfFiles

The number of data files included in the report.


### -field SizeOfFileNames

The total size of the file name fields, in count of <b>WCHAR</b>s, including the terminating character for each name and one more at the end of the record.


### -field FileNames

A pointer to hold the names of the files included in the report. It is in the format: FileName001\0FileName002\0\FileName003\0\0.


#### - CabID

The cab identity value assigned by WER. Use this value to find the corresponding data in COSMOS/WER. Reports that have not uploaded successfully will not have this value.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/werapi/nf-werapi-werstorequeryreportmetadatav2">WerStoreQueryReportMetadataV2</a>
 

 

