---
UID: NS:winbase._FILE_REMOTE_PROTOCOL_INFO
title: FILE_REMOTE_PROTOCOL_INFO (winbase.h)
description: Contains file remote protocol information.
old-location: fs\file_remote_protocol_information.htm
tech.root: FileIO
ms.assetid: ddb555ad-0acb-4538-88ce-a871adfc21fc
ms.date: 12/05/2018
ms.keywords: '*PFILE_REMOTE_PROTOCOL_INFO, FILE_REMOTE_PROTOCOL_INFO, FILE_REMOTE_PROTOCOL_INFO structure [Files], PFILE_REMOTE_PROTOCOL_INFO, PFILE_REMOTE_PROTOCOL_INFO structure pointer [Files], REMOTE_PROTOCOL_FLAG_LOOPBACK, REMOTE_PROTOCOL_FLAG_OFFLINE, REMOTE_PROTOCOL_INFO_FLAG_INTEGRITY, REMOTE_PROTOCOL_INFO_FLAG_MUTUAL_AUTH, REMOTE_PROTOCOL_INFO_FLAG_PERSISTENT_HANDLE, REMOTE_PROTOCOL_INFO_FLAG_PRIVACY, WNNC_NET_10NET, WNNC_NET_3IN1, WNNC_NET_9TILES, WNNC_NET_APPLETALK, WNNC_NET_AS400, WNNC_NET_AVID, WNNC_NET_AVID1, WNNC_NET_BMC, WNNC_NET_BWNFS, WNNC_NET_CLEARCASE, WNNC_NET_COGENT, WNNC_NET_CSC, WNNC_NET_DAV, WNNC_NET_DCE, WNNC_NET_DECORB, WNNC_NET_DFS, WNNC_NET_DISTINCT, WNNC_NET_DOCUSPACE, WNNC_NET_DRIVEONWEB, WNNC_NET_EXIFS, WNNC_NET_EXTENDNET, WNNC_NET_FARALLON, WNNC_NET_FJ_REDIR, WNNC_NET_FOXBAT, WNNC_NET_FRONTIER, WNNC_NET_FTP_NFS, WNNC_NET_GOOGLE, WNNC_NET_HOB_NFS, WNNC_NET_IBMAL, WNNC_NET_INTERGRAPH, WNNC_NET_KNOWARE, WNNC_NET_KWNP, WNNC_NET_LANMAN, WNNC_NET_LANSTEP, WNNC_NET_LANTASTIC, WNNC_NET_LIFENET, WNNC_NET_LOCK, WNNC_NET_LOCUS, WNNC_NET_MANGOSOFT, WNNC_NET_MASFAX, WNNC_NET_MFILES, WNNC_NET_MSNET, WNNC_NET_MS_NFS, WNNC_NET_NDFS, WNNC_NET_NETWARE, WNNC_NET_OBJECT_DIRE, WNNC_NET_OPENAFS, WNNC_NET_PATHWORKS, WNNC_NET_POWERLAN, WNNC_NET_PROTSTOR, WNNC_NET_QUINCY, WNNC_NET_RDR2SAMPLE, WNNC_NET_RIVERFRONT1, WNNC_NET_RIVERFRONT2, WNNC_NET_RSFX, WNNC_NET_SERNET, WNNC_NET_SHIVA, WNNC_NET_SMB, WNNC_NET_SRT, WNNC_NET_STAC, WNNC_NET_SUN_PC_NFS, WNNC_NET_SYMFONET, WNNC_NET_TERMSRV, WNNC_NET_TWINS, WNNC_NET_VINES, WNNC_NET_VMWARE, WNNC_NET_YAHOO, WNNC_NET_ZENWORKS, _FILE_REMOTE_PROTOCOL_INFO, fs.file_remote_protocol_information, winbase/FILE_REMOTE_PROTOCOL_INFO, winbase/PFILE_REMOTE_PROTOCOL_INFO'
f1_keywords:
- winbase/FILE_REMOTE_PROTOCOL_INFO
dev_langs:
- c++
req.header: winbase.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WinBase.h
api_name:
- FILE_REMOTE_PROTOCOL_INFO
targetos: Windows
req.typenames: FILE_REMOTE_PROTOCOL_INFO, *PFILE_REMOTE_PROTOCOL_INFO
req.redist: 
ms.custom: 19H1
---

# FILE_REMOTE_PROTOCOL_INFO structure


## -description


Contains file remote protocol information. This structure is returned from the 
    <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a> function when 
    <b>FileRemoteProtocolInfo</b> is passed in the <i>FileInformationClass</i> 
    parameter.


## -struct-fields




### -field StructureVersion

Version of this structure. This member should be set to 2 if the communication is between 
     computers running Windows 8, Windows Server 2012, or later and 1 otherwise.


### -field StructureSize

Size of this structure. This member should be set to 
     <code>sizeof(FILE_REMOTE_PROTOCOL_INFO)</code>.


### -field Protocol

Remote protocol (<b>WNNC_NET_*</b>) defined in Wnnc.h or 
     Ntifs.h.



#### WNNC_NET_MSNET (0x00010000)



#### WNNC_NET_SMB (0x00020000)



#### WNNC_NET_LANMAN (0x00020000)



#### WNNC_NET_NETWARE (0x00030000)



#### WNNC_NET_VINES (0x00040000)



#### WNNC_NET_10NET (0x00050000)



#### WNNC_NET_LOCUS (0x00060000)



#### WNNC_NET_SUN_PC_NFS (0x00070000)



#### WNNC_NET_LANSTEP (0x00080000)



#### WNNC_NET_9TILES (0x00090000)



#### WNNC_NET_LANTASTIC (0x000A0000)



#### WNNC_NET_AS400 (0x000B0000)



#### WNNC_NET_FTP_NFS (0x000C0000)



#### WNNC_NET_PATHWORKS (0x000D0000)



#### WNNC_NET_LIFENET (0x000E0000)



#### WNNC_NET_POWERLAN (0x000F0000)



#### WNNC_NET_BWNFS (0x00100000)



#### WNNC_NET_COGENT (0x00110000)



#### WNNC_NET_FARALLON (0x00120000)



#### WNNC_NET_APPLETALK (0x00130000)



#### WNNC_NET_INTERGRAPH (0x00140000)



#### WNNC_NET_SYMFONET (0x00150000)



#### WNNC_NET_CLEARCASE (0x00160000)



#### WNNC_NET_FRONTIER (0x00170000)



#### WNNC_NET_BMC (0x00180000)



#### WNNC_NET_DCE (0x00190000)



#### WNNC_NET_AVID (0x001A0000)



#### WNNC_NET_DOCUSPACE (0x001B0000)



#### WNNC_NET_MANGOSOFT (0x001C0000)



#### WNNC_NET_SERNET (0x001D0000)



#### WNNC_NET_RIVERFRONT1 (0x001E0000)



#### WNNC_NET_RIVERFRONT2 (0x001F0000)



#### WNNC_NET_DECORB (0x00200000)



#### WNNC_NET_PROTSTOR (0x00210000)



#### WNNC_NET_FJ_REDIR (0x00220000)



#### WNNC_NET_DISTINCT (0x00230000)



#### WNNC_NET_TWINS (0x00240000)



#### WNNC_NET_RDR2SAMPLE (0x00250000)



#### WNNC_NET_CSC (0x00260000)



#### WNNC_NET_3IN1 (0x00270000)



#### WNNC_NET_EXTENDNET (0x00290000)



#### WNNC_NET_STAC (0x002A0000)



#### WNNC_NET_FOXBAT (0x002B0000)



#### WNNC_NET_YAHOO (0x002C0000)



#### WNNC_NET_EXIFS (0x002D0000)



#### WNNC_NET_DAV (0x002E0000)



#### WNNC_NET_KNOWARE (0x002F0000)



#### WNNC_NET_OBJECT_DIRE (0x00300000)



#### WNNC_NET_MASFAX (0x00310000)



#### WNNC_NET_HOB_NFS (0x00320000)



#### WNNC_NET_SHIVA (0x00330000)



#### WNNC_NET_IBMAL (0x00340000)



#### WNNC_NET_LOCK (0x00350000)



#### WNNC_NET_TERMSRV (0x00360000)



#### WNNC_NET_SRT (0x00370000)



#### WNNC_NET_QUINCY (0x00380000)



#### WNNC_NET_OPENAFS (0x00390000)



#### WNNC_NET_AVID1 (0x003A0000)



#### WNNC_NET_DFS (0x003B0000)



#### WNNC_NET_KWNP (0x003C0000)



#### WNNC_NET_ZENWORKS (0x003D0000)



#### WNNC_NET_DRIVEONWEB (0x003E0000)



#### WNNC_NET_VMWARE (0x003F0000)



#### WNNC_NET_RSFX (0x00400000)



#### WNNC_NET_MFILES (0x00410000)



#### WNNC_NET_MS_NFS (0x00420000)



#### WNNC_NET_GOOGLE (0x00430000)



#### WNNC_NET_NDFS (0x00440000)


### -field ProtocolMajorVersion

Major version of the remote protocol.


### -field ProtocolMinorVersion

Minor version of the remote protocol.


### -field ProtocolRevision

Revision of the remote protocol.


### -field Reserved

Should be set to zero. Do not use this member.


### -field Flags

Remote protocol information. This member can be set to zero or more of the following flags.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="REMOTE_PROTOCOL_FLAG_LOOPBACK"></a><a id="remote_protocol_flag_loopback"></a><dl>
<dt><b>REMOTE_PROTOCOL_FLAG_LOOPBACK</b></dt>
<dt>0x1</dt>
</dl>
</td>
<td width="60%">
The remote protocol is using a loopback.

</td>
</tr>
<tr>
<td width="40%"><a id="REMOTE_PROTOCOL_FLAG_OFFLINE"></a><a id="remote_protocol_flag_offline"></a><dl>
<dt><b>REMOTE_PROTOCOL_FLAG_OFFLINE</b></dt>
<dt>0x2</dt>
</dl>
</td>
<td width="60%">
The remote protocol is using an offline cache.

</td>
</tr>
<tr>
<td width="40%"><a id="REMOTE_PROTOCOL_INFO_FLAG_PERSISTENT_HANDLE"></a><a id="remote_protocol_info_flag_persistent_handle"></a><dl>
<dt><b>REMOTE_PROTOCOL_INFO_FLAG_PERSISTENT_HANDLE</b></dt>
<dt>0x4</dt>
</dl>
</td>
<td width="60%">
The remote protocol is using a persistent handle.

<b>Windows 7 and Windows Server 2008 R2:  </b>This flag is not supported before Windows 8 and Windows Server 2012.

</td>
</tr>
<tr>
<td width="40%"><a id="REMOTE_PROTOCOL_INFO_FLAG_PRIVACY"></a><a id="remote_protocol_info_flag_privacy"></a><dl>
<dt><b>REMOTE_PROTOCOL_INFO_FLAG_PRIVACY</b></dt>
<dt>0x8</dt>
</dl>
</td>
<td width="60%">
The remote protocol is using privacy. This is only supported if the 
        <b>StructureVersion</b> member is 2 or higher.

<b>Windows 7 and Windows Server 2008 R2:  </b>This flag is not supported before Windows 8 and Windows Server 2012.

</td>
</tr>
<tr>
<td width="40%"><a id="REMOTE_PROTOCOL_INFO_FLAG_INTEGRITY"></a><a id="remote_protocol_info_flag_integrity"></a><dl>
<dt><b>REMOTE_PROTOCOL_INFO_FLAG_INTEGRITY</b></dt>
<dt>0x10</dt>
</dl>
</td>
<td width="60%">
The remote protocol is using integrity so the data is signed. This is only supported if the 
        <b>StructureVersion</b> member is 2 or higher.

<b>Windows 7 and Windows Server 2008 R2:  </b>This flag is not supported before Windows 8 and Windows Server 2012.

</td>
</tr>
<tr>
<td width="40%"><a id="REMOTE_PROTOCOL_INFO_FLAG_MUTUAL_AUTH"></a><a id="remote_protocol_info_flag_mutual_auth"></a><dl>
<dt><b>REMOTE_PROTOCOL_INFO_FLAG_MUTUAL_AUTH</b></dt>
<dt>0x20</dt>
</dl>
</td>
<td width="60%">
The remote protocol is using mutual authentication using Kerberos. This is only supported if the 
        <b>StructureVersion</b> member is 2 or higher.

<b>Windows 7 and Windows Server 2008 R2:  </b>This flag is not supported before Windows 8 and Windows Server 2012.

</td>
</tr>
</table>
 


### -field GenericReserved

Protocol-generic information structure.


### -field GenericReserved.Reserved

Should be set to zero. Do not use this member.


### -field ProtocolSpecificReserved

Protocol-specific information structure.


### -field ProtocolSpecificReserved.Reserved

Should be set to zero. Do not use this member.


### -field ProtocolSpecific


### -field ProtocolSpecific.Smb2


### -field ProtocolSpecific.Smb2.Server


### -field ProtocolSpecific.Smb2.Server.Capabilities

 


### -field ProtocolSpecific.Smb2.Share


### -field ProtocolSpecific.Smb2.Share.Capabilities

 


### -field ProtocolSpecific.Smb2.Share.CachingFlags

 


### -field ProtocolSpecific.Reserved

 




## -remarks



The <b>FILE_REMOTE_PROTOCOL_INFO</b> 
    structure is valid only for use with the 
    <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a> function.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/minwinbase/ne-minwinbase-file_info_by_handle_class">FILE_INFO_BY_HANDLE_CLASS</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>
 

 

