---
UID: NF:wincrypt.CertRemoveStoreFromCollection
title: CertRemoveStoreFromCollection function (wincrypt.h)
description: Removes a sibling certificate store from a collection store.
old-location: security\certremovestorefromcollection.htm
tech.root: SecCrypto
ms.assetid: e1564848-8b39-4ea9-9148-142ceaaaed15
ms.date: 12/05/2018
ms.keywords: CertRemoveStoreFromCollection, CertRemoveStoreFromCollection function [Security], _crypto2_certremovestorefromcollection, security.certremovestorefromcollection, wincrypt/CertRemoveStoreFromCollection
f1_keywords:
- wincrypt/CertRemoveStoreFromCollection
dev_langs:
- c++
req.header: wincrypt.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2003 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Crypt32.lib
req.dll: Crypt32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Crypt32.dll
api_name:
- CertRemoveStoreFromCollection
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CertRemoveStoreFromCollection function


## -description


The <b>CertRemoveStoreFromCollection</b> function removes a sibling <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">certificate store</a> from a collection store.


## -parameters




### -param hCollectionStore [in]

A handle of the collection certificate store.


### -param hSiblingStore [in]

Handle of the sibling certificate store to be removed from the collection store.


## -returns



This function does not return a value.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-certaddstoretocollection">CertAddStoreToCollection</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-certopenstore">CertOpenStore</a>



<a href="https://docs.microsoft.com/windows/desktop/SecCrypto/cryptography-functions">Certificate Store Functions</a>
 

 

