---
UID: NF:wincrypt.CryptDuplicateKey
title: CryptDuplicateKey function (wincrypt.h)
description: Makes an exact copy of a key and the state of the key.
old-location: security\cryptduplicatekey.htm
tech.root: SecCrypto
ms.assetid: c5658008-7c92-4877-871a-a764884efd79
ms.date: 12/05/2018
ms.keywords: CryptDuplicateKey, CryptDuplicateKey function [Security], _crypto2_cryptduplicatekey, security.cryptduplicatekey, wincrypt/CryptDuplicateKey
f1_keywords:
- wincrypt/CryptDuplicateKey
dev_langs:
- c++
req.header: wincrypt.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Advapi32.lib
req.dll: Advapi32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Advapi32.dll
- API-MS-Win-Security-cryptoapi-l1-1-0.dll
- cryptsp.dll
api_name:
- CryptDuplicateKey
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CryptDuplicateKey function


## -description


<div class="alert"><b>Important</b>  This API is deprecated. New and existing software should start using <a href="https://docs.microsoft.com/windows/desktop/SecCNG/cng-portal">Cryptography Next Generation APIs.</a> Microsoft may remove this API in future releases.</div><div> </div>The <b>CryptDuplicateKey</b> function makes an exact copy of a key and the <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">state</a> of the key.


## -parameters




### -param hKey [in]

A handle to the key to be duplicated.


### -param pdwReserved [in]

Reserved for future use and must be <b>NULL</b>.


### -param dwFlags [in]

Reserved for future use and must be zero.


### -param phKey [out]

Address of the handle to the duplicated key. When you have finished using the key, release the handle by calling the <a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-cryptdestroykey">CryptDestroyKey</a> function.


## -returns



If the function succeeds, the return value is nonzero (TRUE).

If the function fails, the return value is zero (FALSE). For extended error information, call 
<a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-getlasterror">GetLastError</a>.

The error code prefaced by "NTE" is generated by the particular CSP being used. Some possible error codes are listed in the following table.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_CALL_NOT_IMPLEMENTED</b></dt>
</dl>
</td>
<td width="60%">
Because this is a new function, existing CSPs might not implement it. This error is returned if the CSP does not support this function.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_INVALID_PARAMETER</b></dt>
</dl>
</td>
<td width="60%">
One of the parameters contains a value that is not valid. This is most often a pointer that is not valid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>NTE_BAD_KEY</b></dt>
</dl>
</td>
<td width="60%">
A handle to the original key is not valid.

</td>
</tr>
</table>
 




## -remarks



<b>CryptDuplicateKey</b> makes a copy of a key and the exact <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">state</a> of the key. One scenario when this function can be used is when an application needs to encrypt two separate messages with the same key but with different <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">salt values</a>. The original key is generated and then a duplicate key is made by using the <b>CryptDuplicateKey</b> function. The different salt values are then set on the original and duplicate keys with separate calls to the 
<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-cryptsetkeyparam">CryptSetKeyParam</a> function.


<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-cryptdestroykey">CryptDestroyKey</a> must be called to destroy any keys that are created by using <b>CryptDuplicateKey</b>. Destroying the original key does not cause the duplicate key to be destroyed. After a duplicate key is made, it is separate from the original key. There is no shared state between the two keys.


#### Examples

The following example shows the creation of a session key that is a duplicate of an existing session key. For an example that includes the complete context for this example, see <a href="https://docs.microsoft.com/windows/desktop/SecCrypto/example-c-program-duplicating-a-session-key">Example C Program: Duplicating a Session Key</a>.


```cpp
//--------------------------------------------------------------------
// Declare and initialize variables.

HCRYPTKEY    hDuplicateKey;

// Duplicate the key. hOriginalKey is a previously 
// assigned HCRYPTKEY variable.

if (CryptDuplicateKey(
     hOriginalKey, 
     NULL, 
     0, 
     &hDuplicateKey))
{
   printf("The session key has been duplicated. \n");
}
else
{
   printf("Error using CryptDuplicateKey.\n");
   exit(1);
}

// Insert code that uses the duplicate key here.

// When you have finished using the key, the handle must be released.

if (CryptDestroyKey(hDuplicateKey))
{
  printf("The handle has been released.\n");
}
else
{
  printf("The handle could not be released.\n");
}
```





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-cryptdestroykey">CryptDestroyKey</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-cryptsetkeyparam">CryptSetKeyParam</a>



<a href="https://docs.microsoft.com/windows/desktop/SecCrypto/cryptography-functions">Key Generation and Exchange Functions</a>
 

 

