---
UID: NF:wincrypt.CryptEnumProvidersW
title: CryptEnumProvidersW function (wincrypt.h)
description: Important  This API is deprecated.
old-location: security\cryptenumproviders.htm
tech.root: SecCrypto
ms.assetid: 2d93ef0f-b48f-481b-ba62-c535476fde08
ms.date: 12/05/2018
ms.keywords: CryptEnumProviders, CryptEnumProviders function [Security], CryptEnumProvidersA, CryptEnumProvidersW, _crypto2_cryptenumproviders, security.cryptenumproviders, wincrypt/CryptEnumProviders, wincrypt/CryptEnumProvidersA, wincrypt/CryptEnumProvidersW
f1_keywords:
- wincrypt/CryptEnumProviders
dev_langs:
- c++
req.header: wincrypt.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: CryptEnumProvidersW (Unicode) and CryptEnumProvidersA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Advapi32.lib
req.dll: Advapi32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Advapi32.dll
- API-MS-Win-Security-cryptoapi-l1-1-0.dll
- cryptsp.dll
api_name:
- CryptEnumProviders
- CryptEnumProvidersA
- CryptEnumProvidersW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CryptEnumProvidersW function


## -description


<div class="alert"><b>Important</b>  This API is deprecated. New and existing software should start using <a href="https://docs.microsoft.com/windows/desktop/SecCNG/cng-portal">Cryptography Next Generation APIs.</a> Microsoft may remove this API in future releases.</div><div> </div>The <b>CryptEnumProviders</b> function retrieves the first or next available <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">cryptographic service providers</a> (CSPs). Used in a loop, this function can retrieve in sequence all of the CSPs available on a computer.

Possible CSPs include Microsoft Base Cryptographic Provider version 1.0 and Microsoft Enhanced Cryptographic Provider version 1.0.


## -parameters




### -param dwIndex [in]

Index of the next provider to be enumerated.


### -param pdwReserved [in]

Reserved for future use and must be <b>NULL</b>.


### -param dwFlags [in]

Reserved for future use and must be zero.


### -param pdwProvType [out]

Address of the <b>DWORD</b> value designating the type of the enumerated provider.


### -param szProvName [out]

A pointer to a buffer that receives the data from the enumerated provider. This is a string including the terminating null character.

This parameter can be <b>NULL</b> to set the size of the name for memory allocation purposes. For more information, see 
<a href="https://docs.microsoft.com/windows/desktop/SecCrypto/retrieving-data-of-unknown-length">Retrieving Data of Unknown Length</a>.


### -param pcbProvName [in, out]

A pointer to a <b>DWORD</b> value specifying the size, in bytes, of the buffer pointed to by the <i>pszProvName</i> parameter. When the function returns, the <b>DWORD</b> value contains the number of bytes stored in the buffer.

<div class="alert"><b>Note</b>  When processing the data returned in the buffer, applications must use the actual size of the data returned. The actual size can be slightly smaller than the size of the buffer specified on input. (On input, buffer sizes are usually specified large enough to ensure that the largest possible output data fits in the buffer.) On output, the variable pointed to by this parameter is updated to reflect the actual size of the data copied to the buffer.</div>
<div> </div>

## -returns



If the function succeeds, the return value is nonzero (<b>TRUE</b>).

If the function fails, the return value is zero (<b>FALSE</b>). For extended error information, call 
<a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-getlasterror">GetLastError</a>.

The error codes prefaced by NTE are generated by the particular CSP being used. Some possible error codes follow.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_MORE_DATA</b></dt>
</dl>
</td>
<td width="60%">
The <i>pszProvName</i> buffer was not large enough to hold the provider name.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_NO_MORE_ITEMS</b></dt>
</dl>
</td>
<td width="60%">
There are no more items to enumerate.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_NOT_ENOUGH_MEMORY</b></dt>
</dl>
</td>
<td width="60%">
The operating system ran out of memory.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>NTE_BAD_FLAGS</b></dt>
</dl>
</td>
<td width="60%">
The <i>dwFlags</i> parameter has an unrecognized value.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>NTE_FAIL</b></dt>
</dl>
</td>
<td width="60%">
Something was wrong with the type registration.

</td>
</tr>
</table>
 




## -remarks



This function  enumerates the providers available on a computer. The provider types can be enumerated by using 
<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-cryptenumprovidertypesa">CryptEnumProviderTypes</a>.


#### Examples

The following example shows a loop listing all available cryptographic service providers. For another example that uses the  <b>CryptEnumProviders</b> function, see <a href="https://docs.microsoft.com/windows/desktop/SecCrypto/example-c-program-enumerating-csp-providers-and-provider-types">Example C Program: Enumerating CSP Providers and Provider Types</a>.


```cpp
#include <stdio.h>
#include <windows.h>
#include <Wincrypt.h>
#pragma comment(lib, "advapi32.lib")

void main()
{

    //---------------------------------------------------------------
    // Copyright (C) Microsoft.  All rights reserved.
    // Declare and initialize variables.

    DWORD       cbName;
    DWORD       dwType;
    DWORD       dwIndex;
    CHAR        *pszName = NULL; 

    // Print header lines for providers.
    printf("Listing Available Providers:\n");
    printf("Provider type\tProvider Name\n");
    printf("_____________\t__________________"
        "___________________\n");   

    //--------------------------------------------------------------- 
    // Loop through enumerating providers.
    dwIndex = 0;
    while(CryptEnumProviders(
           dwIndex,
           NULL,
           0,
           &dwType,
           NULL,
           &cbName
           ))
    {

        //-----------------------------------------------------------
        //  cbName returns the length of the name of the next 
        //  provider. Allocate memory in a buffer to retrieve 
        //  that name.

        if (!(pszName = (LPTSTR)LocalAlloc(LMEM_ZEROINIT, cbName)))
        {
           printf("ERROR - LocalAlloc failed\n");
           exit(1);
        }
        //-----------------------------------------------------------
        //  Get the provider name.
        if (CryptEnumProviders(
               dwIndex++,
               NULL,
               0,
               &dwType,
               pszName,
               &cbName
               ))
        {
            printf ("     %4.0d\t%s\n",dwType, pszName);
        }
        else
        {
            printf("ERROR - CryptEnumProviders failed.\n");
            exit(1);
        }
        LocalFree(pszName);

    } // End of while loop

    printf("\nProvider types and provider names "
        "have been listed.\n");
}
```





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-cryptenumprovidertypesa">CryptEnumProviderTypes</a>



<a href="https://docs.microsoft.com/windows/desktop/SecCrypto/cryptography-functions">Service Provider Functions</a>
 

 

