---
UID: NF:wincrypt.CryptEnumProviderTypesA
title: CryptEnumProviderTypesA function (wincrypt.h)
description: Retrieves the first or next types of cryptographic service provider (CSP) supported on the computer.
old-location: security\cryptenumprovidertypes.htm
tech.root: SecCrypto
ms.assetid: 7568c963-4d06-4af0-bd15-240402425046
ms.date: 12/05/2018
ms.keywords: CryptEnumProviderTypes, CryptEnumProviderTypes function [Security], CryptEnumProviderTypesA, CryptEnumProviderTypesW, _crypto2_cryptenumprovidertypes, security.cryptenumprovidertypes, wincrypt/CryptEnumProviderTypes, wincrypt/CryptEnumProviderTypesA, wincrypt/CryptEnumProviderTypesW
f1_keywords:
- wincrypt/CryptEnumProviderTypes
dev_langs:
- c++
req.header: wincrypt.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: CryptEnumProviderTypesW (Unicode) and CryptEnumProviderTypesA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Advapi32.lib
req.dll: Advapi32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Advapi32.dll
- API-MS-Win-Security-cryptoapi-l1-1-0.dll
- cryptsp.dll
api_name:
- CryptEnumProviderTypes
- CryptEnumProviderTypesA
- CryptEnumProviderTypesW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CryptEnumProviderTypesA function


## -description


<div class="alert"><b>Important</b>  This API is deprecated. New and existing software should start using <a href="https://docs.microsoft.com/windows/desktop/SecCNG/cng-portal">Cryptography Next Generation APIs.</a> Microsoft may remove this API in future releases.</div><div> </div>The <b>CryptEnumProviderTypes</b> function retrieves the first or next types of <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">cryptographic service provider</a> (CSP) supported on the computer. Used in a loop, this function retrieves in sequence all of the CSP types available on a computer.

Provider types include PROV_RSA_FULL, PROV_RSA_SCHANNEL, and PROV_DSS.


## -parameters




### -param dwIndex [in]

Index of the next provider type to be enumerated.


### -param pdwReserved [in]

Reserved for future use and must be <b>NULL</b>.


### -param dwFlags [in]

Reserved for future use and must be zero.


### -param pdwProvType [out]

Address of the <b>DWORD</b> value designating the enumerated provider type.


### -param szTypeName [out]

A pointer to a buffer that receives the data from the enumerated provider type. This is a string including the terminating <b>NULL</b> character. Some provider types do not have display names, and in this case no name is returned and the returned value pointed to by <i>pcbTypeName</i> is zero. 




This parameter can be <b>NULL</b> to get the size of the name for memory allocation purposes. For more information, see 
<a href="https://docs.microsoft.com/windows/desktop/SecCrypto/retrieving-data-of-unknown-length">Retrieving Data of Unknown Length</a>.


### -param pcbTypeName [in, out]

A pointer to a <b>DWORD</b> value specifying the size, in bytes, of the buffer pointed to by the <i>pszTypeName</i> parameter. When the function returns, the <b>DWORD</b> value contains the number of bytes stored or to be stored in the buffer. Some provider types do not have display names, and in this case no name is returned and the returned value pointed to by <i>pcbTypeName</i> is zero. 




<div class="alert"><b>Note</b>  When processing the data returned in the buffer, applications must use the actual size of the data returned. The actual size can be slightly smaller than the size of the buffer specified on input. (On input, buffer sizes are usually specified large enough to ensure that the largest possible output data fits in the buffer.) On output, the variable pointed to by this parameter is updated to reflect the actual size of the data copied to the buffer.</div>
<div> </div>

## -returns



If the function succeeds, the return value is nonzero (<b>TRUE</b>).

If the function fails, the return value is zero (<b>FALSE</b>). For extended error information, call 
<a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-getlasterror">GetLastError</a>.

The error codes prefaced by NTE are generated by the particular CSP being used. Some possible error codes follow.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_NO_MORE_ITEMS</b></dt>
</dl>
</td>
<td width="60%">
There are no more items to enumerate.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_NOT_ENOUGH_MEMORY</b></dt>
</dl>
</td>
<td width="60%">
The operating system ran out of memory.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>NTE_BAD_FLAGS</b></dt>
</dl>
</td>
<td width="60%">
The <i>dwFlags</i> parameter has an unrecognized value.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>NTE_FAIL</b></dt>
</dl>
</td>
<td width="60%">
Something was wrong with the type registration.

</td>
</tr>
</table>
 




## -remarks



This function enumerates the provider types available on a computer. Providers for any specific provider type can be enumerated using 
<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-cryptenumprovidersa">CryptEnumProviders</a>.


#### Examples

The following example shows a loop listing all available cryptographic service provider types.


```cpp
#include <stdio.h>
#include <windows.h>
#include <Wincrypt.h>
#pragma comment(lib, "advapi32.lib")

void main()
{
    
    // Copyright (C) Microsoft.  All rights reserved.
    // Declare and initialize variables.

    DWORD       dwIndex;
    DWORD       dwType;
    DWORD       cbName;
    LPTSTR      pszName;

    //--------------------------------------------------------------
    //   Print header lines for provider types.

    printf("Listing Available Provider Types:\n");
    printf("Provider type\tProvider Type Name\n");
    printf("_____________\t_____________________________________\n");

    // Loop through enumerating provider types.
    dwIndex = 0;
    while(CryptEnumProviderTypes(
           dwIndex,
           NULL,
           0,
           &dwType,
           NULL,
           &cbName
           ))
    {

        //-----------------------------------------------------------
        //  cbName returns the length of the name of the next
        //  provider type. Allocate memory in a buffer to retrieve
        //  that name.
        if (!(pszName = (LPTSTR)LocalAlloc(LMEM_ZEROINIT, cbName)))
        {
           printf("ERROR - LocalAlloc failed.\n");
           exit(1);
        }
        //-----------------------------------------------------------
        //  Get the provider type name.

        if (CryptEnumProviderTypes(
               dwIndex++,
               NULL,
               NULL,
               &dwType,   
               pszName,
               &cbName))     
        {
            printf ("     %4.0d\t%s\n",dwType, pszName);
        }
        else
        {
            printf("ERROR - CryptEnumProviderTypes\n");
            exit(1);
        }
        LocalFree(pszName);
    } // End of while loop.
}

```


For another example that uses the <b>CryptEnumProviderTypes</b> function, see <a href="https://docs.microsoft.com/windows/desktop/SecCrypto/example-c-program-enumerating-csp-providers-and-provider-types">Example C Program: Enumerating CSP Providers and Provider Types</a>.

<div class="code"></div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-cryptenumprovidersa">CryptEnumProviders</a>



<a href="https://docs.microsoft.com/windows/desktop/SecCrypto/cryptography-functions">Service Provider Functions</a>
 

 

