---
UID: NS:wincrypt._CRYPT_ALGORITHM_IDENTIFIER
title: CRYPT_ALGORITHM_IDENTIFIER (wincrypt.h)
description: Specifies an algorithm used to encrypt a private key.
old-location: security\crypt_algorithm_identifier.htm
tech.root: SecCrypto
ms.assetid: ef0d3aa6-6b36-426f-a14c-2fdf7543deb9
ms.date: 12/05/2018
ms.keywords: '*PCRYPT_ALGORITHM_IDENTIFIER, CRYPT_ALGORITHM_IDENTIFIER, CRYPT_ALGORITHM_IDENTIFIER structure [Security], PCRYPT_ALGORITHM_IDENTIFIER, PCRYPT_ALGORITHM_IDENTIFIER structure pointer [Security], _crypto2_crypt_algorithm_identifier, security.crypt_algorithm_identifier, szOID_ANSI_x942, szOID_ANSI_x942_DH, szOID_DATA STRUCTURE, szOID_DH_SINGLE_PASS_STDDH_SHA1_KDF, szOID_DH_SINGLE_PASS_STDDH_SHA256_KDF, szOID_DH_SINGLE_PASS_STDDH_SHA384_KDF, szOID_DS, szOID_DSALG, szOID_DSALG_CRPT, szOID_DSALG_HASH, szOID_DSALG_RSA, szOID_DSALG_SIGN, szOID_ECC_CURVE_P256, szOID_ECC_CURVE_P384, szOID_ECC_CURVE_P521, szOID_ECC_PUBLIC_KEY, szOID_ECDSA_SHA1, szOID_ECDSA_SHA256, szOID_ECDSA_SHA384, szOID_ECDSA_SHA512, szOID_ECDSA_SPECIFIED, szOID_INFOSEC, szOID_INFOSEC_SuiteAConfidentiality, szOID_INFOSEC_SuiteAIntegrity, szOID_INFOSEC_SuiteAKMandSig, szOID_INFOSEC_SuiteAKeyManagement, szOID_INFOSEC_SuiteASignature, szOID_INFOSEC_SuiteATokenProtection, szOID_INFOSEC_mosaicConfidentiality, szOID_INFOSEC_mosaicIntegrity, szOID_INFOSEC_mosaicKMandSig, szOID_INFOSEC_mosaicKMandUpdSig, szOID_INFOSEC_mosaicKeyManagement, szOID_INFOSEC_mosaicSignature, szOID_INFOSEC_mosaicTokenProtection, szOID_INFOSEC_mosaicUpdatedInteg, szOID_INFOSEC_mosaicUpdatedSig, szOID_INFOSEC_sdnsConfidentiality, szOID_INFOSEC_sdnsIntegrity, szOID_INFOSEC_sdnsKMandSig, szOID_INFOSEC_sdnsKeyManagement, szOID_INFOSEC_sdnsSignature, szOID_INFOSEC_sdnsTokenProtection, szOID_NIST_AES128_CBC, szOID_NIST_AES128_WRAP, szOID_NIST_AES192_CBC, szOID_NIST_AES192_WRAP, szOID_NIST_AES256_CBC, szOID_NIST_AES256_WRAP, szOID_NIST_sha256, szOID_NIST_sha384, szOID_NIST_sha512, szOID_OIW, szOID_OIWDIR, szOID_OIWDIR_CRPT, szOID_OIWDIR_HASH, szOID_OIWDIR_SIGN, szOID_OIWDIR_md2, szOID_OIWDIR_md2RSA, szOID_OIWSEC, szOID_OIWSEC_desCBC, szOID_OIWSEC_desCFB, szOID_OIWSEC_desECB, szOID_OIWSEC_desEDE, szOID_OIWSEC_desMAC, szOID_OIWSEC_desOFB, szOID_OIWSEC_dhCommMod, szOID_OIWSEC_dsa, szOID_OIWSEC_dsaComm, szOID_OIWSEC_dsaCommSHA, szOID_OIWSEC_dsaCommSHA1, szOID_OIWSEC_dsaSHA1, szOID_OIWSEC_keyHashSeal, szOID_OIWSEC_md2RSASign, szOID_OIWSEC_md4RSA, szOID_OIWSEC_md4RSA2, szOID_OIWSEC_md5RSA, szOID_OIWSEC_md5RSASign, szOID_OIWSEC_mdc2, szOID_OIWSEC_mdc2RSA, szOID_OIWSEC_rsaSign, szOID_OIWSEC_rsaXchg, szOID_OIWSEC_sha, szOID_OIWSEC_sha1, szOID_OIWSEC_sha1RSASign, szOID_OIWSEC_shaDSA, szOID_OIWSEC_shaRSA, szOID_PKCS, szOID_PKCS_1, szOID_PKCS_10, szOID_PKCS_12, szOID_PKCS_2, szOID_PKCS_3, szOID_PKCS_4, szOID_PKCS_5, szOID_PKCS_6, szOID_PKCS_7, szOID_PKCS_8, szOID_PKCS_9, szOID_PKIX_NO_SIGNATURE, szOID_RFC3161_counterSign, szOID_RSA, szOID_RSAES_OAEP, szOID_RSA_DES_EDE3_CBC, szOID_RSA_DH, szOID_RSA_ENCRYPT, szOID_RSA_HASH, szOID_RSA_MD2, szOID_RSA_MD2RSA, szOID_RSA_MD4, szOID_RSA_MD4RSA, szOID_RSA_MD5, szOID_RSA_MD5RSA, szOID_RSA_MGF1, szOID_RSA_PSPECIFIED, szOID_RSA_RC2CBC, szOID_RSA_RC4, szOID_RSA_RC5_CBCPad, szOID_RSA_RSA, szOID_RSA_SETOAEP_RSA, szOID_RSA_SHA1RSA, szOID_RSA_SHA256RSA, szOID_RSA_SHA384RSA, szOID_RSA_SHA512RSA, szOID_RSA_SMIMECapabilities, szOID_RSA_SMIMEalg, szOID_RSA_SMIMEalgCMS3DESwrap, szOID_RSA_SMIMEalgCMSRC2wrap, szOID_RSA_SMIMEalgESDH, szOID_RSA_SSA_PSS, szOID_RSA_certExtensions, szOID_RSA_challengePwd, szOID_RSA_contentType, szOID_RSA_counterSign, szOID_RSA_data, szOID_RSA_digestedData, szOID_RSA_emailAddr, szOID_RSA_encryptedData, szOID_RSA_envelopedData, szOID_RSA_extCertAttrs, szOID_RSA_hashedData, szOID_RSA_messageDigest, szOID_RSA_preferSignedData, szOID_RSA_signEnvData, szOID_RSA_signedData, szOID_RSA_signingTime, szOID_RSA_unstructAddr, szOID_RSA_unstructName, szOID_TIMESTAMP_TOKEN, szOID_X957, szOID_X957_DSA, szOID_X957_SHA1DSA, wincrypt/CRYPT_ALGORITHM_IDENTIFIER, wincrypt/PCRYPT_ALGORITHM_IDENTIFIER'
f1_keywords:
- wincrypt/CRYPT_ALGORITHM_IDENTIFIER
dev_langs:
- c++
req.header: wincrypt.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wincrypt.h
api_name:
- CRYPT_ALGORITHM_IDENTIFIER
targetos: Windows
req.typenames: CRYPT_ALGORITHM_IDENTIFIER, *PCRYPT_ALGORITHM_IDENTIFIER
req.redist: 
ms.custom: 19H1
---

# CRYPT_ALGORITHM_IDENTIFIER structure


## -description


The <b>CRYPT_ALGORITHM_IDENTIFIER</b> structure specifies an algorithm used to encrypt a <a href="https://docs.microsoft.com/windows/desktop/SecGloss/p-gly">private key</a>. The structure includes the <a href="https://docs.microsoft.com/windows/desktop/SecGloss/o-gly">object identifier</a> (OID) of the algorithm and any needed parameters for that algorithm. The parameters contained in its <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa381414(v=vs.85)">CRYPT_OBJID_BLOB</a> are encoded.


## -struct-fields




### -field pszObjId

An OID of an algorithm. This member can be one of the following values.  This list is only representative. New algorithms are being defined by 



various users.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA"></a><a id="szoid_rsa"></a><a id="SZOID_RSA"></a><dl>
<dt><b>szOID_RSA</b></dt>
<dt>"1.2.840.113549"</dt>
</dl>
</td>
<td width="60%">
Root object identifier for the RSA asymmetric encryption algorithm family. RSA stands for Ron Rivest, Adi Shamir and Leonard Adleman, the mathematicians who invented the algorithm. This is a popular asymmetric algorithm that can be used for encryption or signing.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS"></a><a id="szoid_pkcs"></a><a id="SZOID_PKCS"></a><dl>
<dt><b>szOID_PKCS</b></dt>
<dt>"1.2.840.113549.1"</dt>
</dl>
</td>
<td width="60%">
Root object identifier for the PKCS (Public Key Cryptography Standards) group of standards that define public key or asymmetric cryptography.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_HASH"></a><a id="szoid_rsa_hash"></a><a id="SZOID_RSA_HASH"></a><dl>
<dt><b>szOID_RSA_HASH</b></dt>
<dt>"1.2.840.113549.2"</dt>
</dl>
</td>
<td width="60%">
RSA signing (encryption) algorithm that uses a hashing algorithm to hash the content before signing it.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_ENCRYPT"></a><a id="szoid_rsa_encrypt"></a><a id="SZOID_RSA_ENCRYPT"></a><dl>
<dt><b>szOID_RSA_ENCRYPT</b></dt>
<dt>"1.2.840.113549.3"</dt>
</dl>
</td>
<td width="60%">
RSA encryption algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_1"></a><a id="szoid_pkcs_1"></a><a id="SZOID_PKCS_1"></a><dl>
<dt><b>szOID_PKCS_1</b></dt>
<dt>"1.2.840.113549.1.1"</dt>
</dl>
</td>
<td width="60%">
PKCS#1 is the first Public Key Cryptography Standard (PKCS) published by  RSA Laboratories. The PKCS#1 standard defines the properties of encryption and decryption employed by the RSA algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_2"></a><a id="szoid_pkcs_2"></a><a id="SZOID_PKCS_2"></a><dl>
<dt><b>szOID_PKCS_2</b></dt>
<dt>"1.2.840.113549.1.2"</dt>
</dl>
</td>
<td width="60%">
PKCS#2 was a Public Key Cryptography Standard (PKCS) that dealt with RSA encryption of message digests. It has been merged into PKCS#1.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_3"></a><a id="szoid_pkcs_3"></a><a id="SZOID_PKCS_3"></a><dl>
<dt><b>szOID_PKCS_3</b></dt>
<dt>"1.2.840.113549.1.3"</dt>
</dl>
</td>
<td width="60%">
PKCS#3 is a Public Key Cryptography Standard (PKCS)  that defines the Diffie-Hellman key agreement protocol.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_4"></a><a id="szoid_pkcs_4"></a><a id="SZOID_PKCS_4"></a><dl>
<dt><b>szOID_PKCS_4</b></dt>
<dt>"1.2.840.113549.1.4"</dt>
</dl>
</td>
<td width="60%">
PKCS#4 was a Public Key Cryptography Standard (PKCS) that defined the RSA key syntax. It has been merged into PKCS#1.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_5"></a><a id="szoid_pkcs_5"></a><a id="SZOID_PKCS_5"></a><dl>
<dt><b>szOID_PKCS_5</b></dt>
<dt>"1.2.840.113549.1.5"</dt>
</dl>
</td>
<td width="60%">
PKCS#5 is a Public Key Cryptography Standard (PKCS)  that provides recommendations for the implementation of
   password-based cryptography. It  covers key derivation functions,
   encryption schemes, message-authentication schemes, and ASN.1 syntax
   structure.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_6"></a><a id="szoid_pkcs_6"></a><a id="SZOID_PKCS_6"></a><dl>
<dt><b>szOID_PKCS_6</b></dt>
<dt>"1.2.840.113549.1.6"</dt>
</dl>
</td>
<td width="60%">
PKCS#6 is a Public Key Cryptography Standard (PKCS)  that describes the syntax for extended certificate information, a set of attributes that provides additional information about the
entity whose public key is certified in the X.509
certificate.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_7"></a><a id="szoid_pkcs_7"></a><a id="SZOID_PKCS_7"></a><dl>
<dt><b>szOID_PKCS_7</b></dt>
<dt>"1.2.840.113549.1.7"</dt>
</dl>
</td>
<td width="60%">
PKCS#7 is a Public Key Cryptography Standard (PKCS)  that describes the general types of content to which cryptography can be applied. This includes data, signed data,
enveloped data, signed-and-enveloped data, digested data,
and encrypted data.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_8"></a><a id="szoid_pkcs_8"></a><a id="SZOID_PKCS_8"></a><dl>
<dt><b>szOID_PKCS_8</b></dt>
<dt>"1.2.840.113549.1.8"</dt>
</dl>
</td>
<td width="60%">
PKCS#8 is a Public Key Cryptography Standard (PKCS) that defines the syntax for private key information in the <b>PrivateKeyInfo</b> ASN.1 type.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_9"></a><a id="szoid_pkcs_9"></a><a id="SZOID_PKCS_9"></a><dl>
<dt><b>szOID_PKCS_9</b></dt>
<dt>"1.2.840.113549.1.9"</dt>
</dl>
</td>
<td width="60%">
PKCS#8 is a Public Key Cryptography Standard (PKCS) that defines attribute types for use in
PKCS#6 extended certificates, PKCS#7 digitally signed
messages, PKCS#8 private-key information, and PKCS#10
certificate-signing requests.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_10"></a><a id="szoid_pkcs_10"></a><a id="SZOID_PKCS_10"></a><dl>
<dt><b>szOID_PKCS_10</b></dt>
<dt>"1.2.840.113549.1.10"</dt>
</dl>
</td>
<td width="60%">
PKCS#10 is a Public Key Cryptography Standard (PKCS) that describes the certificate request syntax.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKCS_12"></a><a id="szoid_pkcs_12"></a><a id="SZOID_PKCS_12"></a><dl>
<dt><b>szOID_PKCS_12</b></dt>
<dt>"1.2.840.113549.1.12"</dt>
</dl>
</td>
<td width="60%">
PKCS#12 is a Public Key Cryptography Standard (PKCS) that describes the personal information exchange (PFX) format used to transfer personal identity information such as private keys and certificates.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_MD2"></a><a id="szoid_rsa_md2"></a><a id="SZOID_RSA_MD2"></a><dl>
<dt><b>szOID_RSA_MD2</b></dt>
<dt>"1.2.840.113549.2.2"</dt>
</dl>
</td>
<td width="60%">
RSA algorithm coupled with an MD2 message digest algorithm that hashes the message contents before signing.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_MD4"></a><a id="szoid_rsa_md4"></a><a id="SZOID_RSA_MD4"></a><dl>
<dt><b>szOID_RSA_MD4</b></dt>
<dt>"1.2.840.113549.2.4"</dt>
</dl>
</td>
<td width="60%">
RSA algorithm coupled with an MD4 message digest algorithm that hashes the message contents before signing.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_MD5"></a><a id="szoid_rsa_md5"></a><a id="SZOID_RSA_MD5"></a><dl>
<dt><b>szOID_RSA_MD5</b></dt>
<dt>"1.2.840.113549.2.5"</dt>
</dl>
</td>
<td width="60%">
RSA algorithm coupled with an MD5 message digest algorithm that hashes the message contents before signing.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_RSA"></a><a id="szoid_rsa_rsa"></a><a id="SZOID_RSA_RSA"></a><dl>
<dt><b>szOID_RSA_RSA</b></dt>
<dt>"1.2.840.113549.1.1.1"</dt>
</dl>
</td>
<td width="60%">
RSA is used to both encrypt and sign content.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_MD2RSA"></a><a id="szoid_rsa_md2rsa"></a><a id="SZOID_RSA_MD2RSA"></a><dl>
<dt><b>szOID_RSA_MD2RSA</b></dt>
<dt>"1.2.840.113549.1.1.2"</dt>
</dl>
</td>
<td width="60%">
RSA is used to encrypt the content and to sign the content hash created by using the MD2 message digest algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_MD4RSA"></a><a id="szoid_rsa_md4rsa"></a><a id="SZOID_RSA_MD4RSA"></a><dl>
<dt><b>szOID_RSA_MD4RSA</b></dt>
<dt>"1.2.840.113549.1.1.3"</dt>
</dl>
</td>
<td width="60%">
RSA is used to encrypt the content and to sign the content hash created by using the MD4 message digest algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_MD5RSA"></a><a id="szoid_rsa_md5rsa"></a><a id="SZOID_RSA_MD5RSA"></a><dl>
<dt><b>szOID_RSA_MD5RSA</b></dt>
<dt>"1.2.840.113549.1.1.4"</dt>
</dl>
</td>
<td width="60%">
RSA is used to encrypt the content and to sign the content hash created by using the MD5 message digest algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SHA1RSA"></a><a id="szoid_rsa_sha1rsa"></a><a id="SZOID_RSA_SHA1RSA"></a><dl>
<dt><b>szOID_RSA_SHA1RSA</b></dt>
<dt>"1.2.840.113549.1.1.5"</dt>
</dl>
</td>
<td width="60%">
RSA is used to encrypt the content and to sign the content hash created by using the Secure Hashing Algorithm (SHA) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SETOAEP_RSA"></a><a id="szoid_rsa_setoaep_rsa"></a><a id="SZOID_RSA_SETOAEP_RSA"></a><dl>
<dt><b>szOID_RSA_SETOAEP_RSA</b></dt>
<dt>"1.2.840.113549.1.1.6"</dt>
</dl>
</td>
<td width="60%">
RSA that uses Optimal Asymmetric Encryption Padding (OAEP) encoding.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSAES_OAEP"></a><a id="szoid_rsaes_oaep"></a><a id="SZOID_RSAES_OAEP"></a><dl>
<dt><b>szOID_RSAES_OAEP</b></dt>
<dt>"1.2.840.113549.1.1.7"</dt>
</dl>
</td>
<td width="60%">
Public-key encryption scheme combining Optimal Asymmetric Encryption Padding (OAEP) with the RSAEP encryption primitive. RSAES-OAEP takes a plaintext as input, transforms it into an encoded message by using OAEP and applies RSAEP to the result using the RSA public key.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_MGF1"></a><a id="szoid_rsa_mgf1"></a><a id="SZOID_RSA_MGF1"></a><dl>
<dt><b>szOID_RSA_MGF1</b></dt>
<dt>"1.2.840.113549.1.1.8"</dt>
</dl>
</td>
<td width="60%">
RSA algorithm that uses the mask generator function (MGF1)

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_PSPECIFIED"></a><a id="szoid_rsa_pspecified"></a><a id="SZOID_RSA_PSPECIFIED"></a><dl>
<dt><b>szOID_RSA_PSPECIFIED</b></dt>
<dt>"1.2.840.113549.1.1.9"</dt>
</dl>
</td>
<td width="60%">
RSA algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SSA_PSS"></a><a id="szoid_rsa_ssa_pss"></a><a id="SZOID_RSA_SSA_PSS"></a><dl>
<dt><b>szOID_RSA_SSA_PSS</b></dt>
<dt>"1.2.840.113549.1.1.10"</dt>
</dl>
</td>
<td width="60%">
RSA algorithm that uses the probabilistic signature scheme (PSS).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SHA256RSA"></a><a id="szoid_rsa_sha256rsa"></a><a id="SZOID_RSA_SHA256RSA"></a><dl>
<dt><b>szOID_RSA_SHA256RSA</b></dt>
<dt>1.2.840.113549.1.1.11</dt>
</dl>
</td>
<td width="60%">
RSA is used to encrypt the content and to sign the hash created by using the Secure Hashing Algorithm 256 (SHA256) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SHA384RSA"></a><a id="szoid_rsa_sha384rsa"></a><a id="SZOID_RSA_SHA384RSA"></a><dl>
<dt><b>szOID_RSA_SHA384RSA</b></dt>
<dt>1.2.840.113549.1.1.12</dt>
</dl>
</td>
<td width="60%">
RSA is used to encrypt the content and to sign the hash created by using the Secure Hashing Algorithm 384 (SHA384) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="_szOID_RSA_SHA512RSA"></a><a id="_szoid_rsa_sha512rsa"></a><a id="_SZOID_RSA_SHA512RSA"></a><dl>
<dt><b> szOID_RSA_SHA512RSA</b></dt>
<dt>1.2.840.113549.1.1.13</dt>
</dl>
</td>
<td width="60%">
RSA is used to encrypt the content and to sign the hash created by using the Secure Hashing Algorithm 512 (SHA512) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_DH"></a><a id="szoid_rsa_dh"></a><a id="SZOID_RSA_DH"></a><dl>
<dt><b>szOID_RSA_DH</b></dt>
<dt>"1.2.840.113549.1.3.1"</dt>
</dl>
</td>
<td width="60%">
RSA algorithm combined with the Diffie-Hellman key exchange algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_data"></a><a id="szoid_rsa_data"></a><a id="SZOID_RSA_DATA"></a><dl>
<dt><b>szOID_RSA_data</b></dt>
<dt>"1.2.840.113549.1.7.1"</dt>
</dl>
</td>
<td width="60%">
RSA applied over the PKCS#7 ASN.1 <b>Data</b> type.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_signedData"></a><a id="szoid_rsa_signeddata"></a><a id="SZOID_RSA_SIGNEDDATA"></a><dl>
<dt><b>szOID_RSA_signedData</b></dt>
<dt>"1.2.840.113549.1.7.2"</dt>
</dl>
</td>
<td width="60%">
RSA applied over the PKCS#7 ASN.1 <b>SignedData</b> type.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_envelopedData"></a><a id="szoid_rsa_envelopeddata"></a><a id="SZOID_RSA_ENVELOPEDDATA"></a><dl>
<dt><b>szOID_RSA_envelopedData</b></dt>
<dt>"1.2.840.113549.1.7.3"</dt>
</dl>
</td>
<td width="60%">
RSA applied over the PKCS#7 ASN.1 <b>EnvelopedData</b> type.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_signEnvData"></a><a id="szoid_rsa_signenvdata"></a><a id="SZOID_RSA_SIGNENVDATA"></a><dl>
<dt><b>szOID_RSA_signEnvData</b></dt>
<dt>"1.2.840.113549.1.7.4"</dt>
</dl>
</td>
<td width="60%">
RSA applied over the PKCS#7 ASN.1 <b>SignedAndEnvelopedData</b> type.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_digestedData"></a><a id="szoid_rsa_digesteddata"></a><a id="SZOID_RSA_DIGESTEDDATA"></a><dl>
<dt><b>szOID_RSA_digestedData</b></dt>
<dt>"1.2.840.113549.1.7.5"</dt>
</dl>
</td>
<td width="60%">
RSA applied over the PKCS#7 ASN.1 <b>DigestedData</b> type.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_hashedData"></a><a id="szoid_rsa_hasheddata"></a><a id="SZOID_RSA_HASHEDDATA"></a><dl>
<dt><b>szOID_RSA_hashedData</b></dt>
<dt>"1.2.840.113549.1.7.5"</dt>
</dl>
</td>
<td width="60%">
RSA algorithm applied to hashed data.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_encryptedData"></a><a id="szoid_rsa_encrypteddata"></a><a id="SZOID_RSA_ENCRYPTEDDATA"></a><dl>
<dt><b>szOID_RSA_encryptedData</b></dt>
<dt>"1.2.840.113549.1.7.6"</dt>
</dl>
</td>
<td width="60%">
RSA applied over the PKCS#7 ASN.1 <b>EncryptedData</b> type.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_emailAddr"></a><a id="szoid_rsa_emailaddr"></a><a id="SZOID_RSA_EMAILADDR"></a><dl>
<dt><b>szOID_RSA_emailAddr</b></dt>
<dt>"1.2.840.113549.1.9.1"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the to an ASN.1 email address.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_unstructName"></a><a id="szoid_rsa_unstructname"></a><a id="SZOID_RSA_UNSTRUCTNAME"></a><dl>
<dt><b>szOID_RSA_unstructName</b></dt>
<dt>"1.2.840.113549.1.9.2"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the an ASN.1 unstructured name.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_contentType"></a><a id="szoid_rsa_contenttype"></a><a id="SZOID_RSA_CONTENTTYPE"></a><dl>
<dt><b>szOID_RSA_contentType</b></dt>
<dt>"1.2.840.113549.1.9.3"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the ASN.1 content type value.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_messageDigest"></a><a id="szoid_rsa_messagedigest"></a><a id="SZOID_RSA_MESSAGEDIGEST"></a><dl>
<dt><b>szOID_RSA_messageDigest</b></dt>
<dt>"1.2.840.113549.1.9.4"</dt>
</dl>
</td>
<td width="60%">
RSA applied to a message digest.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_signingTime"></a><a id="szoid_rsa_signingtime"></a><a id="SZOID_RSA_SIGNINGTIME"></a><dl>
<dt><b>szOID_RSA_signingTime</b></dt>
<dt>"1.2.840.113549.1.9.5"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the signing date and time value

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_counterSign"></a><a id="szoid_rsa_countersign"></a><a id="SZOID_RSA_COUNTERSIGN"></a><dl>
<dt><b>szOID_RSA_counterSign</b></dt>
<dt>"1.2.840.113549.1.9.6"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the counter signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_challengePwd"></a><a id="szoid_rsa_challengepwd"></a><a id="SZOID_RSA_CHALLENGEPWD"></a><dl>
<dt><b>szOID_RSA_challengePwd</b></dt>
<dt>"1.2.840.113549.1.9.7"</dt>
</dl>
</td>
<td width="60%">
RSA applied to a challenge password.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_unstructAddr"></a><a id="szoid_rsa_unstructaddr"></a><a id="SZOID_RSA_UNSTRUCTADDR"></a><dl>
<dt><b>szOID_RSA_unstructAddr</b></dt>
<dt>"1.2.840.113549.1.9.8"</dt>
</dl>
</td>
<td width="60%">
RSA applied to an unstructured address. 

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_extCertAttrs"></a><a id="szoid_rsa_extcertattrs"></a><a id="SZOID_RSA_EXTCERTATTRS"></a><dl>
<dt><b>szOID_RSA_extCertAttrs</b></dt>
<dt>"1.2.840.113549.1.9.9"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the certificate attributes.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_certExtensions"></a><a id="szoid_rsa_certextensions"></a><a id="SZOID_RSA_CERTEXTENSIONS"></a><dl>
<dt><b>szOID_RSA_certExtensions</b></dt>
<dt>"1.2.840.113549.1.9.14"</dt>
</dl>
</td>
<td width="60%">
RSA applied to certificate extensions.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SMIMECapabilities"></a><a id="szoid_rsa_smimecapabilities"></a><a id="SZOID_RSA_SMIMECAPABILITIES"></a><dl>
<dt><b>szOID_RSA_SMIMECapabilities</b></dt>
<dt>"1.2.840.113549.1.9.15"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the Multipurpose Internet Mail Extensions (MIME)

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_preferSignedData"></a><a id="szoid_rsa_prefersigneddata"></a><a id="SZOID_RSA_PREFERSIGNEDDATA"></a><dl>
<dt><b>szOID_RSA_preferSignedData</b></dt>
<dt>"1.2.840.113549.1.9.15.1"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the SMIME <b>preferSignedData</b> capability preference.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_TIMESTAMP_TOKEN"></a><a id="szoid_timestamp_token"></a><a id="SZOID_TIMESTAMP_TOKEN"></a><dl>
<dt><b>szOID_TIMESTAMP_TOKEN</b></dt>
<dt>"1.2.840.113549.1.9.16.1.4"</dt>
</dl>
</td>
<td width="60%">
Timestamp object identifier.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RFC3161_counterSign"></a><a id="szoid_rfc3161_countersign"></a><a id="SZOID_RFC3161_COUNTERSIGN"></a><dl>
<dt><b>szOID_RFC3161_counterSign</b></dt>
<dt>"1.2.840.113549.1.9.16.1.4"</dt>
</dl>
</td>
<td width="60%">
Counter signature of a signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SMIMEalg"></a><a id="szoid_rsa_smimealg"></a><a id="SZOID_RSA_SMIMEALG"></a><dl>
<dt><b>szOID_RSA_SMIMEalg</b></dt>
<dt>"1.2.840.113549.1.9.16.3"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the Multipurpose Internet Mail Extensions (MIME) algorithm.  SMIME reports the decryption capabilities of an email recipient to an email sender so that the sender can choose the most secure algorithm supported by both parties.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SMIMEalgESDH"></a><a id="szoid_rsa_smimealgesdh"></a><a id="SZOID_RSA_SMIMEALGESDH"></a><dl>
<dt><b>szOID_RSA_SMIMEalgESDH</b></dt>
<dt>"1.2.840.113549.1.9.16.3.5"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the specified SMIME ESDH  algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SMIMEalgCMS3DESwrap"></a><a id="szoid_rsa_smimealgcms3deswrap"></a><a id="SZOID_RSA_SMIMEALGCMS3DESWRAP"></a><dl>
<dt><b>szOID_RSA_SMIMEalgCMS3DESwrap</b></dt>
<dt>"1.2.840.113549.1.9.16.3.6"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the SMIME algorithm. Triple DES is used for key wrapping.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SMIMEalgCMSRC2wrap"></a><a id="szoid_rsa_smimealgcmsrc2wrap"></a><a id="SZOID_RSA_SMIMEALGCMSRC2WRAP"></a><dl>
<dt><b>szOID_RSA_SMIMEalgCMSRC2wrap</b></dt>
<dt>"1.2.840.113549.1.9.16.3.7"</dt>
</dl>
</td>
<td width="60%">
RSA applied to the SMIME algorithm. RC2 is used for key wrapping.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_RC2CBC"></a><a id="szoid_rsa_rc2cbc"></a><a id="SZOID_RSA_RC2CBC"></a><dl>
<dt><b>szOID_RSA_RC2CBC</b></dt>
<dt>"1.2.840.113549.3.2"</dt>
</dl>
</td>
<td width="60%">
RSA that uses the Rivest Cipher (RC2) block cipher algorithm coupled with a cipher-block chaining mode of operation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_RC4"></a><a id="szoid_rsa_rc4"></a><a id="SZOID_RSA_RC4"></a><dl>
<dt><b>szOID_RSA_RC4</b></dt>
<dt>"1.2.840.113549.3.4"</dt>
</dl>
</td>
<td width="60%">
RSA that uses the Rivest Cipher (RC4) block cipher algorithm coupled with a cipher-block chaining mode of operation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_DES_EDE3_CBC"></a><a id="szoid_rsa_des_ede3_cbc"></a><a id="SZOID_RSA_DES_EDE3_CBC"></a><dl>
<dt><b>szOID_RSA_DES_EDE3_CBC</b></dt>
<dt>"1.2.840.113549.3.7"</dt>
</dl>
</td>
<td width="60%">
RSA that uses the triple Data Encryption Standard (DES) algorithm coupled with a cipher-block chaining mode of operation.   The encryption operation is performed as encrypt-decrypt-encrypt.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_RC5_CBCPad"></a><a id="szoid_rsa_rc5_cbcpad"></a><a id="SZOID_RSA_RC5_CBCPAD"></a><dl>
<dt><b>szOID_RSA_RC5_CBCPad</b></dt>
<dt>"1.2.840.113549.3.9"</dt>
</dl>
</td>
<td width="60%">
RSA that uses the Rivest Cipher (RC5) block cipher algorithm coupled with a cipher-block chaining pad mode of operation

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ANSI_x942"></a><a id="szoid_ansi_x942"></a><a id="SZOID_ANSI_X942"></a><dl>
<dt><b>szOID_ANSI_x942</b></dt>
<dt>"1.2.840.10046"</dt>
</dl>
</td>
<td width="60%">
Root object identifier for the ANSI X942 standard.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ANSI_x942_DH"></a><a id="szoid_ansi_x942_dh"></a><a id="SZOID_ANSI_X942_DH"></a><dl>
<dt><b>szOID_ANSI_x942_DH</b></dt>
<dt>"1.2.840.10046.2.1"</dt>
</dl>
</td>
<td width="60%">
Diffie-Hellman Key Exchange Algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_X957"></a><a id="szoid_x957"></a><a id="SZOID_X957"></a><dl>
<dt><b>szOID_X957</b></dt>
<dt>"1.2.840.10040"</dt>
</dl>
</td>
<td width="60%">
Root object identifier for the X957 standard.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_X957_DSA"></a><a id="szoid_x957_dsa"></a><a id="SZOID_X957_DSA"></a><dl>
<dt><b>szOID_X957_DSA</b></dt>
<dt>"1.2.840.10040.4.1"</dt>
</dl>
</td>
<td width="60%">
Digital Signature Algorithm (DSA).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_X957_SHA1DSA"></a><a id="szoid_x957_sha1dsa"></a><a id="SZOID_X957_SHA1DSA"></a><dl>
<dt><b>szOID_X957_SHA1DSA</b></dt>
<dt>"1.2.840.10040.4.3"</dt>
</dl>
</td>
<td width="60%">
Digital Signature Algorithm (DSA) coupled with the Secure Hashing Algorithm (SHA) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECC_PUBLIC_KEY"></a><a id="szoid_ecc_public_key"></a><a id="SZOID_ECC_PUBLIC_KEY"></a><dl>
<dt><b>szOID_ECC_PUBLIC_KEY</b></dt>
<dt>"1.2.840.10045.2.1"</dt>
</dl>
</td>
<td width="60%">
Elliptic curve public key cryptography.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECC_CURVE_P256"></a><a id="szoid_ecc_curve_p256"></a><a id="SZOID_ECC_CURVE_P256"></a><dl>
<dt><b>szOID_ECC_CURVE_P256</b></dt>
<dt>"1.2.840.10045.3.1.7"</dt>
</dl>
</td>
<td width="60%">
256 bit elliptic curve.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECC_CURVE_P384"></a><a id="szoid_ecc_curve_p384"></a><a id="SZOID_ECC_CURVE_P384"></a><dl>
<dt><b>szOID_ECC_CURVE_P384</b></dt>
<dt>"1.3.132.0.34"</dt>
</dl>
</td>
<td width="60%">
384 bit elliptic curve.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECC_CURVE_P521"></a><a id="szoid_ecc_curve_p521"></a><a id="SZOID_ECC_CURVE_P521"></a><dl>
<dt><b>szOID_ECC_CURVE_P521</b></dt>
<dt>"1.3.132.0.35"</dt>
</dl>
</td>
<td width="60%">
512 bit elliptic curve.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECDSA_SHA1"></a><a id="szoid_ecdsa_sha1"></a><a id="SZOID_ECDSA_SHA1"></a><dl>
<dt><b>szOID_ECDSA_SHA1</b></dt>
<dt>"1.2.840.10045.4.1"</dt>
</dl>
</td>
<td width="60%">
Elliptic curve Digital Signature Algorithm (DSA) coupled with the Secure Hashing Algorithm (SHA) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECDSA_SPECIFIED"></a><a id="szoid_ecdsa_specified"></a><a id="SZOID_ECDSA_SPECIFIED"></a><dl>
<dt><b>szOID_ECDSA_SPECIFIED</b></dt>
<dt>"1.2.840.10045.4.3"</dt>
</dl>
</td>
<td width="60%">
Elliptic curve Digital Signature Algorithm (DSA).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECDSA_SHA256"></a><a id="szoid_ecdsa_sha256"></a><a id="SZOID_ECDSA_SHA256"></a><dl>
<dt><b>szOID_ECDSA_SHA256</b></dt>
<dt>"1.2.840.10045.4.3.2"</dt>
</dl>
</td>
<td width="60%">
Elliptic curve Digital Signature Algorithm (DSA) coupled with the Secure Hashing Algorithm (SHA256) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECDSA_SHA384"></a><a id="szoid_ecdsa_sha384"></a><a id="SZOID_ECDSA_SHA384"></a><dl>
<dt><b>szOID_ECDSA_SHA384</b></dt>
<dt>"1.2.840.10045.4.3.3"</dt>
</dl>
</td>
<td width="60%">
Elliptic curve Digital Signature Algorithm (DSA) coupled with the Secure Hashing Algorithm (SHA384) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECDSA_SHA512"></a><a id="szoid_ecdsa_sha512"></a><a id="SZOID_ECDSA_SHA512"></a><dl>
<dt><b>szOID_ECDSA_SHA512</b></dt>
<dt>"1.2.840.10045.4.3.4"</dt>
</dl>
</td>
<td width="60%">
Elliptic curve Digital Signature Algorithm (DSA) coupled with the Secure Hashing Algorithm (SHA512) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_NIST_AES128_CBC"></a><a id="szoid_nist_aes128_cbc"></a><a id="SZOID_NIST_AES128_CBC"></a><dl>
<dt><b>szOID_NIST_AES128_CBC</b></dt>
<dt>"2.16.840.1.101.3.4.1.2"</dt>
</dl>
</td>
<td width="60%">
128 bit Advanced Encryption Standard (AES) algorithm with cipher-block chaining mode of operation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_NIST_AES192_CBC"></a><a id="szoid_nist_aes192_cbc"></a><a id="SZOID_NIST_AES192_CBC"></a><dl>
<dt><b>szOID_NIST_AES192_CBC</b></dt>
<dt>"2.16.840.1.101.3.4.1.22"</dt>
</dl>
</td>
<td width="60%">
192 bit Advanced Encryption Standard (AES) algorithm with cipher-block chaining mode of operation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_NIST_AES256_CBC"></a><a id="szoid_nist_aes256_cbc"></a><a id="SZOID_NIST_AES256_CBC"></a><dl>
<dt><b>szOID_NIST_AES256_CBC</b></dt>
<dt>"2.16.840.1.101.3.4.1.42"</dt>
</dl>
</td>
<td width="60%">
256 bit Advanced Encryption Standard (AES) algorithm with cipher-block chaining mode of operation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_NIST_AES128_WRAP"></a><a id="szoid_nist_aes128_wrap"></a><a id="SZOID_NIST_AES128_WRAP"></a><dl>
<dt><b>szOID_NIST_AES128_WRAP</b></dt>
<dt>"2.16.840.1.101.3.4.1.5"</dt>
</dl>
</td>
<td width="60%">
128 bit Advanced Encryption Standard (AES) algorithm used for key wrapping.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_NIST_AES192_WRAP"></a><a id="szoid_nist_aes192_wrap"></a><a id="SZOID_NIST_AES192_WRAP"></a><dl>
<dt><b>szOID_NIST_AES192_WRAP</b></dt>
<dt>"2.16.840.1.101.3.4.1.25"</dt>
</dl>
</td>
<td width="60%">
192 bit Advanced Encryption Standard (AES) algorithm used for key wrapping.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_NIST_AES256_WRAP"></a><a id="szoid_nist_aes256_wrap"></a><a id="SZOID_NIST_AES256_WRAP"></a><dl>
<dt><b>szOID_NIST_AES256_WRAP</b></dt>
<dt>"2.16.840.1.101.3.4.1.45"</dt>
</dl>
</td>
<td width="60%">
256 bit Advanced Encryption Standard (AES) algorithm used for key wrapping.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_DATA_STRUCTURE"></a><a id="szoid_data_structure"></a><a id="SZOID_DATA_STRUCTURE"></a><dl>
<dt><b>szOID_DATA STRUCTURE</b></dt>
<dt>"1.2.840.10040.4.3"</dt>
</dl>
</td>
<td width="60%">
Unspecified data structure.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_DH_SINGLE_PASS_STDDH_SHA1_KDF"></a><a id="szoid_dh_single_pass_stddh_sha1_kdf"></a><a id="SZOID_DH_SINGLE_PASS_STDDH_SHA1_KDF"></a><dl>
<dt><b>szOID_DH_SINGLE_PASS_STDDH_SHA1_KDF</b></dt>
<dt>"1.3.133.16.840.63.0.2"</dt>
</dl>
</td>
<td width="60%">
Single pass SHA1 key derivation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_DH_SINGLE_PASS_STDDH_SHA256_KDF"></a><a id="szoid_dh_single_pass_stddh_sha256_kdf"></a><a id="SZOID_DH_SINGLE_PASS_STDDH_SHA256_KDF"></a><dl>
<dt><b>szOID_DH_SINGLE_PASS_STDDH_SHA256_KDF</b></dt>
<dt>"1.3.132.1.11.1"</dt>
</dl>
</td>
<td width="60%">
Single pass SHA256 key derivation.

<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This OID is not supported.
  

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_DH_SINGLE_PASS_STDDH_SHA384_KDF"></a><a id="szoid_dh_single_pass_stddh_sha384_kdf"></a><a id="SZOID_DH_SINGLE_PASS_STDDH_SHA384_KDF"></a><dl>
<dt><b>szOID_DH_SINGLE_PASS_STDDH_SHA384_KDF</b></dt>
<dt>"1.3.132.1.11.2"</dt>
</dl>
</td>
<td width="60%">
Single pass SHA384 key derivation.

<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This OID is not supported.
  

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_DS"></a><a id="szoid_ds"></a><a id="SZOID_DS"></a><dl>
<dt><b>szOID_DS</b></dt>
<dt>"2.5"</dt>
</dl>
</td>
<td width="60%">
Enveloped signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_DSALG"></a><a id="szoid_dsalg"></a><a id="SZOID_DSALG"></a><dl>
<dt><b>szOID_DSALG</b></dt>
<dt>"2.5.8"</dt>
</dl>
</td>
<td width="60%">
Enveloped digital signature algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_DSALG_CRPT"></a><a id="szoid_dsalg_crpt"></a><a id="SZOID_DSALG_CRPT"></a><dl>
<dt><b>szOID_DSALG_CRPT</b></dt>
<dt>"2.5.8.1"</dt>
</dl>
</td>
<td width="60%">
Digital signature algorithm applied to encrypted content.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_DSALG_HASH"></a><a id="szoid_dsalg_hash"></a><a id="SZOID_DSALG_HASH"></a><dl>
<dt><b>szOID_DSALG_HASH</b></dt>
<dt>"2.5.8.2"</dt>
</dl>
</td>
<td width="60%">
Digital signature algorithm applied to hashed content.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_DSALG_SIGN"></a><a id="szoid_dsalg_sign"></a><a id="SZOID_DSALG_SIGN"></a><dl>
<dt><b>szOID_DSALG_SIGN</b></dt>
<dt>"2.5.8.3"</dt>
</dl>
</td>
<td width="60%">
Digital signature algorithm applied to a signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_DSALG_RSA"></a><a id="szoid_dsalg_rsa"></a><a id="SZOID_DSALG_RSA"></a><dl>
<dt><b>szOID_DSALG_RSA</b></dt>
<dt>"2.5.8.1.1"</dt>
</dl>
</td>
<td width="60%">
Enveloped digital signature algorithm applied to RSA encrypted or signed content.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIW"></a><a id="szoid_oiw"></a><a id="SZOID_OIW"></a><dl>
<dt><b>szOID_OIW</b></dt>
<dt>"1.3.14"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) root object identifier.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC"></a><a id="szoid_oiwsec"></a><a id="SZOID_OIWSEC"></a><dl>
<dt><b>szOID_OIWSEC</b></dt>
<dt>"1.3.14.3.2"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security standard root object identifier.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_md4RSA"></a><a id="szoid_oiwsec_md4rsa"></a><a id="SZOID_OIWSEC_MD4RSA"></a><dl>
<dt><b>szOID_OIWSEC_md4RSA</b></dt>
<dt>"1.3.14.3.2.2"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security RSA algorithm applied to  a hash created by using the Message Digest (MD4) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_md5RSA"></a><a id="szoid_oiwsec_md5rsa"></a><a id="SZOID_OIWSEC_MD5RSA"></a><dl>
<dt><b>szOID_OIWSEC_md5RSA</b></dt>
<dt>"1.3.14.3.2.3"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security RSA algorithm applied to a hash created by using the Message Digest (MD5) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_md4RSA2"></a><a id="szoid_oiwsec_md4rsa2"></a><a id="SZOID_OIWSEC_MD4RSA2"></a><dl>
<dt><b>szOID_OIWSEC_md4RSA2</b></dt>
<dt>"1.3.14.3.2.4"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security RSA2 algorithm applied to a hash created by using the Message Digest (MD5) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_desECB"></a><a id="szoid_oiwsec_desecb"></a><a id="SZOID_OIWSEC_DESECB"></a><dl>
<dt><b>szOID_OIWSEC_desECB</b></dt>
<dt>"1.3.14.3.2.6"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Data Encryption Standard (DES) algorithm coupled with a electronic codebook mode of operation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_desCBC"></a><a id="szoid_oiwsec_descbc"></a><a id="SZOID_OIWSEC_DESCBC"></a><dl>
<dt><b>szOID_OIWSEC_desCBC</b></dt>
<dt>"1.3.14.3.2.7"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Data Encryption Standard (DES) algorithm coupled with a cipher-block chaining mode of operation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_desOFB"></a><a id="szoid_oiwsec_desofb"></a><a id="SZOID_OIWSEC_DESOFB"></a><dl>
<dt><b>szOID_OIWSEC_desOFB</b></dt>
<dt>"1.3.14.3.2.8"</dt>
</dl>
</td>
<td width="60%">
Data Encryption Standard (DES) algorithm coupled with a cipher-block chaining mode of operation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_desCFB"></a><a id="szoid_oiwsec_descfb"></a><a id="SZOID_OIWSEC_DESCFB"></a><dl>
<dt><b>szOID_OIWSEC_desCFB</b></dt>
<dt>"1.3.14.3.2.9"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Data Encryption Standard (DES) algorithm coupled with a output feedback mode of operation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_desMAC"></a><a id="szoid_oiwsec_desmac"></a><a id="SZOID_OIWSEC_DESMAC"></a><dl>
<dt><b>szOID_OIWSEC_desMAC</b></dt>
<dt>"1.3.14.3.2.10"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Data Encryption Standard (DES) algorithm coupled with a message authentication code (MAC) that hashes both the pre-image and the key.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_rsaSign"></a><a id="szoid_oiwsec_rsasign"></a><a id="SZOID_OIWSEC_RSASIGN"></a><dl>
<dt><b>szOID_OIWSEC_rsaSign</b></dt>
<dt>"1.3.14.3.2.11"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security RSA signature algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_dsa"></a><a id="szoid_oiwsec_dsa"></a><a id="SZOID_OIWSEC_DSA"></a><dl>
<dt><b>szOID_OIWSEC_dsa</b></dt>
<dt>"1.3.14.3.2.12"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Digital Signature Algorithm (DSA).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_shaDSA"></a><a id="szoid_oiwsec_shadsa"></a><a id="SZOID_OIWSEC_SHADSA"></a><dl>
<dt><b>szOID_OIWSEC_shaDSA</b></dt>
<dt>"1.3.14.3.2.13"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Digital Signature Algorithm (DSA) that uses the Secure Hashing Algorithm (SHA) to hash the message contents.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_mdc2RSA"></a><a id="szoid_oiwsec_mdc2rsa"></a><a id="SZOID_OIWSEC_MDC2RSA"></a><dl>
<dt><b>szOID_OIWSEC_mdc2RSA</b></dt>
<dt>"1.3.14.3.2.14"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security RSA algorithm that uses the Modification Detection Code 2 (MDC2) or Meyer-Schilling hash function.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_shaRSA"></a><a id="szoid_oiwsec_sharsa"></a><a id="SZOID_OIWSEC_SHARSA"></a><dl>
<dt><b>szOID_OIWSEC_shaRSA</b></dt>
<dt>"1.3.14.3.2.15"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security RSA algorithm coupled with the Secure Hashing Algorithm (SHA).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_dhCommMod"></a><a id="szoid_oiwsec_dhcommmod"></a><a id="SZOID_OIWSEC_DHCOMMMOD"></a><dl>
<dt><b>szOID_OIWSEC_dhCommMod</b></dt>
<dt>"1.3.14.3.2.16"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Diffie-Hellman key exchange algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_desEDE"></a><a id="szoid_oiwsec_desede"></a><a id="SZOID_OIWSEC_DESEDE"></a><dl>
<dt><b>szOID_OIWSEC_desEDE</b></dt>
<dt>"1.3.14.3.2.17"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Data Encryption Standard (DES) algorithm coupled with the encrypt-decrypt-encrypt (EDE) multiple encryption mode of operation.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_sha"></a><a id="szoid_oiwsec_sha"></a><a id="SZOID_OIWSEC_SHA"></a><dl>
<dt><b>szOID_OIWSEC_sha</b></dt>
<dt>"1.3.14.3.2.18"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Secure Hashing Algorithm (SHA).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_mdc2"></a><a id="szoid_oiwsec_mdc2"></a><a id="SZOID_OIWSEC_MDC2"></a><dl>
<dt><b>szOID_OIWSEC_mdc2</b></dt>
<dt>"1.3.14.3.2.19"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Modification Detection Code 2 (MDC2) or Meyer-Schilling hash function.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_dsaComm"></a><a id="szoid_oiwsec_dsacomm"></a><a id="SZOID_OIWSEC_DSACOMM"></a><dl>
<dt><b>szOID_OIWSEC_dsaComm</b></dt>
<dt>"1.3.14.3.2.20"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Digital Signature Algorithm (DSA).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_dsaCommSHA"></a><a id="szoid_oiwsec_dsacommsha"></a><a id="SZOID_OIWSEC_DSACOMMSHA"></a><dl>
<dt><b>szOID_OIWSEC_dsaCommSHA</b></dt>
<dt>"1.3.14.3.2.21"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Digital Signature Algorithm (DSA) coupled with the Secure Hashing Algorithm (SHA).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_rsaXchg"></a><a id="szoid_oiwsec_rsaxchg"></a><a id="SZOID_OIWSEC_RSAXCHG"></a><dl>
<dt><b>szOID_OIWSEC_rsaXchg</b></dt>
<dt>"1.3.14.3.2.22"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security RSA algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_keyHashSeal"></a><a id="szoid_oiwsec_keyhashseal"></a><a id="SZOID_OIWSEC_KEYHASHSEAL"></a><dl>
<dt><b>szOID_OIWSEC_keyHashSeal</b></dt>
<dt>"1.3.14.3.2.23"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security hashing algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_md2RSASign"></a><a id="szoid_oiwsec_md2rsasign"></a><a id="SZOID_OIWSEC_MD2RSASIGN"></a><dl>
<dt><b>szOID_OIWSEC_md2RSASign</b></dt>
<dt>"1.3.14.3.2.24"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security RSA algorithm coupled with the Message Digest (MD2) hashing algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_md5RSASign"></a><a id="szoid_oiwsec_md5rsasign"></a><a id="SZOID_OIWSEC_MD5RSASIGN"></a><dl>
<dt><b>szOID_OIWSEC_md5RSASign</b></dt>
<dt>"1.3.14.3.2.25"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security RSA algorithm coupled with the Message Digest (MD5) hashing algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_sha1"></a><a id="szoid_oiwsec_sha1"></a><a id="SZOID_OIWSEC_SHA1"></a><dl>
<dt><b>szOID_OIWSEC_sha1</b></dt>
<dt>"1.3.14.3.2.26"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Secure Hashing (SHA1) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_dsaSHA1"></a><a id="szoid_oiwsec_dsasha1"></a><a id="SZOID_OIWSEC_DSASHA1"></a><dl>
<dt><b>szOID_OIWSEC_dsaSHA1</b></dt>
<dt>"1.3.14.3.2.27"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Digital Signature Algorithm (DSA) that uses the Secure Hashing Algorithm 1 (SHA1).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_dsaCommSHA1"></a><a id="szoid_oiwsec_dsacommsha1"></a><a id="SZOID_OIWSEC_DSACOMMSHA1"></a><dl>
<dt><b>szOID_OIWSEC_dsaCommSHA1</b></dt>
<dt>"1.3.14.3.2.28"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security Digital Signature Algorithm (DSA) that uses the Secure Hashing Algorithm 1 (SHA1).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_sha1RSASign"></a><a id="szoid_oiwsec_sha1rsasign"></a><a id="SZOID_OIWSEC_SHA1RSASIGN"></a><dl>
<dt><b>szOID_OIWSEC_sha1RSASign</b></dt>
<dt>"1.3.14.3.2.29"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Security RSA algorithm that uses the Secure Hashing Algorithm 1 (SHA1).

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWDIR"></a><a id="szoid_oiwdir"></a><a id="SZOID_OIWDIR"></a><dl>
<dt><b>szOID_OIWDIR</b></dt>
<dt>"1.3.14.7.2"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Directory root object identifier.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWDIR_CRPT"></a><a id="szoid_oiwdir_crpt"></a><a id="SZOID_OIWDIR_CRPT"></a><dl>
<dt><b>szOID_OIWDIR_CRPT</b></dt>
<dt>"1.3.14.7.2.1"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Directory generic encryption algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWDIR_HASH"></a><a id="szoid_oiwdir_hash"></a><a id="SZOID_OIWDIR_HASH"></a><dl>
<dt><b>szOID_OIWDIR_HASH</b></dt>
<dt>"1.3.14.7.2.2"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Directory generic hashing algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWDIR_SIGN"></a><a id="szoid_oiwdir_sign"></a><a id="SZOID_OIWDIR_SIGN"></a><dl>
<dt><b>szOID_OIWDIR_SIGN</b></dt>
<dt>"1.3.14.7.2.3"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Directory generic signing algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWDIR_md2"></a><a id="szoid_oiwdir_md2"></a><a id="SZOID_OIWDIR_MD2"></a><dl>
<dt><b>szOID_OIWDIR_md2</b></dt>
<dt>"1.3.14.7.2.2.1"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Directory Message digest (MD2) algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWDIR_md2RSA"></a><a id="szoid_oiwdir_md2rsa"></a><a id="SZOID_OIWDIR_MD2RSA"></a><dl>
<dt><b>szOID_OIWDIR_md2RSA</b></dt>
<dt>"1.3.14.7.2.3.1"</dt>
</dl>
</td>
<td width="60%">
NIST OSE Implementors' Workshop (OIW) Directory RSA algorithm coupled with the Message digest (MD2) hashing algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC"></a><a id="szoid_infosec"></a><a id="SZOID_INFOSEC"></a><dl>
<dt><b>szOID_INFOSEC</b></dt>
<dt>"2.16.840.1.101.2.1"</dt>
</dl>
</td>
<td width="60%">
INFOSEC object identifier root.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_sdnsSignature"></a><a id="szoid_infosec_sdnssignature"></a><a id="SZOID_INFOSEC_SDNSSIGNATURE"></a><dl>
<dt><b>szOID_INFOSEC_sdnsSignature</b></dt>
<dt>"2.16.840.1.101.2.1.1.1"</dt>
</dl>
</td>
<td width="60%">
Signature algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_mosaicSignature"></a><a id="szoid_infosec_mosaicsignature"></a><a id="SZOID_INFOSEC_MOSAICSIGNATURE"></a><dl>
<dt><b>szOID_INFOSEC_mosaicSignature</b></dt>
<dt>"2.16.840.1.101.2.1.1.2"</dt>
</dl>
</td>
<td width="60%">
Signature algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_sdnsConfidentiality"></a><a id="szoid_infosec_sdnsconfidentiality"></a><a id="SZOID_INFOSEC_SDNSCONFIDENTIALITY"></a><dl>
<dt><b>szOID_INFOSEC_sdnsConfidentiality</b></dt>
<dt>"2.16.840.1.101.2.1.1.3"</dt>
</dl>
</td>
<td width="60%">
Encryption algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_mosaicConfidentiality"></a><a id="szoid_infosec_mosaicconfidentiality"></a><a id="SZOID_INFOSEC_MOSAICCONFIDENTIALITY"></a><dl>
<dt><b>szOID_INFOSEC_mosaicConfidentiality</b></dt>
<dt>"2.16.840.1.101.2.1.1.4"</dt>
</dl>
</td>
<td width="60%">
Encryption algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_sdnsIntegrity"></a><a id="szoid_infosec_sdnsintegrity"></a><a id="SZOID_INFOSEC_SDNSINTEGRITY"></a><dl>
<dt><b>szOID_INFOSEC_sdnsIntegrity</b></dt>
<dt>"2.16.840.1.101.2.1.1.5"</dt>
</dl>
</td>
<td width="60%">
Signing algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_mosaicIntegrity"></a><a id="szoid_infosec_mosaicintegrity"></a><a id="SZOID_INFOSEC_MOSAICINTEGRITY"></a><dl>
<dt><b>szOID_INFOSEC_mosaicIntegrity</b></dt>
<dt>"2.16.840.1.101.2.1.1.6"</dt>
</dl>
</td>
<td width="60%">
Signing algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_sdnsTokenProtection"></a><a id="szoid_infosec_sdnstokenprotection"></a><a id="SZOID_INFOSEC_SDNSTOKENPROTECTION"></a><dl>
<dt><b>szOID_INFOSEC_sdnsTokenProtection</b></dt>
<dt>"2.16.840.1.101.2.1.1.7"</dt>
</dl>
</td>
<td width="60%">
Secure Data Network System token encryption.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_mosaicTokenProtection"></a><a id="szoid_infosec_mosaictokenprotection"></a><a id="SZOID_INFOSEC_MOSAICTOKENPROTECTION"></a><dl>
<dt><b>szOID_INFOSEC_mosaicTokenProtection</b></dt>
<dt>"2.16.840.1.101.2.1.1.8"</dt>
</dl>
</td>
<td width="60%">
Mosaic token encryption.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_sdnsKeyManagement"></a><a id="szoid_infosec_sdnskeymanagement"></a><a id="SZOID_INFOSEC_SDNSKEYMANAGEMENT"></a><dl>
<dt><b>szOID_INFOSEC_sdnsKeyManagement</b></dt>
<dt>"2.16.840.1.101.2.1.1.9"</dt>
</dl>
</td>
<td width="60%">
Secure Data Network System key management.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_mosaicKeyManagement"></a><a id="szoid_infosec_mosaickeymanagement"></a><a id="SZOID_INFOSEC_MOSAICKEYMANAGEMENT"></a><dl>
<dt><b>szOID_INFOSEC_mosaicKeyManagement</b></dt>
<dt>"2.16.840.1.101.2.1.1.10"</dt>
</dl>
</td>
<td width="60%">
Mosaic key management.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_sdnsKMandSig"></a><a id="szoid_infosec_sdnskmandsig"></a><a id="SZOID_INFOSEC_SDNSKMANDSIG"></a><dl>
<dt><b>szOID_INFOSEC_sdnsKMandSig</b></dt>
<dt>"2.16.840.1.101.2.1.1.11"</dt>
</dl>
</td>
<td width="60%">
Secure Data Network System  key management and signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_mosaicKMandSig"></a><a id="szoid_infosec_mosaickmandsig"></a><a id="SZOID_INFOSEC_MOSAICKMANDSIG"></a><dl>
<dt><b>szOID_INFOSEC_mosaicKMandSig</b></dt>
<dt>"2.16.840.1.101.2.1.1.12"</dt>
</dl>
</td>
<td width="60%">
Mosaic key management and signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_SuiteASignature"></a><a id="szoid_infosec_suiteasignature"></a><a id="SZOID_INFOSEC_SUITEASIGNATURE"></a><dl>
<dt><b>szOID_INFOSEC_SuiteASignature</b></dt>
<dt>"2.16.840.1.101.2.1.1.13"</dt>
</dl>
</td>
<td width="60%">
National Security Agency (NSA) Suite A Cryptography signature algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_SuiteAConfidentiality"></a><a id="szoid_infosec_suiteaconfidentiality"></a><a id="SZOID_INFOSEC_SUITEACONFIDENTIALITY"></a><dl>
<dt><b>szOID_INFOSEC_SuiteAConfidentiality</b></dt>
<dt>"2.16.840.1.101.2.1.1.14"</dt>
</dl>
</td>
<td width="60%">
National Security Agency (NSA) Suite A Cryptography encryption algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_SuiteAIntegrity"></a><a id="szoid_infosec_suiteaintegrity"></a><a id="SZOID_INFOSEC_SUITEAINTEGRITY"></a><dl>
<dt><b>szOID_INFOSEC_SuiteAIntegrity</b></dt>
<dt>"2.16.840.1.101.2.1.1.15"</dt>
</dl>
</td>
<td width="60%">
National Security Agency (NSA) Suite A Cryptography signature algorithm.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_SuiteATokenProtection"></a><a id="szoid_infosec_suiteatokenprotection"></a><a id="SZOID_INFOSEC_SUITEATOKENPROTECTION"></a><dl>
<dt><b>szOID_INFOSEC_SuiteATokenProtection</b></dt>
<dt>"2.16.840.1.101.2.1.1.16"</dt>
</dl>
</td>
<td width="60%">
National Security Agency (NSA) Suite A Cryptography security token encryption.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_SuiteAKeyManagement"></a><a id="szoid_infosec_suiteakeymanagement"></a><a id="SZOID_INFOSEC_SUITEAKEYMANAGEMENT"></a><dl>
<dt><b>szOID_INFOSEC_SuiteAKeyManagement</b></dt>
<dt>"2.16.840.1.101.2.1.1.17"</dt>
</dl>
</td>
<td width="60%">
National Security Agency (NSA) Suite A Cryptography security key management.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_SuiteAKMandSig"></a><a id="szoid_infosec_suiteakmandsig"></a><a id="SZOID_INFOSEC_SUITEAKMANDSIG"></a><dl>
<dt><b>szOID_INFOSEC_SuiteAKMandSig</b></dt>
<dt>"2.16.840.1.101.2.1.1.18"</dt>
</dl>
</td>
<td width="60%">
National Security Agency (NSA) Suite A Cryptography key management and signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_mosaicUpdatedSig"></a><a id="szoid_infosec_mosaicupdatedsig"></a><a id="SZOID_INFOSEC_MOSAICUPDATEDSIG"></a><dl>
<dt><b>szOID_INFOSEC_mosaicUpdatedSig</b></dt>
<dt>"2.16.840.1.101.2.1.1.19"</dt>
</dl>
</td>
<td width="60%">
Mosaic updated signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_mosaicKMandUpdSig"></a><a id="szoid_infosec_mosaickmandupdsig"></a><a id="SZOID_INFOSEC_MOSAICKMANDUPDSIG"></a><dl>
<dt><b>szOID_INFOSEC_mosaicKMandUpdSig</b></dt>
<dt>"2.16.840.1.101.2.1.1.20"</dt>
</dl>
</td>
<td width="60%">
Mosaic key management and updated signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_INFOSEC_mosaicUpdatedInteg"></a><a id="szoid_infosec_mosaicupdatedinteg"></a><a id="SZOID_INFOSEC_MOSAICUPDATEDINTEG"></a><dl>
<dt><b>szOID_INFOSEC_mosaicUpdatedInteg</b></dt>
<dt>"2.16.840.1.101.2.1.1.21"</dt>
</dl>
</td>
<td width="60%">
Mosaic updated signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_NIST_sha256"></a><a id="szoid_nist_sha256"></a><a id="SZOID_NIST_SHA256"></a><dl>
<dt><b>szOID_NIST_sha256</b></dt>
<dt>"2.16.840.1.101.3.4.2.1"</dt>
</dl>
</td>
<td width="60%">
Secure hashing algorithm (SHA) that uses a 256 bit key.

</td>
</tr>
<tr>
<td width="40%"><a id="_szOID_NIST_sha384"></a><a id="_szoid_nist_sha384"></a><a id="_SZOID_NIST_SHA384"></a><dl>
<dt><b> szOID_NIST_sha384</b></dt>
<dt> "2.16.840.1.101.3.4.2.2"</dt>
</dl>
</td>
<td width="60%">
Secure hashing algorithm (SHA) that uses a 384 bit key.

</td>
</tr>
<tr>
<td width="40%"><a id="_szOID_NIST_sha512"></a><a id="_szoid_nist_sha512"></a><a id="_SZOID_NIST_SHA512"></a><dl>
<dt><b> szOID_NIST_sha512</b></dt>
<dt>  "2.16.840.1.101.3.4.2.3"

</dt>
</dl>
</td>
<td width="60%">
Secure hashing algorithm (SHA) that uses a 512 bit key.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_PKIX_NO_SIGNATURE"></a><a id="szoid_pkix_no_signature"></a><a id="SZOID_PKIX_NO_SIGNATURE"></a><dl>
<dt><b>szOID_PKIX_NO_SIGNATURE</b></dt>
<dt>"1.3.6.1.5.5.7.6.2"</dt>
</dl>
</td>
<td width="60%">
No signature.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SSA_PSS"></a><a id="szoid_rsa_ssa_pss"></a><a id="SZOID_RSA_SSA_PSS"></a><dl>
<dt><b>szOID_RSA_SSA_PSS</b></dt>
<dt>"1.2.840.113549.1.1.10"</dt>
</dl>
</td>
<td width="60%">
RSA Signature Scheme with Appendix and Probabilistic Signature Scheme.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECDSA_SPECIFIED"></a><a id="szoid_ecdsa_specified"></a><a id="SZOID_ECDSA_SPECIFIED"></a><dl>
<dt><b>szOID_ECDSA_SPECIFIED</b></dt>
<dt>"1.2.840.10045.4.3"</dt>
</dl>
</td>
<td width="60%">
Elliptic Curve Digital Signature Algorithm (ECDSA).

</td>
</tr>
</table>
 


### -field Parameters

A <a href="https://docs.microsoft.com/windows/desktop/SecGloss/b-gly">BLOB</a>  that provides encoded algorithm-specific parameters. In many cases, there are no parameters. This is indicated by setting the <b>cbData</b> member of the <b>Parameters</b> BLOB to zero. 




The following algorithms have the specified encoded parameters. For more information, see 
<a href="https://docs.microsoft.com/windows/desktop/SecCrypto/constants-for-cryptencodeobject-and-cryptdecodeobject">Constants for CryptEncodeObject and CryptDecodeObject</a>.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_dsa"></a><a id="szoid_oiwsec_dsa"></a><a id="SZOID_OIWSEC_DSA"></a><dl>
<dt><b>szOID_OIWSEC_dsa</b></dt>
</dl>
</td>
<td width="60%">
A <a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-cert_dss_parameters">CERT_DSS_PARAMETERS</a> structure.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_RC2CBC"></a><a id="szoid_rsa_rc2cbc"></a><a id="SZOID_RSA_RC2CBC"></a><dl>
<dt><b>szOID_RSA_RC2CBC</b></dt>
</dl>
</td>
<td width="60%">
A <a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-crypt_rc2_cbc_parameters">CRYPT_RC2_CBC_PARAMETERS</a> structure.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_OIWSEC_desCBC"></a><a id="szoid_oiwsec_descbc"></a><a id="SZOID_OIWSEC_DESCBC"></a><dl>
<dt><b>szOID_OIWSEC_desCBC</b></dt>
</dl>
</td>
<td width="60%">
A <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa381414(v=vs.85)">CRYPT_DATA_BLOB</a> that contains an <a href="https://docs.microsoft.com/windows/desktop/SecGloss/i-gly">initialization vector</a> in the form of an octet string.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_DES_EDE3_CBC"></a><a id="szoid_rsa_des_ede3_cbc"></a><a id="SZOID_RSA_DES_EDE3_CBC"></a><dl>
<dt><b>szOID_RSA_DES_EDE3_CBC</b></dt>
</dl>
</td>
<td width="60%">
A <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa381414(v=vs.85)">CRYPT_DATA_BLOB</a> that contains an <a href="https://docs.microsoft.com/windows/desktop/SecGloss/i-gly">initialization vector</a> in the form of an octet string.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_RC4"></a><a id="szoid_rsa_rc4"></a><a id="SZOID_RSA_RC4"></a><dl>
<dt><b>szOID_RSA_RC4</b></dt>
</dl>
</td>
<td width="60%">
A <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa381414(v=vs.85)">CRYPT_DATA_BLOB</a> that contains an <a href="https://docs.microsoft.com/windows/desktop/SecGloss/i-gly">initialization vector</a> in the form of an octet string.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_RSA_SSA_PSS"></a><a id="szoid_rsa_ssa_pss"></a><a id="SZOID_RSA_SSA_PSS"></a><dl>
<dt><b>szOID_RSA_SSA_PSS</b></dt>
</dl>
</td>
<td width="60%">
A <a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-crypt_rsa_ssa_pss_parameters">CRYPT_RSA_SSA_PSS_PARAMETERS</a> structure.

</td>
</tr>
<tr>
<td width="40%"><a id="szOID_ECDSA_SPECIFIED"></a><a id="szoid_ecdsa_specified"></a><a id="SZOID_ECDSA_SPECIFIED"></a><dl>
<dt><b>szOID_ECDSA_SPECIFIED</b></dt>
</dl>
</td>
<td width="60%">
A <b>CRYPT_ALGORITHM_IDENTIFIER</b> structure.

</td>
</tr>
</table>
 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/SecCrypto/alg-id">ALG_ID</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-cert_info">CERT_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-cert_public_key_info">CERT_PUBLIC_KEY_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-cert_signed_content_info">CERT_SIGNED_CONTENT_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-cmsg_enveloped_encode_info">CMSG_ENVELOPED_ENCODE_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-cmsg_hashed_encode_info">CMSG_HASHED_ENCODE_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-cmsg_signer_encode_info">CMSG_SIGNER_ENCODE_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-cmsg_signer_info">CMSG_SIGNER_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-crl_info">CRL_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-crypt_encrypt_message_para">CRYPT_ENCRYPT_MESSAGE_PARA</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-crypt_hash_message_para">CRYPT_HASH_MESSAGE_PARA</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa381414(v=vs.85)">CRYPT_INTEGER_BLOB</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-crypt_private_key_info">CRYPT_PRIVATE_KEY_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-crypt_sign_message_para">CRYPT_SIGN_MESSAGE_PARA</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-cryptmsggetparam">CryptMsgGetParam</a>
 

 

