---
UID: NS:wincrypt._PUBLICKEYSTRUC
title: PUBLICKEYSTRUC (wincrypt.h)
description: Indicates a key's BLOB type and the algorithm that the key uses.
old-location: security\publickeystruc.htm
tech.root: SecCrypto
ms.assetid: 99d41222-b4ca-40f3-a240-52b0a9b3a9aa
ms.date: 12/05/2018
ms.keywords: BLOBHEADER, BLOBHEADER [Security], BLOBHEADER structure [Security], KEYSTATEBLOB, OPAQUEKEYBLOB, PLAINTEXTKEYBLOB, PRIVATEKEYBLOB, PUBLICKEYBLOB, PUBLICKEYBLOBEX, PUBLICKEYSTRUC, PUBLICKEYSTRUC structure [Security], SIMPLEBLOB, SYMMETRICWRAPKEYBLOB, _cryptcsp_blobheader, _crypto2_publickeystruc, security.blobheader, security.publickeystruc, wincrypt/PUBLICKEYSTRUC
f1_keywords:
- wincrypt/BLOBHEADER
dev_langs:
- c++
req.header: wincrypt.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Wincrypt.h
api_name:
- BLOBHEADER
targetos: Windows
req.typenames: BLOBHEADER, PUBLICKEYSTRUC
req.redist: 
ms.custom: 19H1
---

# PUBLICKEYSTRUC structure


## -description


The <b>PUBLICKEYSTRUC</b> structure, also known as the <b>BLOBHEADER</b> structure, indicates a key's <a href="https://docs.microsoft.com/windows/desktop/SecGloss/b-gly">BLOB</a> type and the algorithm that the key uses. One of these structures is located at the beginning of the <b>pbData</b> member of every <a href="https://docs.microsoft.com/windows/desktop/SecGloss/k-gly">key BLOB</a>.

This structure is not limited to the key BLOBs generated by the PROV_RSA_BASE and PROV_RSA_SIG provider types. The <b>pbData</b> member of any new key BLOB type must begin with this structure.


## -struct-fields




### -field bType

Contains the key BLOB type.


The following are the predefined values for this member. <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">Cryptographic service providers</a> (CSPs) can use other type identifiers as needed.



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="KEYSTATEBLOB"></a><a id="keystateblob"></a><dl>
<dt><b>KEYSTATEBLOB</b></dt>
<dt>0xC</dt>
</dl>
</td>
<td width="60%">
The BLOB is a key state BLOB.

</td>
</tr>
<tr>
<td width="40%"><a id="OPAQUEKEYBLOB"></a><a id="opaquekeyblob"></a><dl>
<dt><b>OPAQUEKEYBLOB</b></dt>
<dt>0x9</dt>
</dl>
</td>
<td width="60%">
The key is a session key.

</td>
</tr>
<tr>
<td width="40%"><a id="PLAINTEXTKEYBLOB"></a><a id="plaintextkeyblob"></a><dl>
<dt><b>PLAINTEXTKEYBLOB</b></dt>
<dt>0x8</dt>
</dl>
</td>
<td width="60%">
The key is a session key.

</td>
</tr>
<tr>
<td width="40%"><a id="PRIVATEKEYBLOB"></a><a id="privatekeyblob"></a><dl>
<dt><b>PRIVATEKEYBLOB</b></dt>
<dt>0x7</dt>
</dl>
</td>
<td width="60%">
The key is a <a href="https://docs.microsoft.com/windows/desktop/SecGloss/p-gly">public/private key pair</a>.

</td>
</tr>
<tr>
<td width="40%"><a id="PUBLICKEYBLOB"></a><a id="publickeyblob"></a><dl>
<dt><b>PUBLICKEYBLOB</b></dt>
<dt>0x6</dt>
</dl>
</td>
<td width="60%">
The key is a public key.

</td>
</tr>
<tr>
<td width="40%"><a id="PUBLICKEYBLOBEX"></a><a id="publickeyblobex"></a><dl>
<dt><b>PUBLICKEYBLOBEX</b></dt>
<dt>0xA</dt>
</dl>
</td>
<td width="60%">
The key is a public key.

</td>
</tr>
<tr>
<td width="40%"><a id="SIMPLEBLOB"></a><a id="simpleblob"></a><dl>
<dt><b>SIMPLEBLOB</b></dt>
<dt>0x1</dt>
</dl>
</td>
<td width="60%">
The key is a session key.

</td>
</tr>
<tr>
<td width="40%"><a id="SYMMETRICWRAPKEYBLOB"></a><a id="symmetricwrapkeyblob"></a><dl>
<dt><b>SYMMETRICWRAPKEYBLOB</b></dt>
<dt>0xB</dt>
</dl>
</td>
<td width="60%">
The key is a symmetric key.

</td>
</tr>
</table>
 


### -field bVersion

Contains the version number of the key BLOB format. For example, if the BLOB is a <a href="https://docs.microsoft.com/windows/desktop/SecGloss/d-gly">Digital Signature Standard</a> (DSS) version 3 key, this member will contain 3. The minimum value for this member is defined by the <b>CUR_BLOB_VERSION</b> (2) identifier.


### -field reserved

This member is reserved for future use and must be set to zero.


### -field aiKeyAlg

Contains one of the <a href="https://docs.microsoft.com/windows/desktop/SecCrypto/alg-id">ALG_ID</a> values that identifies the algorithm of the key contained by the key BLOB.

Not all algorithm identifiers are valid with all BLOB types. For example, since an RC4 key is a session key, it cannot be exported into a PUBLICKEYBLOB.

PLAINTEXTBLOBs can be used with any algorithm or type of key combination supported by the CSP in use. Note that a 3DES key cannot be imported when the Microsoft Base Provider is in use.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa381982(v=vs.85)">DSSPUBKEY</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-dssseed">DSSSEED</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/ns-wincrypt-rsapubkey">RSAPUBKEY</a>
 

 

