---
UID: NF:winddi.DrvQueryFontCaps
title: DrvQueryFontCaps function (winddi.h)
description: The DrvQueryFontCaps function defines the capabilities of the font driver.
old-location: display\drvqueryfontcaps.htm
tech.root: display
ms.assetid: 304ee95a-7e40-40cb-a66c-17397dac0a76
ms.date: 12/05/2018
ms.keywords: DrvQueryFontCaps, DrvQueryFontCaps function [Display Devices], ddifncs_7ae0a56c-3c98-456c-9595-b127f36209a1.xml, display.drvqueryfontcaps, winddi/DrvQueryFontCaps
f1_keywords:
- winddi/DrvQueryFontCaps
dev_langs:
- c++
req.header: winddi.h
req.include-header: Winddi.h
req.target-type: Desktop
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- winddi.h
api_name:
- DrvQueryFontCaps
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DrvQueryFontCaps function


## -description


The <b>DrvQueryFontCaps</b> function defines the capabilities of the font driver.


## -parameters




### -param culCaps

Specifies the number of ULONG values in the array pointed to by the <i>pulCaps</i> parameter that can be written by the font driver.


### -param pulCaps

Pointer to an array that receives the number of values specified in the first parameter. The elements of the array have the following meanings:

<table>
<tr>
<th>Element</th>
<th>Meaning</th>
</tr>
<tr>
<td>
<i>pulCaps</i>[0]

</td>
<td>
A count of the number of ULONG values in the complete array. If <i>culCaps</i> is less than this value, then the caller will receive an incomplete array.

</td>
</tr>
<tr>
<td>
<i>pulCaps</i>[1]

</td>
<td>
A set of flags that can be one or more of the following values:


<dl>
<dt>QC_OUTLINES</dt>
<dt>If this flag is set, the font driver can return an outline description of the glyphs. Moreover, the fonts are assumed to be scalable. Bitmap fonts do not have this flag set.</dt>
</dl>



<dl>
<dt>QC_1BIT</dt>
<dt>Indicates that the font driver is capable of returning monochrome bitmaps of each glyph.</dt>
</dl>



<dl>
<dt>QC_4BIT</dt>
<dt>Indicates that the font driver is capable of returning antialiased 4-bits-per-pixel bitmaps. Each pixel in the bitmap is represented by an unsigned 4-bit value in the range 0 through 15, yielding 16 shades of gray. </dt>
</dl>


</td>
</tr>
</table>
 


## -returns



The return value is the number of ULONG values written to the destination buffer if the function is successful. Otherwise, it is FD_ERROR.




## -remarks



A driver might report that it supports more than one format for a font. For example, a driver could, in principle, return with both QC_1BIT and QC_4BIT set, indicating that it is capable of returning both monochrome and antialiased versions of the font. All bitmaps generated by a font driver must start and end on 32-bit boundaries. If necessary, the end of a bitmap should be "padded" to satisfy this requirement.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-drvqueryfont">DrvQueryFont</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-drvqueryfonttree">DrvQueryFontTree</a>
 

 

