---
UID: NF:winddi.EngGetProcessHandle
title: EngGetProcessHandle function (winddi.h)
description: The EngGetProcessHandle function retrieves a handle to the current client process.
old-location: display\enggetprocesshandle.htm
tech.root: display
ms.assetid: 51e39335-8ad7-4cd9-b46b-6fdd7a4de0bf
ms.date: 12/05/2018
ms.keywords: EngGetProcessHandle, EngGetProcessHandle function [Display Devices], display.enggetprocesshandle, gdifncs_02eadc69-3940-4d10-a9c1-296b12918c87.xml, winddi/EngGetProcessHandle
f1_keywords:
- winddi/EngGetProcessHandle
dev_langs:
- c++
req.header: winddi.h
req.include-header: Winddi.h
req.target-type: Universal
req.target-min-winverclnt: Available in Windows 2000 and later versions of the Windows operating systems.
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Win32k.lib
req.dll: Win32k.sys
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Win32k.sys
api_name:
- EngGetProcessHandle
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# EngGetProcessHandle function


## -description


The <b>EngGetProcessHandle</b> function retrieves a handle to the current client process.


## -parameters






## -returns



In Windows 2000 and later, the <b>EngGetProcessHandle</b> function always returns <b>NULL</b>.  




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-enggetcurrentprocessid">EngGetCurrentProcessId</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-enggetcurrentthreadid">EngGetCurrentThreadId</a>
 

 

