---
UID: NF:winddi.EngSetPointerTag
title: EngSetPointerTag function (winddi.h)
description: The EngSetPointerTag function is obsolete for Windows 2000 and later operating system versions.
old-location: display\engsetpointertag.htm
tech.root: display
ms.assetid: a1a2c74c-c568-4abe-bf84-7e0ace2c44b0
ms.date: 12/05/2018
ms.keywords: EngSetPointerTag, EngSetPointerTag function [Display Devices], display.engsetpointertag, gdifncs_bbe9c510-e5c9-40c3-9c62-460acd564e80.xml, winddi/EngSetPointerTag
f1_keywords:
- winddi/EngSetPointerTag
dev_langs:
- c++
req.header: winddi.h
req.include-header: Winddi.h
req.target-type: Universal
req.target-min-winverclnt: Available in Windows 2000 and later versions of the Windows operating systems.
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Win32k.lib
req.dll: Win32k.sys
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Win32k.sys
api_name:
- EngSetPointerTag
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# EngSetPointerTag function


## -description


The <b>EngSetPointerTag</b> function is <b>obsolete</b> for Windows 2000 and later operating system versions. This function is still supported, but always returns <b>FALSE</b>.

<b>EngSetPointerTag</b> creates a shape that is unioned with the application's pointer shape on <a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-drvsetpointershape">DrvSetPointerShape</a> calls to other associated drivers in a mirrored system.


## -parameters




### -param hdev [in]

Handle to the device. This handle is the GDI handle received by the driver as the <i>hdev</i> parameter for <a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-drvcompletepdev">DrvCompletePDEV</a>.


### -param psoMask [in]

Pointer to a 1bpp <a href="https://docs.microsoft.com/windows/desktop/api/winddi/ns-winddi-surfobj">SURFOBJ</a> structure that describes the monochrome components of the tag. The dimensions of this bitmap determine the size of the tag. There are no implicit constraints on tag sizes, but optimal tag sizes are 32 x 32, 48 x 48, and 64 x 64 pixels. GDI removes the current tag when this value is <b>NULL</b>.


### -param psoColor [in]

Pointer to a SURFOBJ structure in the same color format as the calling driver. This value can be <b>NULL</b> if the tag contains no color components. The color bitmap has the same width as <i>psoInputMask</i> and half the height.


### -param pxlo [in]

Reserved for system use; must be set to <b>NULL</b>.


### -param fl [in]

Reserved for system use; must be set to zero.


## -returns



<b>EngSetPointerTag</b> returns <b>TRUE</b> when it successfully applies the tag. Otherwise, it returns <b>FALSE</b>. For Windows 2000 and later, this function always returns <b>FALSE</b>.




## -remarks



A remote-control driver can call <b>EngSetPointerTag</b> to tag a pointer shape to denote control of the system. Once the remote-control driver sets a tag, GDI will automatically composite it with all pointer shapes generated by the system, until the driver removes or changes the tag.

The driver that calls <b>EngSetPointerShape</b> never gets its own tag applied to its own <a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-drvsetpointershape">DrvSetPointerShape</a> calls by GDI; only other drivers in the mirrored system get the tag applied.

If <i>psoColor</i> is <b>NULL</b>, <i>psoMask</i> points to a monochrome surface that is twice as high as it is wide. The top half contains the monochrome AND mask, and the bottom half contains the monochrome XOR mask.

If <i>psoColor</i> is not <b>NULL</b>, <i>psoMask</i> contains only the monochrome AND mask and <i>psoColor</i> contains the color XOR surface. This color surface must be in the same color format as the driver. GDI joins the shapes by anchoring the upper-left corners of each bitmap.

GDI makes copies of <i>psoMask</i> and <i>psoColor</i>, so the surfaces passed in by the driver can be deleted immediately after calling <b>EngSetPointerTag</b>.

The results of <b>EngSetPointerTag</b> take effect on the next pointer shape call generated by the system.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-drvsetpointershape">DrvSetPointerShape</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-engsetpointershape">EngSetPointerShape</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winddi/ns-winddi-surfobj">SURFOBJ</a>
 

 

