---
UID: NS:winddi._STROBJ
title: STROBJ (winddi.h)
description: The STROBJ class, or text string object, contains an enumeration of glyph handles and positions for the device driver.
old-location: display\strobj.htm
tech.root: display
ms.assetid: efe53cb8-39b9-4931-bac2-9c61efd9d457
ms.date: 12/05/2018
ms.keywords: STROBJ, STROBJ structure [Display Devices], display.strobj, grstrcts_fcaba370-f9bd-40e8-819a-c5277d6d89b6.xml, winddi/STROBJ
f1_keywords:
- winddi/STROBJ
dev_langs:
- c++
req.header: winddi.h
req.include-header: Winddi.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- winddi.h
api_name:
- STROBJ
targetos: Windows
req.typenames: STROBJ
req.redist: 
ms.custom: 19H1
---

# STROBJ structure


## -description


The STROBJ class, or text string object, contains an enumeration of glyph handles and positions for the device driver.


## -struct-fields




### -field cGlyphs

Specifies the number of glyphs in the STROBJ.


### -field flAccel

Accelerator flags. This member can be any of the following values:





#### SO_BREAK_EXTRA

Fixed-width spacing is added to every break character.





#### SO_CHARACTER_EXTRA

Fixed-width spacing is added between each pair of consecutive glyphs. 





#### SO_CHAR_INC_EQUAL_BM_BASE

Spacing is determined by bitmap sizes. In this context, bitmap base is defined as cx for horizontal case, cy for vertical case. This bit is set means that every glyph in a font the bitmap (supplied in GLYPHBITS structure by GDI) will have a base equal to the advance width for that glyph. This does not mean that this is a fixed pitch font. (Not used for PATHOBJs.)





#### SO_DO_NOT_SUBSTITUTE_DEVICE_FONT

A printer driver should not substitute one of its printer fonts for GDI's font choice.





#### SO_DXDY

Glyphs are to be rendered at random positions.





#### SO_ESC_NOT_ORIENT

A glyph's orientation is different from the escapement direction. Escapement is the angle the text direction makes with the horizontal. Orientation is the angle between the glyph's baseline and the escapement direction.





#### SO_FLAG_DEFAULT_PLACEMENT

Default increment vectors are used to position the characters.





#### SO_GLYPHINDEX_TEXTOUT

<b>pwszOrg</b> points to an array of glyph indexes, rather than a Unicode array.





#### SO_HORIZONTAL

Text is horizontal; left-to-right or right-to-left, depending on SO_REVERSED. The y coordinate is only supplied for the first glyph in the string.





#### SO_MAXEXT_EQUAL_BM_SIDE

Bitmaps have the same widths. In this context, bitmap side is defined as cy for horizontal case and cx for vertical case. This flag guarantees that all glyphs in the font will have the same side equal to the sum of ascender and descender. However, this bit indicates more than just a constant side. For horizontal case, this bit also indicates that the vertical distance between the top of the glyph's bitmap and its character origin is equal to the ascender for all glyphs. For vertical case, this bit indicates that the horizontal distance between the glyph's origin and "top" of the glyph's bitmap (which is really right or left, depending on whether you are writing in the direction of positive or negative y axis) is equal to the ascender. In either case, the tops and bottoms of all glyph bitmaps lay on the same line in the direction of writing. (Not used for PATHOBJs.)





#### SO_REVERSED

Set if horizontal is right-to-left or vertical is bottom-to-top.





#### SO_VERTICAL

Text is vertical; top-to-bottom or bottom-to-top, depending on SO_REVERSED. The x coordinate is only supplied for the first glyph in the string.





#### SO_ZERO_BEARINGS

All glyphs have zero A and zero C spacing. This bit guarantees that glyph's black boxes do not overlap.


### -field ulCharInc

Specifies whether the font is a fixed-pitch (monospace) font. If it is, this member is equal to the advance width of glyphs in pels; otherwise, it is zero. When this member is nonzero, GDI supplies a valid coordinate for only the first character in the string. All other character positions must be generated by the driver by successively adding the value of this member along the writing direction.


### -field rclBkGround

Specifies a <a href="https://docs.microsoft.com/windows/desktop/api/windef/ns-windef-rectl">RECTL</a> structure that describes the bounding box for the string.


### -field pgp

Pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/winddi/ns-winddi-glyphpos">GLYPHPOS</a> array for the whole string. Can be <b>NULL</b> (see the following <b>Remarks</b> section).


### -field pwszOrg

Pointer to the original Unicode string or <b>cGlyphs</b> characters. Contrary to its name, this string is not usually null-terminated. Also, this string is not always valid, such as in journalling with printer fonts, in which case this parameter will be <b>NULL</b>.


## -remarks



A driver can call <a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-strobj_venumstart">STROBJ_vEnumStart</a> and <a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-strobj_benum">STROBJ_bEnum</a> to obtain identities and positions of glyphs in the string. If <i>pgp</i> is not <b>NULL</b>, it points to a GLYPHPOS array describing the whole string and only a single call to <b>STROBJ_bEnum</b> is required. If <i>pgp</i> is <b>NULL</b>, <b>STROBJ_bEnum</b> will have to be called repeatedly in a loop to obtain all the string's glyph positions.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-drvgetglyphmode">DrvGetGlyphMode</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winddi/nf-winddi-drvtextout">DrvTextOut</a>
 

 

