---
UID: NS:windef._POINTL
title: POINTL (windef.h)
description: The POINTL structure defines the x- and y-coordinates of a point.
old-location: display\pointl.htm
tech.root: display
ms.assetid: 68cd23d7-7898-4132-abfe-4dda527889b9
ms.date: 12/05/2018
ms.keywords: '*PPOINTL, POINTL, POINTL structure [Display Devices], PPOINTL, PPOINTL structure pointer [Display Devices], display.pointl, grstrcts_bb79820f-05c8-42bf-a7a9-923b6fbc206e.xml, windef/POINTL, windef/PPOINTL'
f1_keywords:
- windef/POINTL
dev_langs:
- c++
req.header: windef.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- windef.h
api_name:
- POINTL
targetos: Windows
req.typenames: POINTL, *PPOINTL
req.redist: 
ms.custom: 19H1
---

# POINTL structure


## -description


The POINTL structure defines the x- and y-coordinates of a point.


## -struct-fields




### -field x

Specifies the <i>x</i>-coordinate of the point. 


### -field y

Specifies the <i>y</i>-coordinate of the point. 


## -remarks



The POINTL structure is identical to the <a href="https://docs.microsoft.com/windows/desktop/api/windef/ns-windef-point">POINT</a> structure.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/windef/ns-windef-point">POINT</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windef/ns-windef-points">POINTS</a>
 

 

