---
UID: NE:windns._DNS_CHARSET
title: DNS_CHARSET (windns.h)
description: The DNS_CHARSET enumeration specifies the character set used.
old-location: dns\dns_charset.htm
tech.root: DNS
ms.assetid: 2674a4e5-c3e2-4a25-bd6f-1fc6b4db3012
ms.date: 12/05/2018
ms.keywords: DNS_CHARSET, DNS_CHARSET enumeration [DNS], DnsCharSetAnsi, DnsCharSetUnicode, DnsCharSetUnknown, DnsCharSetUtf8, dns.dns_charset, windns/DNS_CHARSET, windns/DnsCharSetAnsi, windns/DnsCharSetUnicode, windns/DnsCharSetUnknown, windns/DnsCharSetUtf8
f1_keywords:
- windns/DNS_CHARSET
dev_langs:
- c++
req.header: windns.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Windns.h
api_name:
- DNS_CHARSET
targetos: Windows
req.typenames: DNS_CHARSET
req.redist: 
ms.custom: 19H1
---

# DNS_CHARSET enumeration


## -description


The <b>DNS_CHARSET</b> enumeration specifies the character set used.


## -enum-fields




### -field DnsCharSetUnknown

The character set is unknown.


### -field DnsCharSetUnicode

The character set is Unicode.


### -field DnsCharSetUtf8

The character set is UTF8.


### -field DnsCharSetAnsi

The character set is ANSI.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DNS/dns-enumerations">DNS Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windns/nf-windns-dnsrecordcopyex">DnsRecordCopyEx</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windns/nf-windns-dnsrecordsetcopyex">DnsRecordSetCopyEx</a>
 

 

