---
UID: NS:windows.foundation.Point
title: Point (windows.foundation.h)
description: Represents an ordered pair of floating-point x- and y-coordinates that defines a point in a two-dimensional plane.
old-location: winrt\point.htm
tech.root: WinRT
ms.assetid: 0cdd5b17-2f7e-4e17-896c-7d7784c8643d
ms.date: 12/05/2018
ms.keywords: Point, Point structure [Windows Runtime], windows/Point, winrt.point
f1_keywords:
- windows.foundation/Point
dev_langs:
- c++
req.header: windows.foundation.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Windows.Foundation.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Windows.Foundation.h
api_name:
- Point
targetos: Windows
req.typenames: Point
req.redist: 
ms.custom: 19H1
---

# Point structure


## -description


Represents an ordered pair of floating-point x- and y-coordinates that defines a point in a two-dimensional plane.


## -struct-fields




### -field Point.X

 


### -field Point.Y

 




#### - X

Type: <b>float</b>

The horizontal position of the point. 




#### - Y

Type: <b>float</b>

The vertical position of the point. 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvaluestatics-createpoint">CreatePoint</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvaluestatics-createpointarray">CreatePointArray</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvalue-getpoint">IPropertyValue::GetPoint</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvalue-getpointarray">IPropertyValue::GetPointArray</a>
 

 

