---
UID: NS:windows.foundation.Rect
title: Rect (windows.foundation.h)
description: Contains a set of four floating-point numbers that represent the location and size of a rectangle.
old-location: winrt\rect.htm
tech.root: WinRT
ms.assetid: 420daab1-71e7-4610-b454-a49a64061f97
ms.date: 12/05/2018
ms.keywords: Rect, Rect structure [Windows Runtime], windows/Rect, winrt.rect
f1_keywords:
- windows.foundation/Rect
dev_langs:
- c++
req.header: windows.foundation.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Windows.Foundation.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Windows.Foundation.h
api_name:
- Rect
targetos: Windows
req.typenames: Rect
req.redist: 
ms.custom: 19H1
---

# Rect structure


## -description


Contains a set of four floating-point numbers that represent the location and size of a rectangle.


## -struct-fields




### -field Rect.X

 


### -field Rect.Y

 


### -field Rect.Width

 


### -field Rect.Height

 




#### - Height

Type: <b>float</b>

The height of the rectangle.


#### - Width

Type: <b>float</b>

The width of the rectangle.


#### - X

Type: <b>float</b>

The x-coordinate of the upper-left corner of the rectangle.


#### - Y

Type: <b>float</b>

The y-coordinate of the upper-left corner of the rectangle. 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvaluestatics-createrect">CreateRect</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvaluestatics-createrectarray">CreateRectArray</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvalue-getrect">IPropertyValue::GetRect</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvalue-getrectarray">IPropertyValue::GetRectArray</a>
 

 

