---
UID: NS:windows.foundation.Size
title: Size (windows.foundation.h)
description: Represents an ordered pair of floating-point numbers that specify a height and width.
old-location: winrt\size.htm
tech.root: WinRT
ms.assetid: 8705adcb-a657-4b47-94ba-632bfb3779be
ms.date: 12/05/2018
ms.keywords: Size, Size structure [Windows Runtime], windows/Size, winrt.size
f1_keywords:
- windows.foundation/Size
dev_langs:
- c++
req.header: windows.foundation.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Windows.Foundation.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Windows.Foundation.h
api_name:
- Size
targetos: Windows
req.typenames: Size
req.redist: 
ms.custom: 19H1
---

# Size structure


## -description


Represents an ordered pair of floating-point numbers that specify a height and width.


## -struct-fields




### -field Size.Width

 


### -field Size.Height

 




#### - Height

Type: <b>float</b>

The height.


#### - Width

Type: <b>float</b>

The width.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvaluestatics-createsize">CreateSize</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvaluestatics-createsizearray">CreateSizeArray</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvalue-getsize">IPropertyValue::GetSize</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windows.foundation/nf-windows-foundation-ipropertyvalue-getsizearray">IPropertyValue::GetSizeArray</a>
 

 

