---
UID: NN:windows.media.streaming.IDeviceIcon
title: IDeviceIcon (windows.media.streaming.h)
description: Encapsulates the methods needed to provide information about the icon of a DLNA Device.
old-location: mediastreaming\ideviceicon.htm
tech.root: mediastreaming
ms.assetid: F86C9107-447D-47F7-A711-0687A30EF58E
ms.date: 12/05/2018
ms.keywords: IDeviceIcon, IDeviceIcon interface [Media Streaming API], IDeviceIcon interface [Media Streaming API],described, mediastreaming.ideviceicon, windows/IDeviceIcon
f1_keywords:
- windows.media.streaming/IDeviceIcon
dev_langs:
- c++
req.header: windows.media.streaming.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- windows.media.streaming.h
api_name:
- IDeviceIcon
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IDeviceIcon interface


## -description


Encapsulates the methods needed to provide information about the icon of a DLNA Device.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IDeviceIcon</b> interface inherits from <a href="https://docs.microsoft.com/windows/desktop/api/inspectable/nn-inspectable-iinspectable">IInspectable</a>. <b>IDeviceIcon</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IDeviceIcon</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/mediastreaming/ideviceicon-contenttype">ContentType</a>
</td>
<td align="left" width="63%">
Retrieves the content type of the icon.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/mediastreaming/ideviceicon-height">Height</a>
</td>
<td align="left" width="63%">
Retrieves the height of the icon in pixels.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/mediastreaming/ideviceicon-stream">Stream</a>
</td>
<td align="left" width="63%">
Retrieves the icon as a stream.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/mediastreaming/ideviceicon-width">Width</a>
</td>
<td align="left" width="63%">
Retrieves the width of the icon in pixels.

</td>
</tr>
</table> 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/inspectable/nn-inspectable-iinspectable">IInspectable</a>
 

 

