---
UID: NF:windowsceip.CeipIsOptedIn
title: CeipIsOptedIn function (windowsceip.h)
description: Checks whether the user has opted in for SQM data collection as part of the Customer Experience Improvement Program (CEIP).
old-location: base\ceipisoptedin.htm
tech.root: SysInfo
ms.assetid: 4CDB5B09-B172-4E99-AB46-A08E32346266
ms.date: 12/05/2018
ms.keywords: CeipIsOptedIn, CeipIsOptedIn function, base.ceipisoptedin, windowsceip/ CeipIsOptedIn
f1_keywords:
- windowsceip/CeipIsOptedIn
dev_langs:
- c++
req.header: windowsceip.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8.1 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Kernel32.lib
req.dll: Kernel32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Kernel32.dll
- API-MS-Win-Core-Windowsceip-L1-1-0.dll
- KernelBase.dll
api_name:
- CeipIsOptedIn
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CeipIsOptedIn function


## -description


Checks whether the user has opted in for SQM data collection as part of the Customer Experience Improvement Program (CEIP). 


## -parameters






## -returns



True if SQM data collection is opted in and the machine can send data. Otherwise, false.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DevNotes/ceipenable">CEIPEnable</a>



<a href="http://download.microsoft.com/download/2/C/9/2C9C7B01-A1FC-47B6-9166-2151FB6E007C/Windows and Windows Server compatibility cookbook.docx">Windows and Windows Server Compatibility Cookbook</a>
 

 

