---
UID: NN:windowsstoragecom.IRandomAccessStreamFileAccessMode
title: IRandomAccessStreamFileAccessMode (windowsstoragecom.h)
description: Provides access to the file access mode that was used when the StorageFile.OpenAsync method was called to open the random-access byte stream.
old-location: winrt\irandomaccessstreamfileaccessmode.htm
tech.root: WinRT
ms.assetid: 20A538B5-ACD6-4BD9-9CDC-3F2CCDCAF251
ms.date: 12/05/2018
ms.keywords: IRandomAccessStreamFileAccessMode, IRandomAccessStreamFileAccessMode interface [Windows Runtime], IRandomAccessStreamFileAccessMode interface [Windows Runtime],described, windowsstoragecom/IRandomAccessStreamFileAccessMode, winrt.irandomaccessstreamfileaccessmode
f1_keywords:
- windowsstoragecom/IRandomAccessStreamFileAccessMode
dev_langs:
- c++
req.header: windowsstoragecom.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Windows.storage.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- windows.storage.dll
api_name:
- IRandomAccessStreamFileAccessMode
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IRandomAccessStreamFileAccessMode interface


## -description


Provides access to the file access mode that was used when the <a href="https://docs.microsoft.com/en-us/uwp/api/windows.storage.storagefile.openasync">StorageFile.OpenAsync</a> method was called to open the random-access byte stream.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IRandomAccessStreamFileAccessMode</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IRandomAccessStreamFileAccessMode</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IRandomAccessStreamFileAccessMode</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/windowsstoragecom/nf-windowsstoragecom-irandomaccessstreamfileaccessmode-getmode">GetMode</a>
</td>
<td align="left" width="63%">
Retrieves the file access mode that was used when the <a href="https://docs.microsoft.com/en-us/uwp/api/windows.storage.storagefile.openasync">StorageFile.OpenAsync</a> method was called to open the random-access byte stream.

</td>
</tr>
</table> 


## -see-also




<a href="https://docs.microsoft.com/previous-versions/hh438400(v=vs.85)">IRandomAccessStream</a>



<a href="https://docs.microsoft.com/en-us/uwp/api/windows.storage.storagefile.openasync">StorageFile.OpenAsync</a>
 

 

