---
UID: NF:windowsx.Button_GetState
title: Button_GetState macro (windowsx.h)
description: Retrieves the state of a button or check box. You can use this macro or send the BM_GETSTATE message explicitly.
old-location: controls\Button_GetState.htm
tech.root: Controls
ms.assetid: VS|Controls|~\controls\buttons\buttonreference\buttonmacros\button_getstate.htm
ms.date: 12/05/2018
ms.keywords: Button_GetState, Button_GetState macro [Windows Controls], _win32_Button_GetState, _win32_Button_GetState_cpp, controls.Button_GetState, controls._win32_Button_GetState, windowsx/Button_GetState
f1_keywords:
- windowsx/Button_GetState
dev_langs:
- c++
req.header: windowsx.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Windowsx.h
api_name:
- Button_GetState
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# Button_GetState macro


## -description


Retrieves the state of a button or check box.  You can use this macro or send the <a href="https://docs.microsoft.com/windows/desktop/Controls/bm-getstate">BM_GETSTATE</a> message explicitly. 



## -parameters




### -param hwndCtl

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">HWND</a></b>

A handle to the button control.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/windowsx/nf-windowsx-button_getcheck">Button_GetCheck</a>



<a href="https://docs.microsoft.com/windows/desktop/api/windowsx/nf-windowsx-button_setstate">Button_SetState</a>



<b>Reference</b>
 

 

