---
UID: NF:windowsx.ComboBox_GetExtendedUI
title: ComboBox_GetExtendedUI macro (windowsx.h)
description: Ascertains whether a combo box is using the default user interface (UI) or the extended UI. You can use this macro or send the CB_GETEXTENDEDUI message explicitly.
old-location: controls\ComboBox_GetExtendedUI.htm
tech.root: Controls
ms.assetid: VS|Controls|~\controls\comboboxes\comboboxreference\comboboxmacros\combobox_getextendedui.htm
ms.date: 12/05/2018
ms.keywords: ComboBox_GetExtendedUI, ComboBox_GetExtendedUI macro [Windows Controls], _win32_ComboBox_GetExtendedUI, _win32_ComboBox_GetExtendedUI_cpp, controls.ComboBox_GetExtendedUI, controls._win32_ComboBox_GetExtendedUI, windowsx/ComboBox_GetExtendedUI
f1_keywords:
- windowsx/ComboBox_GetExtendedUI
dev_langs:
- c++
req.header: windowsx.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Windowsx.h
api_name:
- ComboBox_GetExtendedUI
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ComboBox_GetExtendedUI macro


## -description


Ascertains whether a combo box is using the default user interface (UI) or the extended UI. You can use this macro or send the <a href="https://docs.microsoft.com/windows/desktop/Controls/cb-getextendedui">CB_GETEXTENDEDUI</a> message explicitly.


## -parameters




### -param hwndCtl

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">HWND</a></b>

A handle to the control.


## -remarks



For more information, see <a href="https://docs.microsoft.com/windows/desktop/Controls/cb-getextendedui">CB_GETEXTENDEDUI</a>.
	



